/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.lighting;

import net.minecraft.core.BaseBlockPosition;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.SectionPosition;
import net.minecraft.util.DataBits;
import net.minecraft.util.MathHelper;
import net.minecraft.util.SimpleBitStorage;
import net.minecraft.world.level.IBlockAccess;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.chunk.ChunkSection;
import net.minecraft.world.level.chunk.IChunkAccess;
import net.minecraft.world.level.lighting.LightEngine;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapes;

public class ChunkSkyLightSources {
    private static final int SIZE = 16;
    public static final int NEGATIVE_INFINITY = Integer.MIN_VALUE;
    private final int minY;
    private final DataBits heightmap;
    private final BlockPosition.MutableBlockPosition mutablePos1 = new BlockPosition.MutableBlockPosition();
    private final BlockPosition.MutableBlockPosition mutablePos2 = new BlockPosition.MutableBlockPosition();

    public ChunkSkyLightSources(LevelHeightAccessor var0) {
        this.minY = var0.getMinBuildHeight() - 1;
        int var1 = var0.getMaxBuildHeight();
        int var2 = MathHelper.ceillog2(var1 - this.minY + 1);
        this.heightmap = new SimpleBitStorage(var2, 256);
    }

    public void fillFrom(IChunkAccess var0) {
        int var1 = var0.getHighestFilledSectionIndex();
        if (var1 == -1) {
            this.fill(this.minY);
            return;
        }
        for (int var2 = 0; var2 < 16; ++var2) {
            for (int var3 = 0; var3 < 16; ++var3) {
                int var4 = Math.max(this.findLowestSourceY(var0, var1, var3, var2), this.minY);
                this.set(ChunkSkyLightSources.index(var3, var2), var4);
            }
        }
    }

    private int findLowestSourceY(IChunkAccess var0, int var1, int var2, int var3) {
        int var4 = SectionPosition.sectionToBlockCoord(var0.getSectionYFromSectionIndex(var1) + 1);
        BlockPosition.MutableBlockPosition var5 = this.mutablePos1.set(var2, var4, var3);
        BlockPosition.MutableBlockPosition var6 = this.mutablePos2.setWithOffset((BaseBlockPosition)var5, EnumDirection.DOWN);
        IBlockData var7 = Blocks.AIR.defaultBlockState();
        for (int var8 = var1; var8 >= 0; --var8) {
            int var10;
            ChunkSection var9 = var0.getSection(var8);
            if (var9.hasOnlyAir()) {
                var7 = Blocks.AIR.defaultBlockState();
                var10 = var0.getSectionYFromSectionIndex(var8);
                var5.setY(SectionPosition.sectionToBlockCoord(var10));
                var6.setY(var5.getY() - 1);
                continue;
            }
            for (var10 = 15; var10 >= 0; --var10) {
                IBlockData var11 = var9.getBlockState(var2, var10, var3);
                if (ChunkSkyLightSources.isEdgeOccluded(var0, var5, var7, var6, var11)) {
                    return var5.getY();
                }
                var7 = var11;
                var5.set(var6);
                var6.move(EnumDirection.DOWN);
            }
        }
        return this.minY;
    }

    public boolean update(IBlockAccess var0, int var1, int var2, int var3) {
        IBlockData var10;
        BlockPosition.MutableBlockPosition var9;
        IBlockData var8;
        int var4 = var2 + 1;
        int var5 = ChunkSkyLightSources.index(var1, var3);
        int var6 = this.get(var5);
        if (var4 < var6) {
            return false;
        }
        BlockPosition.MutableBlockPosition var7 = this.mutablePos1.set(var1, var2 + 1, var3);
        if (this.updateEdge(var0, var5, var6, var7, var8 = var0.getBlockState(var7), var9 = this.mutablePos2.set(var1, var2, var3), var10 = var0.getBlockState(var9))) {
            return true;
        }
        BlockPosition.MutableBlockPosition var11 = this.mutablePos1.set(var1, var2 - 1, var3);
        IBlockData var12 = var0.getBlockState(var11);
        return this.updateEdge(var0, var5, var6, var9, var10, var11, var12);
    }

    private boolean updateEdge(IBlockAccess var0, int var1, int var2, BlockPosition var3, IBlockData var4, BlockPosition var5, IBlockData var6) {
        int var7 = var3.getY();
        if (ChunkSkyLightSources.isEdgeOccluded(var0, var3, var4, var5, var6)) {
            if (var7 > var2) {
                this.set(var1, var7);
                return true;
            }
        } else if (var7 == var2) {
            this.set(var1, this.findLowestSourceBelow(var0, var5, var6));
            return true;
        }
        return false;
    }

    private int findLowestSourceBelow(IBlockAccess var0, BlockPosition var1, IBlockData var2) {
        BlockPosition.MutableBlockPosition var3 = this.mutablePos1.set(var1);
        BlockPosition.MutableBlockPosition var4 = this.mutablePos2.setWithOffset((BaseBlockPosition)var1, EnumDirection.DOWN);
        IBlockData var5 = var2;
        while (var4.getY() >= this.minY) {
            IBlockData var6 = var0.getBlockState(var4);
            if (ChunkSkyLightSources.isEdgeOccluded(var0, var3, var5, var4, var6)) {
                return var3.getY();
            }
            var5 = var6;
            var3.set(var4);
            var4.move(EnumDirection.DOWN);
        }
        return this.minY;
    }

    private static boolean isEdgeOccluded(IBlockAccess var0, BlockPosition var1, IBlockData var2, BlockPosition var3, IBlockData var4) {
        if (var4.getLightBlock(var0, var3) != 0) {
            return true;
        }
        VoxelShape var5 = LightEngine.getOcclusionShape(var0, var1, var2, EnumDirection.DOWN);
        VoxelShape var6 = LightEngine.getOcclusionShape(var0, var3, var4, EnumDirection.UP);
        return VoxelShapes.faceShapeOccludes(var5, var6);
    }

    public int getLowestSourceY(int var0, int var1) {
        int var2 = this.get(ChunkSkyLightSources.index(var0, var1));
        return this.extendSourcesBelowWorld(var2);
    }

    public int getHighestLowestSourceY() {
        int var0 = Integer.MIN_VALUE;
        for (int var1 = 0; var1 < this.heightmap.getSize(); ++var1) {
            int var2 = this.heightmap.get(var1);
            if (var2 <= var0) continue;
            var0 = var2;
        }
        return this.extendSourcesBelowWorld(var0 + this.minY);
    }

    private void fill(int var0) {
        int var1 = var0 - this.minY;
        for (int var2 = 0; var2 < this.heightmap.getSize(); ++var2) {
            this.heightmap.set(var2, var1);
        }
    }

    private void set(int var0, int var1) {
        this.heightmap.set(var0, var1 - this.minY);
    }

    private int get(int var0) {
        return this.heightmap.get(var0) + this.minY;
    }

    private int extendSourcesBelowWorld(int var0) {
        if (var0 == this.minY) {
            return Integer.MIN_VALUE;
        }
        return var0;
    }

    private static int index(int var0, int var1) {
        return var0 + var1 * 16;
    }
}

