/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot;

import com.google.common.collect.ImmutableSet;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.MathHelper;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public class IntRange {
    private static final Codec<IntRange> RECORD_CODEC = RecordCodecBuilder.create(var02 -> var02.group((App)NumberProviders.CODEC.optionalFieldOf("min").forGetter(var0 -> Optional.ofNullable(var0.min)), (App)NumberProviders.CODEC.optionalFieldOf("max").forGetter(var0 -> Optional.ofNullable(var0.max))).apply((Applicative)var02, IntRange::new));
    public static final Codec<IntRange> CODEC = Codec.either((Codec)Codec.INT, RECORD_CODEC).xmap(var0 -> (IntRange)var0.map(IntRange::exact, Function.identity()), var0 -> {
        OptionalInt var1 = var0.unpackExact();
        if (var1.isPresent()) {
            return Either.left((Object)var1.getAsInt());
        }
        return Either.right((Object)var0);
    });
    @Nullable
    private final NumberProvider min;
    @Nullable
    private final NumberProvider max;
    private final b limiter;
    private final a predicate;

    public Set<LootContextParameter<?>> getReferencedContextParams() {
        ImmutableSet.Builder var0 = ImmutableSet.builder();
        if (this.min != null) {
            var0.addAll(this.min.getReferencedContextParams());
        }
        if (this.max != null) {
            var0.addAll(this.max.getReferencedContextParams());
        }
        return var0.build();
    }

    private IntRange(Optional<NumberProvider> var0, Optional<NumberProvider> var1) {
        this((NumberProvider)var0.orElse(null), (NumberProvider)var1.orElse(null));
    }

    private IntRange(@Nullable NumberProvider var02, @Nullable NumberProvider var12) {
        this.min = var02;
        this.max = var12;
        if (var02 == null) {
            if (var12 == null) {
                this.limiter = (var0, var1) -> var1;
                this.predicate = (var0, var1) -> true;
            } else {
                this.limiter = (var1, var2) -> Math.min(var12.getInt(var1), var2);
                this.predicate = (var1, var2) -> var2 <= var12.getInt(var1);
            }
        } else if (var12 == null) {
            this.limiter = (var1, var2) -> Math.max(var02.getInt(var1), var2);
            this.predicate = (var1, var2) -> var2 >= var02.getInt(var1);
        } else {
            this.limiter = (var2, var3) -> MathHelper.clamp(var3, var02.getInt(var2), var12.getInt(var2));
            this.predicate = (var2, var3) -> var3 >= var02.getInt(var2) && var3 <= var12.getInt(var2);
        }
    }

    public static IntRange exact(int var0) {
        ConstantValue var1 = ConstantValue.exactly(var0);
        return new IntRange(Optional.of(var1), Optional.of(var1));
    }

    public static IntRange range(int var0, int var1) {
        return new IntRange(Optional.of(ConstantValue.exactly(var0)), Optional.of(ConstantValue.exactly(var1)));
    }

    public static IntRange lowerBound(int var0) {
        return new IntRange(Optional.of(ConstantValue.exactly(var0)), Optional.empty());
    }

    public static IntRange upperBound(int var0) {
        return new IntRange(Optional.empty(), Optional.of(ConstantValue.exactly(var0)));
    }

    public int clamp(LootTableInfo var0, int var1) {
        return this.limiter.apply(var0, var1);
    }

    public boolean test(LootTableInfo var0, int var1) {
        return this.predicate.test(var0, var1);
    }

    private OptionalInt unpackExact() {
        ConstantValue var0;
        NumberProvider numberProvider;
        if (Objects.equals(this.min, this.max) && (numberProvider = this.min) instanceof ConstantValue && Math.floor((var0 = (ConstantValue)numberProvider).value()) == (double)var0.value()) {
            return OptionalInt.of((int)var0.value());
        }
        return OptionalInt.empty();
    }

    @FunctionalInterface
    static interface b {
        public int apply(LootTableInfo var1, int var2);
    }

    @FunctionalInterface
    static interface a {
        public boolean test(LootTableInfo var1, int var2);
    }
}

