/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.functions;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import net.minecraft.advancements.critereon.CriterionConditionItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.functions.LootItemFunction;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionConditional;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctionType;
import net.minecraft.world.level.storage.loot.functions.LootItemFunctions;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;

public class FilteredFunction
extends LootItemFunctionConditional {
    public static final MapCodec<FilteredFunction> CODEC = RecordCodecBuilder.mapCodec(var02 -> FilteredFunction.commonFields(var02).and(var02.group((App)CriterionConditionItem.CODEC.fieldOf("item_filter").forGetter(var0 -> var0.filter), (App)LootItemFunctions.ROOT_CODEC.fieldOf("modifier").forGetter(var0 -> var0.modifier))).apply((Applicative)var02, FilteredFunction::new));
    private final CriterionConditionItem filter;
    private final LootItemFunction modifier;

    private FilteredFunction(List<LootItemCondition> var0, CriterionConditionItem var1, LootItemFunction var2) {
        super(var0);
        this.filter = var1;
        this.modifier = var2;
    }

    public LootItemFunctionType<FilteredFunction> getType() {
        return LootItemFunctions.FILTERED;
    }

    @Override
    public ItemStack run(ItemStack var0, LootTableInfo var1) {
        if (this.filter.test(var0)) {
            return (ItemStack)this.modifier.apply(var0, var1);
        }
        return var0;
    }

    @Override
    public void validate(LootCollector var0) {
        super.validate(var0);
        this.modifier.validate(var0.forChild(".modifier"));
    }
}

