/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.level.storage.loot.providers.number;

import com.google.common.collect.Sets;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Set;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.storage.loot.LootTableInfo;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameter;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.LootNumberProviderType;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;
import net.minecraft.world.level.storage.loot.providers.number.NumberProviders;

public record BinomialDistributionGenerator(NumberProvider n, NumberProvider p) implements NumberProvider
{
    public static final MapCodec<BinomialDistributionGenerator> CODEC = RecordCodecBuilder.mapCodec(var0 -> var0.group((App)NumberProviders.CODEC.fieldOf("n").forGetter(BinomialDistributionGenerator::n), (App)NumberProviders.CODEC.fieldOf("p").forGetter(BinomialDistributionGenerator::p)).apply((Applicative)var0, BinomialDistributionGenerator::new));

    @Override
    public LootNumberProviderType getType() {
        return NumberProviders.BINOMIAL;
    }

    @Override
    public int getInt(LootTableInfo var0) {
        int var1 = this.n.getInt(var0);
        float var2 = this.p.getFloat(var0);
        RandomSource var3 = var0.getRandom();
        int var4 = 0;
        for (int var5 = 0; var5 < var1; ++var5) {
            if (!(var3.nextFloat() < var2)) continue;
            ++var4;
        }
        return var4;
    }

    @Override
    public float getFloat(LootTableInfo var0) {
        return this.getInt(var0);
    }

    public static BinomialDistributionGenerator binomial(int var0, float var1) {
        return new BinomialDistributionGenerator(ConstantValue.exactly(var0), ConstantValue.exactly(var1));
    }

    @Override
    public Set<LootContextParameter<?>> getReferencedContextParams() {
        return Sets.union(this.n.getReferencedContextParams(), this.p.getReferencedContextParams());
    }
}

