/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.world.phys.shapes;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.math.DoubleMath;
import com.google.common.math.IntMath;
import it.unimi.dsi.fastutil.doubles.DoubleArrayList;
import it.unimi.dsi.fastutil.doubles.DoubleList;
import java.util.Arrays;
import java.util.Objects;
import net.minecraft.SystemUtils;
import net.minecraft.core.EnumAxisCycle;
import net.minecraft.core.EnumDirection;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.shapes.OperatorBoolean;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraft.world.phys.shapes.VoxelShapeArray;
import net.minecraft.world.phys.shapes.VoxelShapeBitSet;
import net.minecraft.world.phys.shapes.VoxelShapeCube;
import net.minecraft.world.phys.shapes.VoxelShapeCubeMerger;
import net.minecraft.world.phys.shapes.VoxelShapeCubePoint;
import net.minecraft.world.phys.shapes.VoxelShapeDiscrete;
import net.minecraft.world.phys.shapes.VoxelShapeMerger;
import net.minecraft.world.phys.shapes.VoxelShapeMergerDisjoint;
import net.minecraft.world.phys.shapes.VoxelShapeMergerIdentical;
import net.minecraft.world.phys.shapes.VoxelShapeMergerList;
import net.minecraft.world.phys.shapes.VoxelShapeSlice;

public final class VoxelShapes {
    public static final double EPSILON = 1.0E-7;
    public static final double BIG_EPSILON = 1.0E-6;
    private static final VoxelShape BLOCK = SystemUtils.make(() -> {
        VoxelShapeBitSet var0 = new VoxelShapeBitSet(1, 1, 1);
        ((VoxelShapeDiscrete)var0).fill(0, 0, 0);
        return new VoxelShapeCube(var0);
    });
    public static final VoxelShape INFINITY = VoxelShapes.box(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY, Double.POSITIVE_INFINITY);
    private static final VoxelShape EMPTY = new VoxelShapeArray((VoxelShapeDiscrete)new VoxelShapeBitSet(0, 0, 0), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}), (DoubleList)new DoubleArrayList(new double[]{0.0}));

    public static VoxelShape empty() {
        return EMPTY;
    }

    public static VoxelShape block() {
        return BLOCK;
    }

    public static VoxelShape box(double var0, double var2, double var4, double var6, double var8, double var10) {
        if (var0 > var6 || var2 > var8 || var4 > var10) {
            throw new IllegalArgumentException("The min values need to be smaller or equals to the max values");
        }
        return VoxelShapes.create(var0, var2, var4, var6, var8, var10);
    }

    public static VoxelShape create(double var0, double var2, double var4, double var6, double var8, double var10) {
        if (var6 - var0 < 1.0E-7 || var8 - var2 < 1.0E-7 || var10 - var4 < 1.0E-7) {
            return VoxelShapes.empty();
        }
        int var12 = VoxelShapes.findBits(var0, var6);
        int var13 = VoxelShapes.findBits(var2, var8);
        int var14 = VoxelShapes.findBits(var4, var10);
        if (var12 < 0 || var13 < 0 || var14 < 0) {
            return new VoxelShapeArray(VoxelShapes.BLOCK.shape, (DoubleList)DoubleArrayList.wrap((double[])new double[]{var0, var6}), (DoubleList)DoubleArrayList.wrap((double[])new double[]{var2, var8}), (DoubleList)DoubleArrayList.wrap((double[])new double[]{var4, var10}));
        }
        if (var12 == 0 && var13 == 0 && var14 == 0) {
            return VoxelShapes.block();
        }
        int var15 = 1 << var12;
        int var16 = 1 << var13;
        int var17 = 1 << var14;
        VoxelShapeBitSet var18 = VoxelShapeBitSet.withFilledBounds(var15, var16, var17, (int)Math.round(var0 * (double)var15), (int)Math.round(var2 * (double)var16), (int)Math.round(var4 * (double)var17), (int)Math.round(var6 * (double)var15), (int)Math.round(var8 * (double)var16), (int)Math.round(var10 * (double)var17));
        return new VoxelShapeCube(var18);
    }

    public static VoxelShape create(AxisAlignedBB var0) {
        return VoxelShapes.create(var0.minX, var0.minY, var0.minZ, var0.maxX, var0.maxY, var0.maxZ);
    }

    @VisibleForTesting
    protected static int findBits(double var0, double var2) {
        if (var0 < -1.0E-7 || var2 > 1.0000001) {
            return -1;
        }
        for (int var4 = 0; var4 <= 3; ++var4) {
            boolean var11;
            int var5 = 1 << var4;
            double var6 = var0 * (double)var5;
            double var8 = var2 * (double)var5;
            boolean var10 = Math.abs(var6 - (double)Math.round(var6)) < 1.0E-7 * (double)var5;
            boolean bl = var11 = Math.abs(var8 - (double)Math.round(var8)) < 1.0E-7 * (double)var5;
            if (!var10 || !var11) continue;
            return var4;
        }
        return -1;
    }

    protected static long lcm(int var0, int var1) {
        return (long)var0 * (long)(var1 / IntMath.gcd((int)var0, (int)var1));
    }

    public static VoxelShape or(VoxelShape var0, VoxelShape var1) {
        return VoxelShapes.join(var0, var1, OperatorBoolean.OR);
    }

    public static VoxelShape or(VoxelShape var0, VoxelShape ... var1) {
        return Arrays.stream(var1).reduce(var0, VoxelShapes::or);
    }

    public static VoxelShape join(VoxelShape var0, VoxelShape var1, OperatorBoolean var2) {
        return VoxelShapes.joinUnoptimized(var0, var1, var2).optimize();
    }

    public static VoxelShape joinUnoptimized(VoxelShape var0, VoxelShape var1, OperatorBoolean var2) {
        if (var2.apply(false, false)) {
            throw SystemUtils.pauseInIde(new IllegalArgumentException());
        }
        if (var0 == var1) {
            return var2.apply(true, true) ? var0 : VoxelShapes.empty();
        }
        boolean var3 = var2.apply(true, false);
        boolean var4 = var2.apply(false, true);
        if (var0.isEmpty()) {
            return var4 ? var1 : VoxelShapes.empty();
        }
        if (var1.isEmpty()) {
            return var3 ? var0 : VoxelShapes.empty();
        }
        VoxelShapeMerger var5 = VoxelShapes.createIndexMerger(1, var0.getCoords(EnumDirection.EnumAxis.X), var1.getCoords(EnumDirection.EnumAxis.X), var3, var4);
        VoxelShapeMerger var6 = VoxelShapes.createIndexMerger(var5.size() - 1, var0.getCoords(EnumDirection.EnumAxis.Y), var1.getCoords(EnumDirection.EnumAxis.Y), var3, var4);
        VoxelShapeMerger var7 = VoxelShapes.createIndexMerger((var5.size() - 1) * (var6.size() - 1), var0.getCoords(EnumDirection.EnumAxis.Z), var1.getCoords(EnumDirection.EnumAxis.Z), var3, var4);
        VoxelShapeBitSet var8 = VoxelShapeBitSet.join(var0.shape, var1.shape, var5, var6, var7, var2);
        if (var5 instanceof VoxelShapeCubeMerger && var6 instanceof VoxelShapeCubeMerger && var7 instanceof VoxelShapeCubeMerger) {
            return new VoxelShapeCube(var8);
        }
        return new VoxelShapeArray((VoxelShapeDiscrete)var8, var5.getList(), var6.getList(), var7.getList());
    }

    public static boolean joinIsNotEmpty(VoxelShape var0, VoxelShape var1, OperatorBoolean var2) {
        if (var2.apply(false, false)) {
            throw SystemUtils.pauseInIde(new IllegalArgumentException());
        }
        boolean var3 = var0.isEmpty();
        boolean var4 = var1.isEmpty();
        if (var3 || var4) {
            return var2.apply(!var3, !var4);
        }
        if (var0 == var1) {
            return var2.apply(true, true);
        }
        boolean var5 = var2.apply(true, false);
        boolean var6 = var2.apply(false, true);
        for (EnumDirection.EnumAxis var10 : EnumAxisCycle.AXIS_VALUES) {
            if (var0.max(var10) < var1.min(var10) - 1.0E-7) {
                return var5 || var6;
            }
            if (!(var1.max(var10) < var0.min(var10) - 1.0E-7)) continue;
            return var5 || var6;
        }
        VoxelShapeMerger var7 = VoxelShapes.createIndexMerger(1, var0.getCoords(EnumDirection.EnumAxis.X), var1.getCoords(EnumDirection.EnumAxis.X), var5, var6);
        VoxelShapeMerger var8 = VoxelShapes.createIndexMerger(var7.size() - 1, var0.getCoords(EnumDirection.EnumAxis.Y), var1.getCoords(EnumDirection.EnumAxis.Y), var5, var6);
        VoxelShapeMerger var9 = VoxelShapes.createIndexMerger((var7.size() - 1) * (var8.size() - 1), var0.getCoords(EnumDirection.EnumAxis.Z), var1.getCoords(EnumDirection.EnumAxis.Z), var5, var6);
        return VoxelShapes.joinIsNotEmpty(var7, var8, var9, var0.shape, var1.shape, var2);
    }

    private static boolean joinIsNotEmpty(VoxelShapeMerger var0, VoxelShapeMerger var1, VoxelShapeMerger var2, VoxelShapeDiscrete var3, VoxelShapeDiscrete var4, OperatorBoolean var52) {
        return !var0.forMergedIndexes((var5, var62, var7) -> var1.forMergedIndexes((var6, var72, var82) -> var2.forMergedIndexes((var7, var8, var9) -> !var52.apply(var3.isFullWide(var5, var6, var7), var4.isFullWide(var62, var72, var8)))));
    }

    public static double collide(EnumDirection.EnumAxis var0, AxisAlignedBB var1, Iterable<VoxelShape> var2, double var3) {
        for (VoxelShape var6 : var2) {
            if (Math.abs(var3) < 1.0E-7) {
                return 0.0;
            }
            var3 = var6.collide(var0, var1, var3);
        }
        return var3;
    }

    public static boolean blockOccudes(VoxelShape var0, VoxelShape var1, EnumDirection var2) {
        if (var0 == VoxelShapes.block() && var1 == VoxelShapes.block()) {
            return true;
        }
        if (var1.isEmpty()) {
            return false;
        }
        EnumDirection.EnumAxis var3 = var2.getAxis();
        EnumDirection.EnumAxisDirection var4 = var2.getAxisDirection();
        VoxelShape var5 = var4 == EnumDirection.EnumAxisDirection.POSITIVE ? var0 : var1;
        VoxelShape var6 = var4 == EnumDirection.EnumAxisDirection.POSITIVE ? var1 : var0;
        OperatorBoolean var7 = var4 == EnumDirection.EnumAxisDirection.POSITIVE ? OperatorBoolean.ONLY_FIRST : OperatorBoolean.ONLY_SECOND;
        return DoubleMath.fuzzyEquals((double)var5.max(var3), (double)1.0, (double)1.0E-7) && DoubleMath.fuzzyEquals((double)var6.min(var3), (double)0.0, (double)1.0E-7) && !VoxelShapes.joinIsNotEmpty(new VoxelShapeSlice(var5, var3, var5.shape.getSize(var3) - 1), new VoxelShapeSlice(var6, var3, 0), var7);
    }

    public static VoxelShape getFaceShape(VoxelShape var0, EnumDirection var1) {
        int var3;
        boolean var2;
        if (var0 == VoxelShapes.block()) {
            return VoxelShapes.block();
        }
        EnumDirection.EnumAxis var4 = var1.getAxis();
        if (var1.getAxisDirection() == EnumDirection.EnumAxisDirection.POSITIVE) {
            var2 = DoubleMath.fuzzyEquals((double)var0.max(var4), (double)1.0, (double)1.0E-7);
            var3 = var0.shape.getSize(var4) - 1;
        } else {
            var2 = DoubleMath.fuzzyEquals((double)var0.min(var4), (double)0.0, (double)1.0E-7);
            var3 = 0;
        }
        if (!var2) {
            return VoxelShapes.empty();
        }
        return new VoxelShapeSlice(var0, var4, var3);
    }

    public static boolean mergedFaceOccludes(VoxelShape var0, VoxelShape var1, EnumDirection var2) {
        VoxelShape var6;
        if (var0 == VoxelShapes.block() || var1 == VoxelShapes.block()) {
            return true;
        }
        EnumDirection.EnumAxis var3 = var2.getAxis();
        EnumDirection.EnumAxisDirection var4 = var2.getAxisDirection();
        VoxelShape var5 = var4 == EnumDirection.EnumAxisDirection.POSITIVE ? var0 : var1;
        VoxelShape voxelShape = var6 = var4 == EnumDirection.EnumAxisDirection.POSITIVE ? var1 : var0;
        if (!DoubleMath.fuzzyEquals((double)var5.max(var3), (double)1.0, (double)1.0E-7)) {
            var5 = VoxelShapes.empty();
        }
        if (!DoubleMath.fuzzyEquals((double)var6.min(var3), (double)0.0, (double)1.0E-7)) {
            var6 = VoxelShapes.empty();
        }
        return !VoxelShapes.joinIsNotEmpty(VoxelShapes.block(), VoxelShapes.joinUnoptimized(new VoxelShapeSlice(var5, var3, var5.shape.getSize(var3) - 1), new VoxelShapeSlice(var6, var3, 0), OperatorBoolean.OR), OperatorBoolean.ONLY_FIRST);
    }

    public static boolean faceShapeOccludes(VoxelShape var0, VoxelShape var1) {
        if (var0 == VoxelShapes.block() || var1 == VoxelShapes.block()) {
            return true;
        }
        if (var0.isEmpty() && var1.isEmpty()) {
            return false;
        }
        return !VoxelShapes.joinIsNotEmpty(VoxelShapes.block(), VoxelShapes.joinUnoptimized(var0, var1, OperatorBoolean.OR), OperatorBoolean.ONLY_FIRST);
    }

    @VisibleForTesting
    protected static VoxelShapeMerger createIndexMerger(int var0, DoubleList var1, DoubleList var2, boolean var3, boolean var4) {
        long var7;
        int var5 = var1.size() - 1;
        int var6 = var2.size() - 1;
        if (var1 instanceof VoxelShapeCubePoint && var2 instanceof VoxelShapeCubePoint && (long)var0 * (var7 = VoxelShapes.lcm(var5, var6)) <= 256L) {
            return new VoxelShapeCubeMerger(var5, var6);
        }
        if (var1.getDouble(var5) < var2.getDouble(0) - 1.0E-7) {
            return new VoxelShapeMergerDisjoint(var1, var2, false);
        }
        if (var2.getDouble(var6) < var1.getDouble(0) - 1.0E-7) {
            return new VoxelShapeMergerDisjoint(var2, var1, true);
        }
        if (var5 == var6 && Objects.equals(var1, var2)) {
            return new VoxelShapeMergerIdentical(var1);
        }
        return new VoxelShapeMergerList(var1, var2, var3, var4);
    }

    public static interface a {
        public void consume(double var1, double var3, double var5, double var7, double var9, double var11);
    }
}

