/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.minecraft.item.data;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.Holder;
import com.viaversion.viaversion.api.minecraft.HolderSet;
import com.viaversion.viaversion.api.minecraft.RegistryKey;
import com.viaversion.viaversion.api.minecraft.SoundEvent;
import com.viaversion.viaversion.api.minecraft.codec.Ops;
import com.viaversion.viaversion.api.protocol.Protocol;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.Types;
import com.viaversion.viaversion.api.type.types.ArrayType;
import com.viaversion.viaversion.api.type.types.misc.HolderSetType;
import com.viaversion.viaversion.util.Key;
import com.viaversion.viaversion.util.Rewritable;
import io.netty.buffer.ByteBuf;
import org.checkerframework.checker.nullness.qual.Nullable;

public record BlocksAttacks(float blockDelaySeconds, float disableCooldownScale, DamageReduction[] damageReductions, ItemDamageFunction itemDamage, @Nullable String bypassedByTag, @Nullable Holder<SoundEvent> blockSound, @Nullable Holder<SoundEvent> disableSound) implements Rewritable
{
    public static final Type<BlocksAttacks> TYPE = new Type<BlocksAttacks>(BlocksAttacks.class){

        @Override
        public BlocksAttacks read(ByteBuf buffer) {
            float blockDelaySeconds = buffer.readFloat();
            float disableCooldownScale = buffer.readFloat();
            DamageReduction[] damageReductions = DamageReduction.ARRAY_TYPE.read(buffer);
            ItemDamageFunction itemDamage = (ItemDamageFunction)ItemDamageFunction.TYPE.read(buffer);
            String bypassedByTag = (String)Types.OPTIONAL_STRING.read(buffer);
            Object blockSound = Types.OPTIONAL_SOUND_EVENT.read(buffer);
            Object disableSound = Types.OPTIONAL_SOUND_EVENT.read(buffer);
            return new BlocksAttacks(blockDelaySeconds, disableCooldownScale, damageReductions, itemDamage, bypassedByTag, (Holder<SoundEvent>)blockSound, (Holder<SoundEvent>)disableSound);
        }

        @Override
        public void write(ByteBuf buffer, BlocksAttacks value) {
            buffer.writeFloat(value.blockDelaySeconds());
            buffer.writeFloat(value.disableCooldownScale());
            DamageReduction.ARRAY_TYPE.write(buffer, (T[])value.damageReductions());
            ItemDamageFunction.TYPE.write(buffer, value.itemDamage());
            Types.OPTIONAL_STRING.write(buffer, value.bypassedByTag());
            Types.OPTIONAL_SOUND_EVENT.write(buffer, value.blockSound());
            Types.OPTIONAL_SOUND_EVENT.write(buffer, value.disableSound());
        }

        @Override
        public void write(Ops ops, BlocksAttacks value) {
            DamageReduction[] defaultDamageReductions = new DamageReduction[]{new DamageReduction(90.0f, null, 0.0f, 1.0f)};
            ItemDamageFunction defaultItemDamage = new ItemDamageFunction(1.0f, 0.0f, 1.0f);
            ops.writeMap(map -> map.writeOptional("block_delay_seconds", Types.FLOAT, Float.valueOf(value.blockDelaySeconds()), Float.valueOf(0.0f)).writeOptional("disable_cooldown_scale", Types.FLOAT, Float.valueOf(value.disableCooldownScale()), Float.valueOf(1.0f)).writeOptional("damage_reductions", DamageReduction.ARRAY_TYPE, value.damageReductions(), defaultDamageReductions).writeOptional("item_damage", ItemDamageFunction.TYPE, value.itemDamage(), defaultItemDamage).writeOptional("bypassed_by", Types.TAG_KEY, value.bypassedByTag() != null ? Key.of(value.bypassedByTag()) : null).writeOptional("block_sound", Types.SOUND_EVENT, value.blockSound()).writeOptional("disabled_sound", Types.SOUND_EVENT, value.disableSound()));
        }
    };

    @Override
    public BlocksAttacks rewrite(UserConnection connection, Protocol<?, ?, ?, ?> protocol, boolean clientbound) {
        Holder<SoundEvent> blockSound = SoundEvent.rewriteHolder(this.blockSound, Rewritable.soundRewriteFunction(protocol, clientbound));
        Holder<SoundEvent> disableSound = SoundEvent.rewriteHolder(this.disableSound, Rewritable.soundRewriteFunction(protocol, clientbound));
        return new BlocksAttacks(this.blockDelaySeconds, this.disableCooldownScale, this.damageReductions, this.itemDamage, this.bypassedByTag, blockSound, disableSound);
    }

    public record DamageReduction(float horizontalBlockingAngle, @Nullable HolderSet type, float base, float factor) {
        public static final Type<DamageReduction> TYPE = new Type<DamageReduction>(DamageReduction.class){

            @Override
            public DamageReduction read(ByteBuf buffer) {
                float horizontalBlockingAngle = buffer.readFloat();
                HolderSet type = (HolderSet)Types.OPTIONAL_HOLDER_SET.read(buffer);
                float base = buffer.readFloat();
                float factor = buffer.readFloat();
                return new DamageReduction(horizontalBlockingAngle, type, base, factor);
            }

            @Override
            public void write(ByteBuf buffer, DamageReduction value) {
                buffer.writeFloat(value.horizontalBlockingAngle());
                Types.OPTIONAL_HOLDER_SET.write(buffer, value.type());
                buffer.writeFloat(value.base());
                buffer.writeFloat(value.factor());
            }

            @Override
            public void write(Ops ops, DamageReduction value) {
                ops.writeMap(map -> map.writeOptional("horizontal_blocking_angle", Types.FLOAT, Float.valueOf(value.horizontalBlockingAngle()), Float.valueOf(90.0f)).writeOptional("type", new HolderSetType(RegistryKey.of("damage_type")), value.type()).write("base", Types.FLOAT, Float.valueOf(value.base())).write("factor", Types.FLOAT, Float.valueOf(value.factor())));
            }
        };
        public static final ArrayType<DamageReduction> ARRAY_TYPE = new ArrayType<DamageReduction>(TYPE);
    }

    public record ItemDamageFunction(float threshold, float base, float factor) {
        public static final Type<ItemDamageFunction> TYPE = new Type<ItemDamageFunction>(ItemDamageFunction.class){

            @Override
            public ItemDamageFunction read(ByteBuf buffer) {
                float threshold = buffer.readFloat();
                float base = buffer.readFloat();
                float factor = buffer.readFloat();
                return new ItemDamageFunction(threshold, base, factor);
            }

            @Override
            public void write(ByteBuf buffer, ItemDamageFunction value) {
                buffer.writeFloat(value.threshold());
                buffer.writeFloat(value.base());
                buffer.writeFloat(value.factor());
            }

            @Override
            public void write(Ops ops, ItemDamageFunction value) {
                ops.writeMap(map -> map.write("threshold", Types.FLOAT, Float.valueOf(value.threshold())).write("base", Types.FLOAT, Float.valueOf(value.base())).write("factor", Types.FLOAT, Float.valueOf(value.factor())));
            }
        };
    }
}

