/*
 * Decompiled with CFR 0.152.
 */
package com.viaversion.viaversion.api.type.types;

import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.TypeConverter;
import io.netty.buffer.ByteBuf;

public class UnsignedIntType
extends Type<Long>
implements TypeConverter<Long> {
    public static final long MAX_UNSIGNED_INT = 0xFFFFFFFFL;

    public UnsignedIntType() {
        super(Long.class);
    }

    @Override
    public Long read(ByteBuf buffer) {
        return buffer.readUnsignedInt();
    }

    public long readPrimitive(ByteBuf buffer) {
        return buffer.readUnsignedInt();
    }

    @Override
    public void write(ByteBuf buffer, Long l) {
        buffer.writeInt(l.intValue());
    }

    public void writePrimitive(ByteBuf buffer, long l) {
        buffer.writeInt((int)l);
    }

    @Override
    public Long from(Object o) {
        if (o instanceof Number) {
            Number number = (Number)o;
            return number.longValue();
        }
        if (o instanceof Boolean) {
            Boolean boo = (Boolean)o;
            return boo != false ? 1L : 0L;
        }
        throw new UnsupportedOperationException();
    }
}

