/*
 * Decompiled with CFR 0.152.
 */
package clib.fastutil.fastutil.doubles;

import clib.fastutil.fastutil.HashCommon;
import clib.fastutil.fastutil.Size64;
import clib.fastutil.fastutil.doubles.AbstractDouble2IntFunction;
import clib.fastutil.fastutil.doubles.AbstractDoubleSet;
import clib.fastutil.fastutil.doubles.Double2IntMap;
import clib.fastutil.fastutil.doubles.Double2IntMaps;
import clib.fastutil.fastutil.doubles.DoubleIterator;
import clib.fastutil.fastutil.doubles.DoubleSet;
import clib.fastutil.fastutil.doubles.DoubleSpliterator;
import clib.fastutil.fastutil.doubles.DoubleSpliterators;
import clib.fastutil.fastutil.ints.AbstractIntCollection;
import clib.fastutil.fastutil.ints.IntBinaryOperator;
import clib.fastutil.fastutil.ints.IntCollection;
import clib.fastutil.fastutil.ints.IntIterator;
import clib.fastutil.fastutil.ints.IntSpliterator;
import clib.fastutil.fastutil.ints.IntSpliterators;
import clib.fastutil.fastutil.objects.AbstractObjectSet;
import clib.fastutil.fastutil.objects.ObjectIterator;
import clib.fastutil.fastutil.objects.ObjectSpliterator;
import clib.fastutil.fastutil.objects.ObjectSpliterators;
import java.io.Serializable;
import java.util.Iterator;
import java.util.Map;
import java.util.function.DoubleConsumer;
import java.util.function.IntConsumer;

public abstract class AbstractDouble2IntMap
extends AbstractDouble2IntFunction
implements Double2IntMap,
Serializable {
    private static final long serialVersionUID = -4940583368468432370L;

    protected AbstractDouble2IntMap() {
    }

    @Override
    public boolean containsKey(double k) {
        Iterator i = this.double2IntEntrySet().iterator();
        while (i.hasNext()) {
            if (((Double2IntMap.Entry)i.next()).getDoubleKey() != k) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean containsValue(int v) {
        Iterator i = this.double2IntEntrySet().iterator();
        while (i.hasNext()) {
            if (((Double2IntMap.Entry)i.next()).getIntValue() != v) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public final int mergeInt(double key, int value, IntBinaryOperator remappingFunction) {
        return this.mergeInt(key, value, (java.util.function.IntBinaryOperator)remappingFunction);
    }

    @Override
    public DoubleSet keySet() {
        return new AbstractDoubleSet(){

            @Override
            public boolean contains(double k) {
                return AbstractDouble2IntMap.this.containsKey(k);
            }

            @Override
            public int size() {
                return AbstractDouble2IntMap.this.size();
            }

            @Override
            public void clear() {
                AbstractDouble2IntMap.this.clear();
            }

            @Override
            public DoubleIterator iterator() {
                return new DoubleIterator(){
                    private final ObjectIterator<Double2IntMap.Entry> i;
                    {
                        this.i = Double2IntMaps.fastIterator(AbstractDouble2IntMap.this);
                    }

                    @Override
                    public double nextDouble() {
                        return ((Double2IntMap.Entry)this.i.next()).getDoubleKey();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    @Override
                    public void forEachRemaining(DoubleConsumer action) {
                        this.i.forEachRemaining((? super E entry) -> action.accept(entry.getDoubleKey()));
                    }
                };
            }

            @Override
            public DoubleSpliterator spliterator() {
                return DoubleSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(AbstractDouble2IntMap.this), 321);
            }
        };
    }

    @Override
    public IntCollection values() {
        return new AbstractIntCollection(){

            @Override
            public boolean contains(int k) {
                return AbstractDouble2IntMap.this.containsValue(k);
            }

            @Override
            public int size() {
                return AbstractDouble2IntMap.this.size();
            }

            @Override
            public void clear() {
                AbstractDouble2IntMap.this.clear();
            }

            @Override
            public IntIterator iterator() {
                return new IntIterator(){
                    private final ObjectIterator<Double2IntMap.Entry> i;
                    {
                        this.i = Double2IntMaps.fastIterator(AbstractDouble2IntMap.this);
                    }

                    @Override
                    public int nextInt() {
                        return ((Double2IntMap.Entry)this.i.next()).getIntValue();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.i.hasNext();
                    }

                    @Override
                    public void remove() {
                        this.i.remove();
                    }

                    @Override
                    public void forEachRemaining(IntConsumer action) {
                        this.i.forEachRemaining((? super E entry) -> action.accept(entry.getIntValue()));
                    }
                };
            }

            @Override
            public IntSpliterator spliterator() {
                return IntSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(AbstractDouble2IntMap.this), 320);
            }
        };
    }

    @Override
    public void putAll(Map<? extends Double, ? extends Integer> m) {
        if (m instanceof Double2IntMap) {
            ObjectIterator<Double2IntMap.Entry> i = Double2IntMaps.fastIterator((Double2IntMap)m);
            while (i.hasNext()) {
                Double2IntMap.Entry e = (Double2IntMap.Entry)i.next();
                this.put(e.getDoubleKey(), e.getIntValue());
            }
        } else {
            int n = m.size();
            Iterator<Map.Entry<? extends Double, ? extends Integer>> i = m.entrySet().iterator();
            while (n-- != 0) {
                Map.Entry<? extends Double, ? extends Integer> e = i.next();
                this.put(e.getKey(), e.getValue());
            }
        }
    }

    @Override
    public int hashCode() {
        int h = 0;
        int n = this.size();
        ObjectIterator<Double2IntMap.Entry> i = Double2IntMaps.fastIterator(this);
        while (n-- != 0) {
            h += ((Double2IntMap.Entry)i.next()).hashCode();
        }
        return h;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map m = (Map)o;
        if (m.size() != this.size()) {
            return false;
        }
        return this.double2IntEntrySet().containsAll(m.entrySet());
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        ObjectIterator<Double2IntMap.Entry> i = Double2IntMaps.fastIterator(this);
        int n = this.size();
        boolean first = true;
        s.append("{");
        while (n-- != 0) {
            if (first) {
                first = false;
            } else {
                s.append(", ");
            }
            Double2IntMap.Entry e = (Double2IntMap.Entry)i.next();
            s.append(String.valueOf(e.getDoubleKey()));
            s.append("=>");
            s.append(String.valueOf(e.getIntValue()));
        }
        s.append("}");
        return s.toString();
    }

    public static abstract class BasicEntrySet
    extends AbstractObjectSet<Double2IntMap.Entry> {
        protected final Double2IntMap map;

        public BasicEntrySet(Double2IntMap map) {
            this.map = map;
        }

        @Override
        public boolean contains(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Double2IntMap.Entry) {
                Double2IntMap.Entry e = (Double2IntMap.Entry)o;
                double k = e.getDoubleKey();
                return this.map.containsKey(k) && this.map.get(k) == e.getIntValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            double k = (Double)key;
            Object value = e.getValue();
            if (value == null || !(value instanceof Integer)) {
                return false;
            }
            return this.map.containsKey(k) && this.map.get(k) == ((Integer)value).intValue();
        }

        @Override
        public boolean remove(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Double2IntMap.Entry) {
                Double2IntMap.Entry e = (Double2IntMap.Entry)o;
                return this.map.remove(e.getDoubleKey(), e.getIntValue());
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            double k = (Double)key;
            Object value = e.getValue();
            if (value == null || !(value instanceof Integer)) {
                return false;
            }
            int v = (Integer)value;
            return this.map.remove(k, v);
        }

        @Override
        public int size() {
            return this.map.size();
        }

        @Override
        public ObjectSpliterator<Double2IntMap.Entry> spliterator() {
            return ObjectSpliterators.asSpliterator(this.iterator(), Size64.sizeOf(this.map), 65);
        }
    }

    public static class BasicEntry
    implements Double2IntMap.Entry {
        protected double key;
        protected int value;

        public BasicEntry() {
        }

        public BasicEntry(Double key, Integer value) {
            this.key = key;
            this.value = value;
        }

        public BasicEntry(double key, int value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public double getDoubleKey() {
            return this.key;
        }

        @Override
        public int getIntValue() {
            return this.value;
        }

        @Override
        public int setValue(int value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean equals(Object o) {
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            if (o instanceof Double2IntMap.Entry) {
                Double2IntMap.Entry e = (Double2IntMap.Entry)o;
                return Double.doubleToLongBits(this.key) == Double.doubleToLongBits(e.getDoubleKey()) && this.value == e.getIntValue();
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null || !(key instanceof Double)) {
                return false;
            }
            Object value = e.getValue();
            if (value == null || !(value instanceof Integer)) {
                return false;
            }
            return Double.doubleToLongBits(this.key) == Double.doubleToLongBits((Double)key) && this.value == (Integer)value;
        }

        @Override
        public int hashCode() {
            return HashCommon.double2int(this.key) ^ this.value;
        }

        public String toString() {
            return this.key + "->" + this.value;
        }
    }
}

