/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft;

import com.google.common.collect.Lists;
import com.mojang.logging.LogUtils;
import java.io.BufferedWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.Locale;
import java.util.concurrent.CompletionException;
import javax.annotation.Nullable;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.FileUtils;
import net.minecraft.ReportType;
import net.minecraft.ReportedException;
import net.minecraft.SystemReport;
import net.minecraft.util.MemoryReserve;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.bukkit.craftbukkit.v1_21_R1.CraftCrashReport;
import org.slf4j.Logger;

public class CrashReport {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss", Locale.ROOT);
    private final String title;
    private final Throwable exception;
    private final List<CrashReportSystemDetails> details = Lists.newArrayList();
    @Nullable
    private Path saveFile;
    private boolean trackingStackTrace = true;
    private StackTraceElement[] uncategorizedStackTrace = new StackTraceElement[0];
    private final SystemReport systemReport = new SystemReport();

    public CrashReport(String s2, Throwable throwable) {
        this.title = s2;
        this.exception = throwable;
        this.systemReport.setDetail("CraftBukkit Information", new CraftCrashReport());
    }

    public String getTitle() {
        return this.title;
    }

    public Throwable getException() {
        return this.exception;
    }

    public String getDetails() {
        StringBuilder stringbuilder = new StringBuilder();
        this.getDetails(stringbuilder);
        return stringbuilder.toString();
    }

    public void getDetails(StringBuilder stringbuilder) {
        if (!(this.uncategorizedStackTrace != null && this.uncategorizedStackTrace.length > 0 || this.details.isEmpty())) {
            this.uncategorizedStackTrace = (StackTraceElement[])ArrayUtils.subarray((Object[])this.details.get(0).getStacktrace(), (int)0, (int)1);
        }
        if (this.uncategorizedStackTrace != null && this.uncategorizedStackTrace.length > 0) {
            stringbuilder.append("-- Head --\n");
            stringbuilder.append("Thread: ").append(Thread.currentThread().getName()).append("\n");
            stringbuilder.append("Stacktrace:\n");
            for (StackTraceElement stacktraceelement : this.uncategorizedStackTrace) {
                stringbuilder.append("\t").append("at ").append(stacktraceelement);
                stringbuilder.append("\n");
            }
            stringbuilder.append("\n");
        }
        for (CrashReportSystemDetails crashreportsystemdetails : this.details) {
            crashreportsystemdetails.getDetails(stringbuilder);
            stringbuilder.append("\n\n");
        }
        this.systemReport.appendToCrashReportString(stringbuilder);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getExceptionMessage() {
        String s2;
        StringWriter stringwriter = null;
        PrintWriter printwriter = null;
        Throwable object = this.exception;
        if (object.getMessage() == null) {
            if (object instanceof NullPointerException) {
                object = new NullPointerException(this.title);
            } else if (object instanceof StackOverflowError) {
                object = new StackOverflowError(this.title);
            } else if (object instanceof OutOfMemoryError) {
                object = new OutOfMemoryError(this.title);
            }
            object.setStackTrace(this.exception.getStackTrace());
        }
        try {
            stringwriter = new StringWriter();
            printwriter = new PrintWriter(stringwriter);
            object.printStackTrace(printwriter);
            s2 = stringwriter.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly((Writer)stringwriter);
            IOUtils.closeQuietly(printwriter);
            throw throwable;
        }
        IOUtils.closeQuietly((Writer)stringwriter);
        IOUtils.closeQuietly((Writer)printwriter);
        return s2;
    }

    public String getFriendlyReport(ReportType reporttype, List<String> list) {
        StringBuilder stringbuilder = new StringBuilder();
        reporttype.appendHeader(stringbuilder, list);
        stringbuilder.append("Time: ");
        stringbuilder.append(DATE_TIME_FORMATTER.format(ZonedDateTime.now()));
        stringbuilder.append("\n");
        stringbuilder.append("Description: ");
        stringbuilder.append(this.title);
        stringbuilder.append("\n\n");
        stringbuilder.append(this.getExceptionMessage());
        stringbuilder.append("\n\nA detailed walkthrough of the error, its code path and all known details is as follows:\n");
        for (int i2 = 0; i2 < 87; ++i2) {
            stringbuilder.append("-");
        }
        stringbuilder.append("\n\n");
        this.getDetails(stringbuilder);
        return stringbuilder.toString();
    }

    public String getFriendlyReport(ReportType reporttype) {
        return this.getFriendlyReport(reporttype, List.of());
    }

    @Nullable
    public Path getSaveFile() {
        return this.saveFile;
    }

    public boolean saveToFile(Path path, ReportType reporttype, List<String> list) {
        if (this.saveFile != null) {
            return false;
        }
        try {
            if (path.getParent() != null) {
                FileUtils.createDirectoriesSafe(path.getParent());
            }
            try (BufferedWriter bufferedwriter = Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]);){
                bufferedwriter.write(this.getFriendlyReport(reporttype, list));
            }
            this.saveFile = path;
            return true;
        }
        catch (Throwable throwable2) {
            LOGGER.error("Could not save crash report to {}", (Object)path, (Object)throwable2);
            return false;
        }
    }

    public boolean saveToFile(Path path, ReportType reporttype) {
        return this.saveToFile(path, reporttype, List.of());
    }

    public SystemReport getSystemReport() {
        return this.systemReport;
    }

    public CrashReportSystemDetails addCategory(String s2) {
        return this.addCategory(s2, 1);
    }

    public CrashReportSystemDetails addCategory(String s2, int i2) {
        CrashReportSystemDetails crashreportsystemdetails = new CrashReportSystemDetails(s2);
        if (this.trackingStackTrace) {
            int j2 = crashreportsystemdetails.fillInStackTrace(i2);
            StackTraceElement[] astacktraceelement = this.exception.getStackTrace();
            StackTraceElement stacktraceelement = null;
            StackTraceElement stacktraceelement1 = null;
            int k2 = astacktraceelement.length - j2;
            if (k2 < 0) {
                LOGGER.error("Negative index in crash report handler ({}/{})", (Object)astacktraceelement.length, (Object)j2);
            }
            if (astacktraceelement != null && 0 <= k2 && k2 < astacktraceelement.length) {
                stacktraceelement = astacktraceelement[k2];
                if (astacktraceelement.length + 1 - j2 < astacktraceelement.length) {
                    stacktraceelement1 = astacktraceelement[astacktraceelement.length + 1 - j2];
                }
            }
            this.trackingStackTrace = crashreportsystemdetails.validateStackTrace(stacktraceelement, stacktraceelement1);
            if (astacktraceelement != null && astacktraceelement.length >= j2 && 0 <= k2 && k2 < astacktraceelement.length) {
                this.uncategorizedStackTrace = new StackTraceElement[k2];
                System.arraycopy(astacktraceelement, 0, this.uncategorizedStackTrace, 0, this.uncategorizedStackTrace.length);
            } else {
                this.trackingStackTrace = false;
            }
        }
        this.details.add(crashreportsystemdetails);
        return crashreportsystemdetails;
    }

    public static CrashReport forThrowable(Throwable throwable, String s2) {
        CrashReport crashreport;
        while (throwable instanceof CompletionException && throwable.getCause() != null) {
            throwable = throwable.getCause();
        }
        if (throwable instanceof ReportedException) {
            ReportedException reportedexception = (ReportedException)throwable;
            crashreport = reportedexception.getReport();
        } else {
            crashreport = new CrashReport(s2, throwable);
        }
        return crashreport;
    }

    public static void preload() {
        MemoryReserve.allocate();
        new CrashReport("Don't panic!", new Throwable()).getFriendlyReport(ReportType.CRASH);
    }
}

