/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementNode;
import net.minecraft.resources.MinecraftKey;
import org.slf4j.Logger;

public class AdvancementTree {
    private static final Logger LOGGER = LogUtils.getLogger();
    private final Map<MinecraftKey, AdvancementNode> nodes = new Object2ObjectOpenHashMap();
    private final Set<AdvancementNode> roots = new ObjectLinkedOpenHashSet();
    private final Set<AdvancementNode> tasks = new ObjectLinkedOpenHashSet();
    @Nullable
    private a listener;

    private void remove(AdvancementNode advancementnode) {
        for (AdvancementNode advancementnode1 : advancementnode.children()) {
            this.remove(advancementnode1);
        }
        LOGGER.info("Forgot about advancement {}", (Object)advancementnode.holder());
        this.nodes.remove(advancementnode.holder().id());
        if (advancementnode.parent() == null) {
            this.roots.remove(advancementnode);
            if (this.listener != null) {
                this.listener.onRemoveAdvancementRoot(advancementnode);
            }
        } else {
            this.tasks.remove(advancementnode);
            if (this.listener != null) {
                this.listener.onRemoveAdvancementTask(advancementnode);
            }
        }
    }

    public void remove(Set<MinecraftKey> set) {
        for (MinecraftKey minecraftkey : set) {
            AdvancementNode advancementnode = this.nodes.get(minecraftkey);
            if (advancementnode == null) {
                LOGGER.warn("Told to remove advancement {} but I don't know what that is", (Object)minecraftkey);
                continue;
            }
            this.remove(advancementnode);
        }
    }

    public void addAll(Collection<AdvancementHolder> collection) {
        ArrayList<AdvancementHolder> list = new ArrayList<AdvancementHolder>(collection);
        while (!list.isEmpty()) {
            if (list.removeIf(this::tryInsert)) continue;
            LOGGER.error("Couldn't load advancements: {}", list);
            break;
        }
    }

    private boolean tryInsert(AdvancementHolder advancementholder) {
        Optional<MinecraftKey> optional = advancementholder.value().parent();
        Map<MinecraftKey, AdvancementNode> map = this.nodes;
        Objects.requireNonNull(this.nodes);
        AdvancementNode advancementnode = optional.map(map::get).orElse(null);
        if (advancementnode == null && optional.isPresent()) {
            return false;
        }
        AdvancementNode advancementnode1 = new AdvancementNode(advancementholder, advancementnode);
        if (advancementnode != null) {
            advancementnode.addChild(advancementnode1);
        }
        this.nodes.put(advancementholder.id(), advancementnode1);
        if (advancementnode == null) {
            this.roots.add(advancementnode1);
            if (this.listener != null) {
                this.listener.onAddAdvancementRoot(advancementnode1);
            }
        } else {
            this.tasks.add(advancementnode1);
            if (this.listener != null) {
                this.listener.onAddAdvancementTask(advancementnode1);
            }
        }
        return true;
    }

    public void clear() {
        this.nodes.clear();
        this.roots.clear();
        this.tasks.clear();
        if (this.listener != null) {
            this.listener.onAdvancementsCleared();
        }
    }

    public Iterable<AdvancementNode> roots() {
        return this.roots;
    }

    public Collection<AdvancementNode> nodes() {
        return this.nodes.values();
    }

    @Nullable
    public AdvancementNode get(MinecraftKey minecraftkey) {
        return this.nodes.get(minecraftkey);
    }

    @Nullable
    public AdvancementNode get(AdvancementHolder advancementholder) {
        return this.nodes.get(advancementholder.id());
    }

    public void setListener(@Nullable a advancementtree_a) {
        this.listener = advancementtree_a;
        if (advancementtree_a != null) {
            for (AdvancementNode advancementnode : this.roots) {
                advancementtree_a.onAddAdvancementRoot(advancementnode);
            }
            for (AdvancementNode advancementnode : this.tasks) {
                advancementtree_a.onAddAdvancementTask(advancementnode);
            }
        }
    }

    public static interface a {
        public void onAddAdvancementRoot(AdvancementNode var1);

        public void onRemoveAdvancementRoot(AdvancementNode var1);

        public void onAddAdvancementTask(AdvancementNode var1);

        public void onRemoveAdvancementTask(AdvancementNode var1);

        public void onAdvancementsCleared();
    }
}

