/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Collection;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.advancements.critereon.CriterionConditionNBT;
import net.minecraft.advancements.critereon.CriterionTriggerProperties;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.IWorldReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;

public record CriterionConditionBlock(Optional<HolderSet<Block>> blocks, Optional<CriterionTriggerProperties> properties, Optional<CriterionConditionNBT> nbt) {
    public static final Codec<CriterionConditionBlock> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)RegistryCodecs.homogeneousList(Registries.BLOCK).optionalFieldOf("blocks").forGetter(CriterionConditionBlock::blocks), (App)CriterionTriggerProperties.CODEC.optionalFieldOf("state").forGetter(CriterionConditionBlock::properties), (App)CriterionConditionNBT.CODEC.optionalFieldOf("nbt").forGetter(CriterionConditionBlock::nbt)).apply((Applicative)var0, CriterionConditionBlock::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, CriterionConditionBlock> STREAM_CODEC = StreamCodec.composite(ByteBufCodecs.optional(ByteBufCodecs.holderSet(Registries.BLOCK)), CriterionConditionBlock::blocks, ByteBufCodecs.optional(CriterionTriggerProperties.STREAM_CODEC), CriterionConditionBlock::properties, ByteBufCodecs.optional(CriterionConditionNBT.STREAM_CODEC), CriterionConditionBlock::nbt, CriterionConditionBlock::new);

    public boolean matches(WorldServer var0, BlockPosition var1) {
        if (!var0.isLoaded(var1)) {
            return false;
        }
        if (!this.matchesState(var0.getBlockState(var1))) {
            return false;
        }
        return !this.nbt.isPresent() || CriterionConditionBlock.matchesBlockEntity(var0, var0.getBlockEntity(var1), this.nbt.get());
    }

    public boolean matches(ShapeDetectorBlock var0) {
        if (!this.matchesState(var0.getState())) {
            return false;
        }
        return !this.nbt.isPresent() || CriterionConditionBlock.matchesBlockEntity(var0.getLevel(), var0.getEntity(), this.nbt.get());
    }

    private boolean matchesState(IBlockData var0) {
        if (this.blocks.isPresent() && !var0.is(this.blocks.get())) {
            return false;
        }
        return !this.properties.isPresent() || this.properties.get().matches(var0);
    }

    private static boolean matchesBlockEntity(IWorldReader var0, @Nullable TileEntity var1, CriterionConditionNBT var2) {
        return var1 != null && var2.matches(var1.saveWithFullMetadata(var0.registryAccess()));
    }

    public boolean requiresNbt() {
        return this.nbt.isPresent();
    }

    public static class a {
        private Optional<HolderSet<Block>> blocks = Optional.empty();
        private Optional<CriterionTriggerProperties> properties = Optional.empty();
        private Optional<CriterionConditionNBT> nbt = Optional.empty();

        private a() {
        }

        public static a block() {
            return new a();
        }

        public a of(Block ... var0) {
            this.blocks = Optional.of(HolderSet.direct(Block::builtInRegistryHolder, var0));
            return this;
        }

        public a of(Collection<Block> var0) {
            this.blocks = Optional.of(HolderSet.direct(Block::builtInRegistryHolder, var0));
            return this;
        }

        public a of(TagKey<Block> var0) {
            this.blocks = Optional.of(BuiltInRegistries.BLOCK.getOrCreateTag(var0));
            return this;
        }

        public a hasNbt(NBTTagCompound var0) {
            this.nbt = Optional.of(new CriterionConditionNBT(var0));
            return this;
        }

        public a setProperties(CriterionTriggerProperties.a var0) {
            this.properties = var0.build();
            return this;
        }

        public CriterionConditionBlock build() {
            return new CriterionConditionBlock(this.blocks, this.properties, this.nbt);
        }
    }
}

