/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import java.util.List;
import java.util.Optional;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.core.HolderGetter;
import net.minecraft.util.ProblemReporter;
import net.minecraft.world.level.storage.loot.LootCollector;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParameterSets;

public class CriterionValidator {
    private final ProblemReporter reporter;
    private final HolderGetter.a lootData;

    public CriterionValidator(ProblemReporter var0, HolderGetter.a var1) {
        this.reporter = var0;
        this.lootData = var1;
    }

    public void validateEntity(Optional<ContextAwarePredicate> var0, String var12) {
        var0.ifPresent(var1 -> this.validateEntity((ContextAwarePredicate)var1, var12));
    }

    public void validateEntities(List<ContextAwarePredicate> var0, String var1) {
        this.validate(var0, LootContextParameterSets.ADVANCEMENT_ENTITY, var1);
    }

    public void validateEntity(ContextAwarePredicate var0, String var1) {
        this.validate(var0, LootContextParameterSets.ADVANCEMENT_ENTITY, var1);
    }

    public void validate(ContextAwarePredicate var0, LootContextParameterSet var1, String var2) {
        var0.validate(new LootCollector(this.reporter.forChild(var2), var1, this.lootData));
    }

    public void validate(List<ContextAwarePredicate> var0, LootContextParameterSet var1, String var2) {
        for (int var3 = 0; var3 < var0.size(); ++var3) {
            ContextAwarePredicate var4 = var0.get(var3);
            var4.validate(new LootCollector(this.reporter.forChild(var2 + "[" + var3 + "]"), var1, this.lootData));
        }
    }
}

