/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.advancements.critereon;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.advancements.critereon.CollectionPredicate;
import net.minecraft.advancements.critereon.CriterionConditionValue;
import net.minecraft.advancements.critereon.SingleComponentItemPredicate;
import net.minecraft.core.HolderSet;
import net.minecraft.core.RegistryCodecs;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.ai.attributes.AttributeBase;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.ItemAttributeModifiers;

public record ItemAttributeModifiersPredicate(Optional<CollectionPredicate<ItemAttributeModifiers.b, a>> modifiers) implements SingleComponentItemPredicate<ItemAttributeModifiers>
{
    public static final Codec<ItemAttributeModifiersPredicate> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)CollectionPredicate.codec(a.CODEC).optionalFieldOf("modifiers").forGetter(ItemAttributeModifiersPredicate::modifiers)).apply((Applicative)var0, ItemAttributeModifiersPredicate::new));

    @Override
    public DataComponentType<ItemAttributeModifiers> componentType() {
        return DataComponents.ATTRIBUTE_MODIFIERS;
    }

    @Override
    public boolean matches(ItemStack var0, ItemAttributeModifiers var1) {
        return !this.modifiers.isPresent() || this.modifiers.get().test(var1.modifiers());
    }

    public record a(Optional<HolderSet<AttributeBase>> attribute, Optional<MinecraftKey> id, CriterionConditionValue.DoubleRange amount, Optional<AttributeModifier.Operation> operation, Optional<EquipmentSlotGroup> slot) implements Predicate<ItemAttributeModifiers.b>
    {
        public static final Codec<a> CODEC = RecordCodecBuilder.create(var0 -> var0.group((App)RegistryCodecs.homogeneousList(Registries.ATTRIBUTE).optionalFieldOf("attribute").forGetter(a::attribute), (App)MinecraftKey.CODEC.optionalFieldOf("id").forGetter(a::id), (App)CriterionConditionValue.DoubleRange.CODEC.optionalFieldOf("amount", (Object)CriterionConditionValue.DoubleRange.ANY).forGetter(a::amount), (App)AttributeModifier.Operation.CODEC.optionalFieldOf("operation").forGetter(a::operation), (App)EquipmentSlotGroup.CODEC.optionalFieldOf("slot").forGetter(a::slot)).apply((Applicative)var0, a::new));

        @Override
        public boolean test(ItemAttributeModifiers.b var0) {
            if (this.attribute.isPresent() && !this.attribute.get().contains(var0.attribute())) {
                return false;
            }
            if (this.id.isPresent() && !this.id.get().equals(var0.modifier().id())) {
                return false;
            }
            if (!this.amount.matches(var0.modifier().amount())) {
                return false;
            }
            if (this.operation.isPresent() && this.operation.get() != var0.modifier().operation()) {
                return false;
            }
            return !this.slot.isPresent() || this.slot.get() == var0.slot();
        }

        @Override
        public /* synthetic */ boolean test(Object object) {
            return this.test((ItemAttributeModifiers.b)object);
        }
    }
}

