/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands;

import com.google.common.base.Joiner;
import com.google.common.collect.Maps;
import com.mojang.brigadier.AmbiguityConsumer;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.CommandContextBuilder;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.RootCommandNode;
import com.mojang.logging.LogUtils;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.commands.CommandBuildContext;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.CommandResultCallback;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.commands.synchronization.ArgumentUtils;
import net.minecraft.commands.synchronization.CompletionProviders;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.data.registries.VanillaRegistries;
import net.minecraft.gametest.framework.GameTestHarnessTestCommand;
import net.minecraft.network.chat.ChatClickable;
import net.minecraft.network.chat.ChatComponentUtils;
import net.minecraft.network.chat.ChatHoverable;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.game.PacketPlayOutCommands;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.commands.CommandAdvancement;
import net.minecraft.server.commands.CommandAttribute;
import net.minecraft.server.commands.CommandBan;
import net.minecraft.server.commands.CommandBanIp;
import net.minecraft.server.commands.CommandBanList;
import net.minecraft.server.commands.CommandBossBar;
import net.minecraft.server.commands.CommandClear;
import net.minecraft.server.commands.CommandClone;
import net.minecraft.server.commands.CommandDatapack;
import net.minecraft.server.commands.CommandDebug;
import net.minecraft.server.commands.CommandDeop;
import net.minecraft.server.commands.CommandDifficulty;
import net.minecraft.server.commands.CommandEffect;
import net.minecraft.server.commands.CommandEnchant;
import net.minecraft.server.commands.CommandExecute;
import net.minecraft.server.commands.CommandFill;
import net.minecraft.server.commands.CommandForceload;
import net.minecraft.server.commands.CommandFunction;
import net.minecraft.server.commands.CommandGamemode;
import net.minecraft.server.commands.CommandGamemodeDefault;
import net.minecraft.server.commands.CommandGamerule;
import net.minecraft.server.commands.CommandGive;
import net.minecraft.server.commands.CommandHelp;
import net.minecraft.server.commands.CommandIdleTimeout;
import net.minecraft.server.commands.CommandKick;
import net.minecraft.server.commands.CommandKill;
import net.minecraft.server.commands.CommandList;
import net.minecraft.server.commands.CommandLocate;
import net.minecraft.server.commands.CommandLoot;
import net.minecraft.server.commands.CommandMe;
import net.minecraft.server.commands.CommandOp;
import net.minecraft.server.commands.CommandPardon;
import net.minecraft.server.commands.CommandPardonIP;
import net.minecraft.server.commands.CommandParticle;
import net.minecraft.server.commands.CommandPlaySound;
import net.minecraft.server.commands.CommandPublish;
import net.minecraft.server.commands.CommandRecipe;
import net.minecraft.server.commands.CommandReload;
import net.minecraft.server.commands.CommandSaveAll;
import net.minecraft.server.commands.CommandSaveOff;
import net.minecraft.server.commands.CommandSaveOn;
import net.minecraft.server.commands.CommandSay;
import net.minecraft.server.commands.CommandSchedule;
import net.minecraft.server.commands.CommandScoreboard;
import net.minecraft.server.commands.CommandSeed;
import net.minecraft.server.commands.CommandSetBlock;
import net.minecraft.server.commands.CommandSetWorldSpawn;
import net.minecraft.server.commands.CommandSpawnpoint;
import net.minecraft.server.commands.CommandSpectate;
import net.minecraft.server.commands.CommandSpreadPlayers;
import net.minecraft.server.commands.CommandStop;
import net.minecraft.server.commands.CommandStopSound;
import net.minecraft.server.commands.CommandSummon;
import net.minecraft.server.commands.CommandTag;
import net.minecraft.server.commands.CommandTeam;
import net.minecraft.server.commands.CommandTeamMsg;
import net.minecraft.server.commands.CommandTeleport;
import net.minecraft.server.commands.CommandTell;
import net.minecraft.server.commands.CommandTellRaw;
import net.minecraft.server.commands.CommandTime;
import net.minecraft.server.commands.CommandTitle;
import net.minecraft.server.commands.CommandTrigger;
import net.minecraft.server.commands.CommandWeather;
import net.minecraft.server.commands.CommandWhitelist;
import net.minecraft.server.commands.CommandWorldBorder;
import net.minecraft.server.commands.CommandXp;
import net.minecraft.server.commands.DamageCommand;
import net.minecraft.server.commands.DebugConfigCommand;
import net.minecraft.server.commands.DebugMobSpawningCommand;
import net.minecraft.server.commands.DebugPathCommand;
import net.minecraft.server.commands.FillBiomeCommand;
import net.minecraft.server.commands.ItemCommands;
import net.minecraft.server.commands.JfrCommand;
import net.minecraft.server.commands.PerfCommand;
import net.minecraft.server.commands.PlaceCommand;
import net.minecraft.server.commands.RaidCommand;
import net.minecraft.server.commands.RandomCommand;
import net.minecraft.server.commands.ReturnCommand;
import net.minecraft.server.commands.RideCommand;
import net.minecraft.server.commands.ServerPackCommand;
import net.minecraft.server.commands.SpawnArmorTrimsCommand;
import net.minecraft.server.commands.TickCommand;
import net.minecraft.server.commands.TransferCommand;
import net.minecraft.server.commands.WardenSpawnTrackerCommand;
import net.minecraft.server.commands.data.CommandData;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.profiling.jfr.JvmProfiler;
import net.minecraft.world.level.GameRules;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.player.PlayerCommandSendEvent;
import org.bukkit.event.server.ServerCommandEvent;
import org.slf4j.Logger;
import org.spigotmc.SpigotConfig;

public class CommandDispatcher {
    private static final ThreadLocal<ExecutionContext<CommandListenerWrapper>> CURRENT_EXECUTION_CONTEXT = new ThreadLocal();
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int LEVEL_ALL = 0;
    public static final int LEVEL_MODERATORS = 1;
    public static final int LEVEL_GAMEMASTERS = 2;
    public static final int LEVEL_ADMINS = 3;
    public static final int LEVEL_OWNERS = 4;
    private final com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> dispatcher = new com.mojang.brigadier.CommandDispatcher();

    public CommandDispatcher(ServerType commanddispatcher_servertype, CommandBuildContext commandbuildcontext) {
        this();
        CommandAdvancement.register(this.dispatcher);
        CommandAttribute.register(this.dispatcher, commandbuildcontext);
        CommandExecute.register(this.dispatcher, commandbuildcontext);
        CommandBossBar.register(this.dispatcher, commandbuildcontext);
        CommandClear.register(this.dispatcher, commandbuildcontext);
        CommandClone.register(this.dispatcher, commandbuildcontext);
        DamageCommand.register(this.dispatcher, commandbuildcontext);
        CommandData.register(this.dispatcher);
        CommandDatapack.register(this.dispatcher);
        CommandDebug.register(this.dispatcher);
        CommandGamemodeDefault.register(this.dispatcher);
        CommandDifficulty.register(this.dispatcher);
        CommandEffect.register(this.dispatcher, commandbuildcontext);
        CommandMe.register(this.dispatcher);
        CommandEnchant.register(this.dispatcher, commandbuildcontext);
        CommandXp.register(this.dispatcher);
        CommandFill.register(this.dispatcher, commandbuildcontext);
        FillBiomeCommand.register(this.dispatcher, commandbuildcontext);
        CommandForceload.register(this.dispatcher);
        CommandFunction.register(this.dispatcher);
        CommandGamemode.register(this.dispatcher);
        CommandGamerule.register(this.dispatcher);
        CommandGive.register(this.dispatcher, commandbuildcontext);
        CommandHelp.register(this.dispatcher);
        ItemCommands.register(this.dispatcher, commandbuildcontext);
        CommandKick.register(this.dispatcher);
        CommandKill.register(this.dispatcher);
        CommandList.register(this.dispatcher);
        CommandLocate.register(this.dispatcher, commandbuildcontext);
        CommandLoot.register(this.dispatcher, commandbuildcontext);
        CommandTell.register(this.dispatcher);
        CommandParticle.register(this.dispatcher, commandbuildcontext);
        PlaceCommand.register(this.dispatcher);
        CommandPlaySound.register(this.dispatcher);
        RandomCommand.register(this.dispatcher);
        CommandReload.register(this.dispatcher);
        CommandRecipe.register(this.dispatcher);
        ReturnCommand.register(this.dispatcher);
        RideCommand.register(this.dispatcher);
        CommandSay.register(this.dispatcher);
        CommandSchedule.register(this.dispatcher);
        CommandScoreboard.register(this.dispatcher, commandbuildcontext);
        CommandSeed.register(this.dispatcher, commanddispatcher_servertype != ServerType.INTEGRATED);
        CommandSetBlock.register(this.dispatcher, commandbuildcontext);
        CommandSpawnpoint.register(this.dispatcher);
        CommandSetWorldSpawn.register(this.dispatcher);
        CommandSpectate.register(this.dispatcher);
        CommandSpreadPlayers.register(this.dispatcher);
        CommandStopSound.register(this.dispatcher);
        CommandSummon.register(this.dispatcher, commandbuildcontext);
        CommandTag.register(this.dispatcher);
        CommandTeam.register(this.dispatcher, commandbuildcontext);
        CommandTeamMsg.register(this.dispatcher);
        CommandTeleport.register(this.dispatcher);
        CommandTellRaw.register(this.dispatcher, commandbuildcontext);
        TickCommand.register(this.dispatcher);
        CommandTime.register(this.dispatcher);
        CommandTitle.register(this.dispatcher, commandbuildcontext);
        CommandTrigger.register(this.dispatcher);
        CommandWeather.register(this.dispatcher);
        CommandWorldBorder.register(this.dispatcher);
        if (JvmProfiler.INSTANCE.isAvailable()) {
            JfrCommand.register(this.dispatcher);
        }
        if (SharedConstants.IS_RUNNING_IN_IDE) {
            GameTestHarnessTestCommand.register(this.dispatcher);
            RaidCommand.register(this.dispatcher, commandbuildcontext);
            DebugPathCommand.register(this.dispatcher);
            DebugMobSpawningCommand.register(this.dispatcher);
            WardenSpawnTrackerCommand.register(this.dispatcher);
            SpawnArmorTrimsCommand.register(this.dispatcher);
            ServerPackCommand.register(this.dispatcher);
            if (commanddispatcher_servertype.includeDedicated) {
                DebugConfigCommand.register(this.dispatcher);
            }
        }
        if (commanddispatcher_servertype.includeDedicated) {
            CommandBanIp.register(this.dispatcher);
            CommandBanList.register(this.dispatcher);
            CommandBan.register(this.dispatcher);
            CommandDeop.register(this.dispatcher);
            CommandOp.register(this.dispatcher);
            CommandPardon.register(this.dispatcher);
            CommandPardonIP.register(this.dispatcher);
            PerfCommand.register(this.dispatcher);
            CommandSaveAll.register(this.dispatcher);
            CommandSaveOff.register(this.dispatcher);
            CommandSaveOn.register(this.dispatcher);
            CommandIdleTimeout.register(this.dispatcher);
            CommandStop.register(this.dispatcher);
            TransferCommand.register(this.dispatcher);
            CommandWhitelist.register(this.dispatcher);
        }
        if (commanddispatcher_servertype.includeIntegrated) {
            CommandPublish.register(this.dispatcher);
        }
    }

    public CommandDispatcher() {
        this.dispatcher.setConsumer(ExecutionCommandSource.resultConsumer());
    }

    public static <S> ParseResults<S> mapSource(ParseResults<S> parseresults, UnaryOperator<S> unaryoperator) {
        CommandContextBuilder commandcontextbuilder = parseresults.getContext();
        CommandContextBuilder commandcontextbuilder1 = commandcontextbuilder.withSource(unaryoperator.apply(commandcontextbuilder.getSource()));
        return new ParseResults(commandcontextbuilder1, parseresults.getReader(), parseresults.getExceptions());
    }

    public void dispatchServerCommand(CommandListenerWrapper sender, String command) {
        Joiner joiner = Joiner.on((String)" ");
        if (command.startsWith("/")) {
            command = command.substring(1);
        }
        ServerCommandEvent event = new ServerCommandEvent(sender.getBukkitSender(), command);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.isCancelled()) {
            return;
        }
        command = event.getCommand();
        Object[] args = command.split(" ");
        String cmd = args[0];
        if (cmd.startsWith("minecraft:")) {
            cmd = cmd.substring("minecraft:".length());
        }
        if (cmd.startsWith("bukkit:")) {
            cmd = cmd.substring("bukkit:".length());
        }
        if (cmd.equalsIgnoreCase("stop") || cmd.equalsIgnoreCase("kick") || cmd.equalsIgnoreCase("op") || cmd.equalsIgnoreCase("deop") || cmd.equalsIgnoreCase("ban") || cmd.equalsIgnoreCase("ban-ip") || cmd.equalsIgnoreCase("pardon") || cmd.equalsIgnoreCase("pardon-ip") || cmd.equalsIgnoreCase("reload")) {
            return;
        }
        if (sender.getLevel().getCraftServer().getCommandBlockOverride(args[0])) {
            args[0] = "minecraft:" + (String)args[0];
        }
        String newCommand = joiner.join(args);
        this.performPrefixedCommand(sender, newCommand, newCommand);
    }

    public void performPrefixedCommand(CommandListenerWrapper commandlistenerwrapper, String s2) {
        this.performPrefixedCommand(commandlistenerwrapper, s2, s2);
    }

    public void performPrefixedCommand(CommandListenerWrapper commandlistenerwrapper, String s2, String label) {
        s2 = s2.startsWith("/") ? s2.substring(1) : s2;
        this.performCommand(this.dispatcher.parse(s2, commandlistenerwrapper), s2, label);
    }

    public void performCommand(ParseResults<CommandListenerWrapper> parseresults, String s2) {
        this.performCommand(parseresults, s2, s2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void performCommand(ParseResults<CommandListenerWrapper> parseresults, String s2, String label) {
        CommandListenerWrapper commandlistenerwrapper = (CommandListenerWrapper)parseresults.getContext().getSource();
        commandlistenerwrapper.getServer().getProfiler().push(() -> "/" + s2);
        ContextChain<CommandListenerWrapper> contextchain = CommandDispatcher.finishParsing(parseresults, s2, commandlistenerwrapper, label);
        try {
            if (contextchain != null) {
                CommandDispatcher.executeCommandInContext(commandlistenerwrapper, executioncontext -> ExecutionContext.queueInitialCommandExecution(executioncontext, s2, contextchain, commandlistenerwrapper, CommandResultCallback.EMPTY));
            }
        }
        catch (Exception exception) {
            IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.literal(exception.getMessage() == null ? exception.getClass().getName() : exception.getMessage());
            if (LOGGER.isDebugEnabled()) {
                LOGGER.error("Command exception: /{}", (Object)s2, (Object)exception);
                StackTraceElement[] astacktraceelement = exception.getStackTrace();
                for (int i2 = 0; i2 < Math.min(astacktraceelement.length, 3); ++i2) {
                    ichatmutablecomponent.append("\n\n").append(astacktraceelement[i2].getMethodName()).append("\n ").append(astacktraceelement[i2].getFileName()).append(":").append(String.valueOf(astacktraceelement[i2].getLineNumber()));
                }
            }
            commandlistenerwrapper.sendFailure(IChatBaseComponent.translatable("command.failed").withStyle(chatmodifier -> chatmodifier.withHoverEvent(new ChatHoverable(ChatHoverable.EnumHoverAction.SHOW_TEXT, ichatmutablecomponent))));
            if (SharedConstants.IS_RUNNING_IN_IDE) {
                commandlistenerwrapper.sendFailure(IChatBaseComponent.literal(SystemUtils.describeError(exception)));
                LOGGER.error("'/{}' threw an exception", (Object)s2, (Object)exception);
            }
        }
        finally {
            commandlistenerwrapper.getServer().getProfiler().pop();
        }
    }

    @Nullable
    private static ContextChain<CommandListenerWrapper> finishParsing(ParseResults<CommandListenerWrapper> parseresults, String s2, CommandListenerWrapper commandlistenerwrapper, String label) {
        try {
            CommandDispatcher.validateParseResults(parseresults);
            return (ContextChain)ContextChain.tryFlatten((CommandContext)parseresults.getContext().build(s2)).orElseThrow(() -> CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parseresults.getReader()));
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            commandlistenerwrapper.sendFailure(ChatComponentUtils.fromMessage(commandsyntaxexception.getRawMessage()));
            if (commandsyntaxexception.getInput() != null && commandsyntaxexception.getCursor() >= 0) {
                int i2 = Math.min(commandsyntaxexception.getInput().length(), commandsyntaxexception.getCursor());
                IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.empty().withStyle(EnumChatFormat.GRAY).withStyle(chatmodifier -> chatmodifier.withClickEvent(new ChatClickable(ChatClickable.EnumClickAction.SUGGEST_COMMAND, label)));
                if (i2 > 10) {
                    ichatmutablecomponent.append(CommonComponents.ELLIPSIS);
                }
                ichatmutablecomponent.append(commandsyntaxexception.getInput().substring(Math.max(0, i2 - 10), i2));
                if (i2 < commandsyntaxexception.getInput().length()) {
                    IChatMutableComponent ichatmutablecomponent1 = IChatBaseComponent.literal(commandsyntaxexception.getInput().substring(i2)).withStyle(EnumChatFormat.RED, EnumChatFormat.UNDERLINE);
                    ichatmutablecomponent.append(ichatmutablecomponent1);
                }
                ichatmutablecomponent.append(IChatBaseComponent.translatable("command.context.here").withStyle(EnumChatFormat.RED, EnumChatFormat.ITALIC));
                commandlistenerwrapper.sendFailure(ichatmutablecomponent);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeCommandInContext(CommandListenerWrapper commandlistenerwrapper, Consumer<ExecutionContext<CommandListenerWrapper>> consumer) {
        block9: {
            boolean flag;
            MinecraftServer minecraftserver = commandlistenerwrapper.getServer();
            ExecutionContext<CommandListenerWrapper> executioncontext = CURRENT_EXECUTION_CONTEXT.get();
            boolean bl = flag = executioncontext == null;
            if (flag) {
                int i2 = Math.max(1, minecraftserver.getGameRules().getInt(GameRules.RULE_MAX_COMMAND_CHAIN_LENGTH));
                int j2 = minecraftserver.getGameRules().getInt(GameRules.RULE_MAX_COMMAND_FORK_COUNT);
                try (ExecutionContext executioncontext1 = new ExecutionContext(i2, j2, minecraftserver.getProfiler());){
                    CURRENT_EXECUTION_CONTEXT.set(executioncontext1);
                    consumer.accept(executioncontext1);
                    executioncontext1.runCommandQueue();
                    break block9;
                }
                finally {
                    CURRENT_EXECUTION_CONTEXT.set(null);
                }
            }
            consumer.accept(executioncontext);
        }
    }

    public void sendCommands(EntityPlayer entityplayer) {
        if (SpigotConfig.tabComplete < 0) {
            return;
        }
        IdentityHashMap map = Maps.newIdentityHashMap();
        RootCommandNode vanillaRoot = new RootCommandNode();
        RootCommandNode<CommandListenerWrapper> vanilla = entityplayer.server.vanillaCommandDispatcher.getDispatcher().getRoot();
        map.put(vanilla, vanillaRoot);
        this.fillUsableCommands((CommandNode<CommandListenerWrapper>)vanilla, (CommandNode<ICompletionProvider>)vanillaRoot, entityplayer.createCommandSourceStack(), map);
        RootCommandNode rootcommandnode = new RootCommandNode();
        map.put(this.dispatcher.getRoot(), rootcommandnode);
        this.fillUsableCommands((CommandNode<CommandListenerWrapper>)this.dispatcher.getRoot(), (CommandNode<ICompletionProvider>)rootcommandnode, entityplayer.createCommandSourceStack(), map);
        LinkedHashSet<String> bukkit = new LinkedHashSet<String>();
        for (CommandNode node : rootcommandnode.getChildren()) {
            bukkit.add(node.getName());
        }
        PlayerCommandSendEvent event = new PlayerCommandSendEvent((Player)entityplayer.getBukkitEntity(), new LinkedHashSet(bukkit));
        event.getPlayer().getServer().getPluginManager().callEvent((Event)event);
        for (String orig : bukkit) {
            if (event.getCommands().contains(orig)) continue;
            rootcommandnode.removeCommand(orig);
        }
        entityplayer.connection.send(new PacketPlayOutCommands((RootCommandNode<ICompletionProvider>)rootcommandnode));
    }

    private void fillUsableCommands(CommandNode<CommandListenerWrapper> commandnode, CommandNode<ICompletionProvider> commandnode1, CommandListenerWrapper commandlistenerwrapper, Map<CommandNode<CommandListenerWrapper>, CommandNode<ICompletionProvider>> map) {
        for (CommandNode<CommandListenerWrapper> commandnode2 : commandnode.getChildren()) {
            RequiredArgumentBuilder requiredargumentbuilder;
            if (!SpigotConfig.sendNamespaced && commandnode2.getName().contains(":") || !commandnode2.canUse(commandlistenerwrapper)) continue;
            ArgumentBuilder<CommandListenerWrapper, ?> argumentbuilder = commandnode2.createBuilder();
            argumentbuilder.requires(icompletionprovider -> true);
            if (argumentbuilder.getCommand() != null) {
                argumentbuilder.executes(commandcontext -> 0);
            }
            if (argumentbuilder instanceof RequiredArgumentBuilder && (requiredargumentbuilder = (RequiredArgumentBuilder)argumentbuilder).getSuggestionsProvider() != null) {
                requiredargumentbuilder.suggests(CompletionProviders.safelySwap((SuggestionProvider<ICompletionProvider>)requiredargumentbuilder.getSuggestionsProvider()));
            }
            if (argumentbuilder.getRedirect() != null) {
                argumentbuilder.redirect(map.get(argumentbuilder.getRedirect()));
            }
            CommandNode commandnode3 = argumentbuilder.build();
            map.put(commandnode2, commandnode3);
            commandnode1.addChild(commandnode3);
            if (commandnode2.getChildren().isEmpty()) continue;
            this.fillUsableCommands(commandnode2, commandnode3, commandlistenerwrapper, map);
        }
    }

    public static LiteralArgumentBuilder<CommandListenerWrapper> literal(String s2) {
        return LiteralArgumentBuilder.literal((String)s2);
    }

    public static <T> RequiredArgumentBuilder<CommandListenerWrapper, T> argument(String s2, ArgumentType<T> argumenttype) {
        return RequiredArgumentBuilder.argument((String)s2, argumenttype);
    }

    public static Predicate<String> createValidator(b commanddispatcher_b) {
        return s2 -> {
            try {
                commanddispatcher_b.parse(new StringReader(s2));
                return true;
            }
            catch (CommandSyntaxException commandsyntaxexception) {
                return false;
            }
        };
    }

    public com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> getDispatcher() {
        return this.dispatcher;
    }

    public static <S> void validateParseResults(ParseResults<S> parseresults) throws CommandSyntaxException {
        CommandSyntaxException commandsyntaxexception = CommandDispatcher.getParseException(parseresults);
        if (commandsyntaxexception != null) {
            throw commandsyntaxexception;
        }
    }

    @Nullable
    public static <S> CommandSyntaxException getParseException(ParseResults<S> parseresults) {
        return !parseresults.getReader().canRead() ? null : (parseresults.getExceptions().size() == 1 ? (CommandSyntaxException)((Object)parseresults.getExceptions().values().iterator().next()) : (parseresults.getContext().getRange().isEmpty() ? CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownCommand().createWithContext(parseresults.getReader()) : CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherUnknownArgument().createWithContext(parseresults.getReader())));
    }

    public static CommandBuildContext createValidationContext(final HolderLookup.a holderlookup_a) {
        return new CommandBuildContext(){

            @Override
            public Stream<ResourceKey<? extends IRegistry<?>>> listRegistries() {
                return holderlookup_a.listRegistries();
            }

            @Override
            public <T> Optional<HolderLookup.b<T>> lookup(ResourceKey<? extends IRegistry<? extends T>> resourcekey) {
                return holderlookup_a.lookup(resourcekey).map(this::createLookup);
            }

            private <T> HolderLookup.b.a<T> createLookup(final HolderLookup.b<T> holderlookup_b) {
                return new HolderLookup.b.a<T>(){

                    @Override
                    public HolderLookup.b<T> parent() {
                        return holderlookup_b;
                    }

                    @Override
                    public Optional<HolderSet.Named<T>> get(TagKey<T> tagkey) {
                        return Optional.of(this.getOrThrow(tagkey));
                    }

                    @Override
                    public HolderSet.Named<T> getOrThrow(TagKey<T> tagkey) {
                        Optional<HolderSet.Named<HolderSet.Named>> optional = this.parent().get(tagkey);
                        return optional.orElseGet(() -> HolderSet.emptyNamed(this.parent(), tagkey));
                    }
                };
            }
        };
    }

    public static void validate() {
        CommandBuildContext commandbuildcontext = CommandDispatcher.createValidationContext(VanillaRegistries.createLookup());
        com.mojang.brigadier.CommandDispatcher<CommandListenerWrapper> com_mojang_brigadier_commanddispatcher = new CommandDispatcher(ServerType.ALL, commandbuildcontext).getDispatcher();
        RootCommandNode<CommandListenerWrapper> rootcommandnode = com_mojang_brigadier_commanddispatcher.getRoot();
        com_mojang_brigadier_commanddispatcher.findAmbiguities((AmbiguityConsumer<CommandListenerWrapper>)((AmbiguityConsumer)(commandnode, commandnode1, commandnode2, collection) -> LOGGER.warn("Ambiguity between arguments {} and {} with inputs: {}", new Object[]{com_mojang_brigadier_commanddispatcher.getPath(commandnode1), com_mojang_brigadier_commanddispatcher.getPath(commandnode2), collection})));
        Set<ArgumentType<?>> set = ArgumentUtils.findUsedArgumentTypes(rootcommandnode);
        Set set1 = set.stream().filter(argumenttype -> !ArgumentTypeInfos.isClassRecognized(argumenttype.getClass())).collect(Collectors.toSet());
        if (!set1.isEmpty()) {
            LOGGER.warn("Missing type registration for following arguments:\n {}", (Object)set1.stream().map(argumenttype -> "\t" + String.valueOf(argumenttype)).collect(Collectors.joining(",\n")));
            throw new IllegalStateException("Unregistered argument types");
        }
    }

    public static enum ServerType {
        ALL(true, true),
        DEDICATED(false, true),
        INTEGRATED(true, false);

        final boolean includeIntegrated;
        final boolean includeDedicated;

        private ServerType(boolean flag, boolean flag1) {
            this.includeIntegrated = flag;
            this.includeDedicated = flag1;
        }
    }

    @FunctionalInterface
    public static interface b {
        public void parse(StringReader var1) throws CommandSyntaxException;
    }
}

