/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import java.util.Arrays;
import java.util.Collection;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.crafting.CraftingManager;
import net.minecraft.world.item.crafting.RecipeHolder;

public class ArgumentMinecraftKeyRegistered
implements ArgumentType<MinecraftKey> {
    private static final Collection<String> EXAMPLES = Arrays.asList("foo", "foo:bar", "012");
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_ADVANCEMENT = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("advancement.advancementNotFound", var0));
    private static final DynamicCommandExceptionType ERROR_UNKNOWN_RECIPE = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("recipe.notFound", var0));

    public static ArgumentMinecraftKeyRegistered id() {
        return new ArgumentMinecraftKeyRegistered();
    }

    public static AdvancementHolder getAdvancement(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        MinecraftKey var2 = ArgumentMinecraftKeyRegistered.getId(var0, var1);
        AdvancementHolder var3 = ((CommandListenerWrapper)var0.getSource()).getServer().getAdvancements().get(var2);
        if (var3 == null) {
            throw ERROR_UNKNOWN_ADVANCEMENT.create((Object)var2);
        }
        return var3;
    }

    public static RecipeHolder<?> getRecipe(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        CraftingManager var2 = ((CommandListenerWrapper)var0.getSource()).getServer().getRecipeManager();
        MinecraftKey var3 = ArgumentMinecraftKeyRegistered.getId(var0, var1);
        return var2.byKey(var3).orElseThrow(() -> ERROR_UNKNOWN_RECIPE.create((Object)var3));
    }

    public static MinecraftKey getId(CommandContext<CommandListenerWrapper> var0, String var1) {
        return (MinecraftKey)var0.getArgument(var1, MinecraftKey.class);
    }

    public MinecraftKey parse(StringReader var0) throws CommandSyntaxException {
        return MinecraftKey.read(var0);
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

