/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.CompletableFuture;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.world.level.EnumGamemode;

public class GameModeArgument
implements ArgumentType<EnumGamemode> {
    private static final Collection<String> EXAMPLES = Stream.of(EnumGamemode.SURVIVAL, EnumGamemode.CREATIVE).map(EnumGamemode::getName).collect(Collectors.toList());
    private static final EnumGamemode[] VALUES = EnumGamemode.values();
    private static final DynamicCommandExceptionType ERROR_INVALID = new DynamicCommandExceptionType(var0 -> IChatBaseComponent.translatableEscape("argument.gamemode.invalid", var0));

    public EnumGamemode parse(StringReader var0) throws CommandSyntaxException {
        String var1 = var0.readUnquotedString();
        EnumGamemode var2 = EnumGamemode.byName(var1, null);
        if (var2 == null) {
            throw ERROR_INVALID.createWithContext((ImmutableStringReader)var0, (Object)var1);
        }
        return var2;
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> var0, SuggestionsBuilder var1) {
        if (var0.getSource() instanceof ICompletionProvider) {
            return ICompletionProvider.suggest(Arrays.stream(VALUES).map(EnumGamemode::getName), var1);
        }
        return Suggestions.empty();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public static GameModeArgument gameMode() {
        return new GameModeArgument();
    }

    public static EnumGamemode getGameMode(CommandContext<CommandListenerWrapper> var0, String var1) throws CommandSyntaxException {
        return (EnumGamemode)var0.getArgument(var1, EnumGamemode.class);
    }

    public /* synthetic */ Object parse(StringReader stringReader) throws CommandSyntaxException {
        return this.parse(stringReader);
    }
}

