/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import com.google.common.collect.Maps;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.Dynamic3CommandExceptionType;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.commands.ICompletionProvider;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.MojangsonParser;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockStateList;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class ArgumentBlock {
    public static final SimpleCommandExceptionType ERROR_NO_TAGS_ALLOWED = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.block.tag.disallowed"));
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_BLOCK = new DynamicCommandExceptionType(object -> IChatBaseComponent.translatableEscape("argument.block.id.invalid", object));
    public static final Dynamic2CommandExceptionType ERROR_UNKNOWN_PROPERTY = new Dynamic2CommandExceptionType((object, object1) -> IChatBaseComponent.translatableEscape("argument.block.property.unknown", object, object1));
    public static final Dynamic2CommandExceptionType ERROR_DUPLICATE_PROPERTY = new Dynamic2CommandExceptionType((object, object1) -> IChatBaseComponent.translatableEscape("argument.block.property.duplicate", object1, object));
    public static final Dynamic3CommandExceptionType ERROR_INVALID_VALUE = new Dynamic3CommandExceptionType((object, object1, object2) -> IChatBaseComponent.translatableEscape("argument.block.property.invalid", object, object2, object1));
    public static final Dynamic2CommandExceptionType ERROR_EXPECTED_VALUE = new Dynamic2CommandExceptionType((object, object1) -> IChatBaseComponent.translatableEscape("argument.block.property.novalue", object, object1));
    public static final SimpleCommandExceptionType ERROR_EXPECTED_END_OF_PROPERTIES = new SimpleCommandExceptionType((Message)IChatBaseComponent.translatable("argument.block.property.unclosed"));
    public static final DynamicCommandExceptionType ERROR_UNKNOWN_TAG = new DynamicCommandExceptionType(object -> IChatBaseComponent.translatableEscape("arguments.block.tag.unknown", object));
    private static final char SYNTAX_START_PROPERTIES = '[';
    private static final char SYNTAX_START_NBT = '{';
    private static final char SYNTAX_END_PROPERTIES = ']';
    private static final char SYNTAX_EQUALS = '=';
    private static final char SYNTAX_PROPERTY_SEPARATOR = ',';
    private static final char SYNTAX_TAG = '#';
    private static final Function<SuggestionsBuilder, CompletableFuture<Suggestions>> SUGGEST_NOTHING = SuggestionsBuilder::buildFuture;
    private final HolderLookup<Block> blocks;
    private final StringReader reader;
    private final boolean forTesting;
    private final boolean allowNbt;
    private final Map<IBlockState<?>, Comparable<?>> properties = Maps.newLinkedHashMap();
    private final Map<String, String> vagueProperties = Maps.newHashMap();
    private MinecraftKey id = MinecraftKey.withDefaultNamespace("");
    @Nullable
    private BlockStateList<Block, IBlockData> definition;
    @Nullable
    private IBlockData state;
    @Nullable
    private NBTTagCompound nbt;
    @Nullable
    private HolderSet<Block> tag;
    private Function<SuggestionsBuilder, CompletableFuture<Suggestions>> suggestions = SUGGEST_NOTHING;

    private ArgumentBlock(HolderLookup<Block> holderlookup, StringReader stringreader, boolean flag, boolean flag1) {
        this.blocks = holderlookup;
        this.reader = stringreader;
        this.forTesting = flag;
        this.allowNbt = flag1;
    }

    public static a parseForBlock(HolderLookup<Block> holderlookup, String s2, boolean flag) throws CommandSyntaxException {
        return ArgumentBlock.parseForBlock(holderlookup, new StringReader(s2), flag);
    }

    public static a parseForBlock(HolderLookup<Block> holderlookup, StringReader stringreader, boolean flag) throws CommandSyntaxException {
        int i2 = stringreader.getCursor();
        try {
            ArgumentBlock argumentblock = new ArgumentBlock(holderlookup, stringreader, false, flag);
            argumentblock.parse();
            return new a(argumentblock.state, argumentblock.properties, argumentblock.nbt);
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            stringreader.setCursor(i2);
            throw commandsyntaxexception;
        }
    }

    public static Either<a, b> parseForTesting(HolderLookup<Block> holderlookup, String s2, boolean flag) throws CommandSyntaxException {
        return ArgumentBlock.parseForTesting(holderlookup, new StringReader(s2), flag);
    }

    public static Either<a, b> parseForTesting(HolderLookup<Block> holderlookup, StringReader stringreader, boolean flag) throws CommandSyntaxException {
        int i2 = stringreader.getCursor();
        try {
            ArgumentBlock argumentblock = new ArgumentBlock(holderlookup, stringreader, true, flag);
            argumentblock.parse();
            return argumentblock.tag != null ? Either.right((Object)new b(argumentblock.tag, argumentblock.vagueProperties, argumentblock.nbt)) : Either.left((Object)new a(argumentblock.state, argumentblock.properties, argumentblock.nbt));
        }
        catch (CommandSyntaxException commandsyntaxexception) {
            stringreader.setCursor(i2);
            throw commandsyntaxexception;
        }
    }

    public static CompletableFuture<Suggestions> fillSuggestions(HolderLookup<Block> holderlookup, SuggestionsBuilder suggestionsbuilder, boolean flag, boolean flag1) {
        StringReader stringreader = new StringReader(suggestionsbuilder.getInput());
        stringreader.setCursor(suggestionsbuilder.getStart());
        ArgumentBlock argumentblock = new ArgumentBlock(holderlookup, stringreader, flag, flag1);
        try {
            argumentblock.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        return argumentblock.suggestions.apply(suggestionsbuilder.createOffset(stringreader.getCursor()));
    }

    private void parse() throws CommandSyntaxException {
        this.suggestions = this.forTesting ? this::suggestBlockIdOrTag : this::suggestItem;
        if (this.reader.canRead() && this.reader.peek() == '#') {
            this.readTag();
            this.suggestions = this::suggestOpenVaguePropertiesOrNbt;
            if (this.reader.canRead() && this.reader.peek() == '[') {
                this.readVagueProperties();
                this.suggestions = this::suggestOpenNbt;
            }
        } else {
            this.readBlock();
            this.suggestions = this::suggestOpenPropertiesOrNbt;
            if (this.reader.canRead() && this.reader.peek() == '[') {
                this.readProperties();
                this.suggestions = this::suggestOpenNbt;
            }
        }
        if (this.allowNbt && this.reader.canRead() && this.reader.peek() == '{') {
            this.suggestions = SUGGEST_NOTHING;
            this.readNbt();
        }
    }

    private CompletableFuture<Suggestions> suggestPropertyNameOrEnd(SuggestionsBuilder suggestionsbuilder) {
        if (suggestionsbuilder.getRemaining().isEmpty()) {
            suggestionsbuilder.suggest(String.valueOf(']'));
        }
        return this.suggestPropertyName(suggestionsbuilder);
    }

    private CompletableFuture<Suggestions> suggestVaguePropertyNameOrEnd(SuggestionsBuilder suggestionsbuilder) {
        if (suggestionsbuilder.getRemaining().isEmpty()) {
            suggestionsbuilder.suggest(String.valueOf(']'));
        }
        return this.suggestVaguePropertyName(suggestionsbuilder);
    }

    private CompletableFuture<Suggestions> suggestPropertyName(SuggestionsBuilder suggestionsbuilder) {
        String s2 = suggestionsbuilder.getRemaining().toLowerCase(Locale.ROOT);
        for (IBlockState<?> iblockstate : this.state.getProperties()) {
            if (this.properties.containsKey(iblockstate) || !iblockstate.getName().startsWith(s2)) continue;
            suggestionsbuilder.suggest(iblockstate.getName() + "=");
        }
        return suggestionsbuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestVaguePropertyName(SuggestionsBuilder suggestionsbuilder) {
        String s2 = suggestionsbuilder.getRemaining().toLowerCase(Locale.ROOT);
        if (this.tag != null) {
            for (Holder holder : this.tag) {
                for (IBlockState<?> iblockstate : ((Block)holder.value()).getStateDefinition().getProperties()) {
                    if (this.vagueProperties.containsKey(iblockstate.getName()) || !iblockstate.getName().startsWith(s2)) continue;
                    suggestionsbuilder.suggest(iblockstate.getName() + "=");
                }
            }
        }
        return suggestionsbuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOpenNbt(SuggestionsBuilder suggestionsbuilder) {
        if (suggestionsbuilder.getRemaining().isEmpty() && this.hasBlockEntity()) {
            suggestionsbuilder.suggest(String.valueOf('{'));
        }
        return suggestionsbuilder.buildFuture();
    }

    private boolean hasBlockEntity() {
        if (this.state != null) {
            return this.state.hasBlockEntity();
        }
        if (this.tag != null) {
            for (Holder holder : this.tag) {
                if (!((Block)holder.value()).defaultBlockState().hasBlockEntity()) continue;
                return true;
            }
        }
        return false;
    }

    private CompletableFuture<Suggestions> suggestEquals(SuggestionsBuilder suggestionsbuilder) {
        if (suggestionsbuilder.getRemaining().isEmpty()) {
            suggestionsbuilder.suggest(String.valueOf('='));
        }
        return suggestionsbuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestNextPropertyOrEnd(SuggestionsBuilder suggestionsbuilder) {
        if (suggestionsbuilder.getRemaining().isEmpty()) {
            suggestionsbuilder.suggest(String.valueOf(']'));
        }
        if (suggestionsbuilder.getRemaining().isEmpty() && this.properties.size() < this.state.getProperties().size()) {
            suggestionsbuilder.suggest(String.valueOf(','));
        }
        return suggestionsbuilder.buildFuture();
    }

    private static <T extends Comparable<T>> SuggestionsBuilder addSuggestions(SuggestionsBuilder suggestionsbuilder, IBlockState<T> iblockstate) {
        for (Comparable t0 : iblockstate.getPossibleValues()) {
            if (t0 instanceof Integer) {
                Integer integer = (Integer)t0;
                suggestionsbuilder.suggest(integer.intValue());
                continue;
            }
            suggestionsbuilder.suggest(iblockstate.getName(t0));
        }
        return suggestionsbuilder;
    }

    private CompletableFuture<Suggestions> suggestVaguePropertyValue(SuggestionsBuilder suggestionsbuilder, String s2) {
        boolean flag = false;
        if (this.tag != null) {
            block0: for (Holder holder : this.tag) {
                Block block = (Block)holder.value();
                IBlockState<?> iblockstate = block.getStateDefinition().getProperty(s2);
                if (iblockstate != null) {
                    ArgumentBlock.addSuggestions(suggestionsbuilder, iblockstate);
                }
                if (flag) continue;
                for (IBlockState<?> iblockstate1 : block.getStateDefinition().getProperties()) {
                    if (this.vagueProperties.containsKey(iblockstate1.getName())) continue;
                    flag = true;
                    continue block0;
                }
            }
        }
        if (flag) {
            suggestionsbuilder.suggest(String.valueOf(','));
        }
        suggestionsbuilder.suggest(String.valueOf(']'));
        return suggestionsbuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOpenVaguePropertiesOrNbt(SuggestionsBuilder suggestionsbuilder) {
        if (suggestionsbuilder.getRemaining().isEmpty() && this.tag != null) {
            Holder holder;
            Block block;
            boolean flag = false;
            boolean flag1 = false;
            Iterator iterator = this.tag.iterator();
            while (!(!iterator.hasNext() || (flag |= !(block = (Block)(holder = (Holder)iterator.next()).value()).getStateDefinition().getProperties().isEmpty()) && (flag1 |= block.defaultBlockState().hasBlockEntity()))) {
            }
            if (flag) {
                suggestionsbuilder.suggest(String.valueOf('['));
            }
            if (flag1) {
                suggestionsbuilder.suggest(String.valueOf('{'));
            }
        }
        return suggestionsbuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestOpenPropertiesOrNbt(SuggestionsBuilder suggestionsbuilder) {
        if (suggestionsbuilder.getRemaining().isEmpty()) {
            if (!this.definition.getProperties().isEmpty()) {
                suggestionsbuilder.suggest(String.valueOf('['));
            }
            if (this.state.hasBlockEntity()) {
                suggestionsbuilder.suggest(String.valueOf('{'));
            }
        }
        return suggestionsbuilder.buildFuture();
    }

    private CompletableFuture<Suggestions> suggestTag(SuggestionsBuilder suggestionsbuilder) {
        return ICompletionProvider.suggestResource(this.blocks.listTagIds().map(TagKey::location), suggestionsbuilder, String.valueOf('#'));
    }

    private CompletableFuture<Suggestions> suggestItem(SuggestionsBuilder suggestionsbuilder) {
        return ICompletionProvider.suggestResource(this.blocks.listElementIds().map(ResourceKey::location), suggestionsbuilder);
    }

    private CompletableFuture<Suggestions> suggestBlockIdOrTag(SuggestionsBuilder suggestionsbuilder) {
        this.suggestTag(suggestionsbuilder);
        this.suggestItem(suggestionsbuilder);
        return suggestionsbuilder.buildFuture();
    }

    private void readBlock() throws CommandSyntaxException {
        int i2 = this.reader.getCursor();
        this.id = MinecraftKey.read(this.reader);
        Block block = this.blocks.get(ResourceKey.create(Registries.BLOCK, this.id)).orElseThrow(() -> {
            this.reader.setCursor(i2);
            return ERROR_UNKNOWN_BLOCK.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString());
        }).value();
        this.definition = block.getStateDefinition();
        this.state = block.defaultBlockState();
    }

    private void readTag() throws CommandSyntaxException {
        if (!this.forTesting) {
            throw ERROR_NO_TAGS_ALLOWED.createWithContext((ImmutableStringReader)this.reader);
        }
        int i2 = this.reader.getCursor();
        this.reader.expect('#');
        this.suggestions = this::suggestTag;
        MinecraftKey minecraftkey = MinecraftKey.read(this.reader);
        this.tag = this.blocks.get(TagKey.create(Registries.BLOCK, minecraftkey)).orElseThrow(() -> {
            this.reader.setCursor(i2);
            return ERROR_UNKNOWN_TAG.createWithContext((ImmutableStringReader)this.reader, (Object)minecraftkey.toString());
        });
    }

    private void readProperties() throws CommandSyntaxException {
        this.reader.skip();
        this.suggestions = this::suggestPropertyNameOrEnd;
        this.reader.skipWhitespace();
        while (this.reader.canRead() && this.reader.peek() != ']') {
            this.reader.skipWhitespace();
            int i2 = this.reader.getCursor();
            String s2 = this.reader.readString();
            IBlockState<?> iblockstate = this.definition.getProperty(s2);
            if (iblockstate == null) {
                this.reader.setCursor(i2);
                throw ERROR_UNKNOWN_PROPERTY.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)s2);
            }
            if (this.properties.containsKey(iblockstate)) {
                this.reader.setCursor(i2);
                throw ERROR_DUPLICATE_PROPERTY.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)s2);
            }
            this.reader.skipWhitespace();
            this.suggestions = this::suggestEquals;
            if (!this.reader.canRead() || this.reader.peek() != '=') {
                throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)s2);
            }
            this.reader.skip();
            this.reader.skipWhitespace();
            this.suggestions = suggestionsbuilder -> ArgumentBlock.addSuggestions(suggestionsbuilder, iblockstate).buildFuture();
            int j2 = this.reader.getCursor();
            this.setValue(iblockstate, this.reader.readString(), j2);
            this.suggestions = this::suggestNextPropertyOrEnd;
            this.reader.skipWhitespace();
            if (!this.reader.canRead()) continue;
            if (this.reader.peek() == ',') {
                this.reader.skip();
                this.suggestions = this::suggestPropertyName;
                continue;
            }
            if (this.reader.peek() == ']') break;
            throw ERROR_EXPECTED_END_OF_PROPERTIES.createWithContext((ImmutableStringReader)this.reader);
        }
        if (this.reader.canRead()) {
            this.reader.skip();
            return;
        }
        throw ERROR_EXPECTED_END_OF_PROPERTIES.createWithContext((ImmutableStringReader)this.reader);
    }

    private void readVagueProperties() throws CommandSyntaxException {
        this.reader.skip();
        this.suggestions = this::suggestVaguePropertyNameOrEnd;
        int i2 = -1;
        this.reader.skipWhitespace();
        while (this.reader.canRead() && this.reader.peek() != ']') {
            this.reader.skipWhitespace();
            int j2 = this.reader.getCursor();
            String s2 = this.reader.readString();
            if (this.vagueProperties.containsKey(s2)) {
                this.reader.setCursor(j2);
                throw ERROR_DUPLICATE_PROPERTY.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)s2);
            }
            this.reader.skipWhitespace();
            if (!this.reader.canRead() || this.reader.peek() != '=') {
                this.reader.setCursor(j2);
                throw ERROR_EXPECTED_VALUE.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)s2);
            }
            this.reader.skip();
            this.reader.skipWhitespace();
            this.suggestions = suggestionsbuilder -> this.suggestVaguePropertyValue((SuggestionsBuilder)suggestionsbuilder, s2);
            i2 = this.reader.getCursor();
            String s1 = this.reader.readString();
            this.vagueProperties.put(s2, s1);
            this.reader.skipWhitespace();
            if (!this.reader.canRead()) continue;
            i2 = -1;
            if (this.reader.peek() == ',') {
                this.reader.skip();
                this.suggestions = this::suggestVaguePropertyName;
                continue;
            }
            if (this.reader.peek() == ']') break;
            throw ERROR_EXPECTED_END_OF_PROPERTIES.createWithContext((ImmutableStringReader)this.reader);
        }
        if (this.reader.canRead()) {
            this.reader.skip();
            return;
        }
        if (i2 >= 0) {
            this.reader.setCursor(i2);
        }
        throw ERROR_EXPECTED_END_OF_PROPERTIES.createWithContext((ImmutableStringReader)this.reader);
    }

    private void readNbt() throws CommandSyntaxException {
        this.nbt = new MojangsonParser(this.reader).readStruct();
    }

    private <T extends Comparable<T>> void setValue(IBlockState<T> iblockstate, String s2, int i2) throws CommandSyntaxException {
        Optional<T> optional = iblockstate.getValue(s2);
        if (!optional.isPresent()) {
            this.reader.setCursor(i2);
            throw ERROR_INVALID_VALUE.createWithContext((ImmutableStringReader)this.reader, (Object)this.id.toString(), (Object)iblockstate.getName(), (Object)s2);
        }
        this.state = (IBlockData)this.state.setValue(iblockstate, (Comparable)optional.get());
        this.properties.put(iblockstate, (Comparable)optional.get());
    }

    public static String serialize(IBlockData iblockdata) {
        StringBuilder stringbuilder = new StringBuilder(iblockdata.getBlockHolder().unwrapKey().map(resourcekey -> resourcekey.location().toString()).orElse("air"));
        if (!iblockdata.getProperties().isEmpty()) {
            stringbuilder.append('[');
            boolean flag = false;
            for (Map.Entry<IBlockState<?>, Comparable<?>> entry : iblockdata.getValues().entrySet()) {
                if (flag) {
                    stringbuilder.append(',');
                }
                ArgumentBlock.appendProperty(stringbuilder, entry.getKey(), entry.getValue());
                flag = true;
            }
            stringbuilder.append(']');
        }
        return stringbuilder.toString();
    }

    private static <T extends Comparable<T>> void appendProperty(StringBuilder stringbuilder, IBlockState<T> iblockstate, Comparable<?> comparable) {
        stringbuilder.append(iblockstate.getName());
        stringbuilder.append('=');
        stringbuilder.append(iblockstate.getName(comparable));
    }

    public record a(IBlockData blockState, Map<IBlockState<?>, Comparable<?>> properties, @Nullable NBTTagCompound nbt) {
    }

    public record b(HolderSet<Block> tag, Map<String, String> vagueProperties, @Nullable NBTTagCompound nbt) {
    }
}

