/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.arguments.blocks;

import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.nbt.GameProfileSerializer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.pattern.ShapeDetectorBlock;
import net.minecraft.world.level.block.state.properties.IBlockState;

public class ArgumentTileLocation
implements Predicate<ShapeDetectorBlock> {
    private final IBlockData state;
    private final Set<IBlockState<?>> properties;
    @Nullable
    private final NBTTagCompound tag;

    public ArgumentTileLocation(IBlockData var0, Set<IBlockState<?>> var1, @Nullable NBTTagCompound var2) {
        this.state = var0;
        this.properties = var1;
        this.tag = var2;
    }

    public IBlockData getState() {
        return this.state;
    }

    public Set<IBlockState<?>> getDefinedProperties() {
        return this.properties;
    }

    @Override
    public boolean test(ShapeDetectorBlock var0) {
        IBlockData var1 = var0.getState();
        if (!var1.is(this.state.getBlock())) {
            return false;
        }
        for (IBlockState<?> var3 : this.properties) {
            if (var1.getValue(var3) == this.state.getValue(var3)) continue;
            return false;
        }
        if (this.tag != null) {
            TileEntity var2 = var0.getEntity();
            return var2 != null && GameProfileSerializer.compareNbt(this.tag, var2.saveWithFullMetadata(var0.getLevel().registryAccess()), true);
        }
        return true;
    }

    public boolean test(WorldServer var0, BlockPosition var1) {
        return this.test(new ShapeDetectorBlock(var0, var1, false));
    }

    public boolean place(WorldServer var0, BlockPosition var1, int var2) {
        TileEntity var4;
        IBlockData var3 = Block.updateFromNeighbourShapes(this.state, var0, var1);
        if (var3.isAir()) {
            var3 = this.state;
        }
        if (!var0.setBlock(var1, var3, var2)) {
            return false;
        }
        if (this.tag != null && (var4 = var0.getBlockEntity(var1)) != null) {
            var4.loadWithComponents(this.tag, var0.registryAccess());
        }
        return true;
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((ShapeDetectorBlock)object);
    }
}

