/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.commands.execution.tasks;

import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ContextChain;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.ExecutionCommandSource;
import net.minecraft.commands.execution.ChainModifiers;
import net.minecraft.commands.execution.ExecutionContext;
import net.minecraft.commands.execution.Frame;
import net.minecraft.commands.execution.TraceCallbacks;
import net.minecraft.commands.execution.UnboundEntryAction;

public class ExecuteCommand<T extends ExecutionCommandSource<T>>
implements UnboundEntryAction<T> {
    private final String commandInput;
    private final ChainModifiers modifiers;
    private final CommandContext<T> executionContext;

    public ExecuteCommand(String var0, ChainModifiers var1, CommandContext<T> var2) {
        this.commandInput = var0;
        this.modifiers = var1;
        this.executionContext = var2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(T var0, ExecutionContext<T> var1, Frame var2) {
        var1.profiler().push(() -> "execute " + this.commandInput);
        try {
            var1.incrementCost();
            int var3 = ContextChain.runExecutable(this.executionContext, var0, ExecutionCommandSource.resultConsumer(), (boolean)this.modifiers.isForked());
            TraceCallbacks var4 = var1.tracer();
            if (var4 != null) {
                var4.onReturn(var2.depth(), this.commandInput, var3);
            }
        }
        catch (CommandSyntaxException var3) {
            var0.handleError(var3, this.modifiers.isForked(), var1.tracer());
        }
        finally {
            var1.profiler().pop();
        }
    }

    @Override
    public /* synthetic */ void execute(Object object, ExecutionContext executionContext, Frame frame) {
        this.execute((ExecutionCommandSource)object, executionContext, frame);
    }
}

