/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.Lifecycle;
import java.util.Map;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.Holder;
import net.minecraft.core.HolderGetter;
import net.minecraft.core.HolderOwner;
import net.minecraft.core.HolderSet;
import net.minecraft.core.IRegistry;
import net.minecraft.resources.RegistryOps;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.TagKey;
import net.minecraft.world.flag.FeatureElement;
import net.minecraft.world.flag.FeatureFlagSet;

public interface HolderLookup<T>
extends HolderGetter<T> {
    public Stream<Holder.c<T>> listElements();

    default public Stream<ResourceKey<T>> listElementIds() {
        return this.listElements().map(Holder.c::key);
    }

    public Stream<HolderSet.Named<T>> listTags();

    default public Stream<TagKey<T>> listTagIds() {
        return this.listTags().map(HolderSet.Named::key);
    }

    public static interface a {
        public Stream<ResourceKey<? extends IRegistry<?>>> listRegistries();

        public <T> Optional<b<T>> lookup(ResourceKey<? extends IRegistry<? extends T>> var1);

        default public <T> b<T> lookupOrThrow(ResourceKey<? extends IRegistry<? extends T>> var0) {
            return this.lookup(var0).orElseThrow(() -> new IllegalStateException("Registry " + String.valueOf(var0.location()) + " not found"));
        }

        default public <V> RegistryOps<V> createSerializationContext(DynamicOps<V> var0) {
            return RegistryOps.create(var0, this);
        }

        default public HolderGetter.a asGetterLookup() {
            return new HolderGetter.a(){

                @Override
                public <T> Optional<HolderGetter<T>> lookup(ResourceKey<? extends IRegistry<? extends T>> var02) {
                    return this.lookup(var02).map(var0 -> var0);
                }
            };
        }

        public static a create(Stream<b<?>> var02) {
            final Map<ResourceKey, b> var1 = var02.collect(Collectors.toUnmodifiableMap(b::key, var0 -> var0));
            return new a(){

                @Override
                public Stream<ResourceKey<? extends IRegistry<?>>> listRegistries() {
                    return var1.keySet().stream();
                }

                @Override
                public <T> Optional<b<T>> lookup(ResourceKey<? extends IRegistry<? extends T>> var0) {
                    return Optional.ofNullable((b)var1.get(var0));
                }
            };
        }
    }

    public static interface b<T>
    extends HolderLookup<T>,
    HolderOwner<T> {
        public ResourceKey<? extends IRegistry<? extends T>> key();

        public Lifecycle registryLifecycle();

        default public b<T> filterFeatures(FeatureFlagSet var0) {
            if (FeatureElement.FILTERED_REGISTRIES.contains(this.key())) {
                return this.filterElements(var1 -> ((FeatureElement)var1).isEnabled(var0));
            }
            return this;
        }

        default public b<T> filterElements(final Predicate<T> var0) {
            return new a<T>(){

                @Override
                public b<T> parent() {
                    return this;
                }

                @Override
                public Optional<Holder.c<T>> get(ResourceKey<T> var02) {
                    return this.parent().get(var02).filter(var1 -> var0.test(var1.value()));
                }

                @Override
                public Stream<Holder.c<T>> listElements() {
                    return this.parent().listElements().filter(var1 -> var0.test(var1.value()));
                }
            };
        }

        public static interface a<T>
        extends b<T> {
            public b<T> parent();

            @Override
            default public ResourceKey<? extends IRegistry<? extends T>> key() {
                return this.parent().key();
            }

            @Override
            default public Lifecycle registryLifecycle() {
                return this.parent().registryLifecycle();
            }

            @Override
            default public Optional<Holder.c<T>> get(ResourceKey<T> var0) {
                return this.parent().get(var0);
            }

            @Override
            default public Stream<Holder.c<T>> listElements() {
                return this.parent().listElements();
            }

            @Override
            default public Optional<HolderSet.Named<T>> get(TagKey<T> var0) {
                return this.parent().get(var0);
            }

            @Override
            default public Stream<HolderSet.Named<T>> listTags() {
                return this.parent().listTags();
            }
        }
    }
}

