/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core;

import com.mojang.serialization.DynamicOps;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.LayeredRegistryAccess;
import net.minecraft.core.RegistrationInfo;
import net.minecraft.nbt.NBTBase;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.RegistryDataLoader;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.RegistryLayer;
import net.minecraft.server.packs.repository.KnownPack;

public class RegistrySynchronization {
    public static final Set<ResourceKey<? extends IRegistry<?>>> NETWORKABLE_REGISTRIES = RegistryDataLoader.SYNCHRONIZED_REGISTRIES.stream().map(RegistryDataLoader.c::key).collect(Collectors.toUnmodifiableSet());

    public static void packRegistries(DynamicOps<NBTBase> var0, IRegistryCustom var1, Set<KnownPack> var2, BiConsumer<ResourceKey<? extends IRegistry<?>>, List<a>> var3) {
        RegistryDataLoader.SYNCHRONIZED_REGISTRIES.forEach(var4 -> RegistrySynchronization.packRegistry(var0, var4, var1, var2, var3));
    }

    private static <T> void packRegistry(DynamicOps<NBTBase> var0, RegistryDataLoader.c<T> var1, IRegistryCustom var2, Set<KnownPack> var3, BiConsumer<ResourceKey<? extends IRegistry<?>>, List<a>> var42) {
        var2.registry(var1.key()).ifPresent(var4 -> {
            ArrayList var52 = new ArrayList(var4.size());
            var4.holders().forEach(var5 -> {
                Optional<NBTBase> var7;
                boolean var6 = var4.registrationInfo(var5.key()).flatMap(RegistrationInfo::knownPackInfo).filter(var3::contains).isPresent();
                if (var6) {
                    var7 = Optional.empty();
                } else {
                    NBTBase var8 = (NBTBase)var1.elementCodec().encodeStart(var0, var5.value()).getOrThrow(var1 -> new IllegalArgumentException("Failed to serialize " + String.valueOf(var5.key()) + ": " + var1));
                    var7 = Optional.of(var8);
                }
                var52.add(new a(var5.key().location(), var7));
            });
            var42.accept(var4.key(), var52);
        });
    }

    private static Stream<IRegistryCustom.d<?>> ownedNetworkableRegistries(IRegistryCustom var02) {
        return var02.registries().filter(var0 -> NETWORKABLE_REGISTRIES.contains(var0.key()));
    }

    public static Stream<IRegistryCustom.d<?>> networkedRegistries(LayeredRegistryAccess<RegistryLayer> var0) {
        return RegistrySynchronization.ownedNetworkableRegistries(var0.getAccessFrom(RegistryLayer.WORLDGEN));
    }

    public static Stream<IRegistryCustom.d<?>> networkSafeRegistries(LayeredRegistryAccess<RegistryLayer> var0) {
        Stream<IRegistryCustom.d<?>> var1 = var0.getLayer(RegistryLayer.STATIC).registries();
        Stream<IRegistryCustom.d<?>> var2 = RegistrySynchronization.networkedRegistries(var0);
        return Stream.concat(var2, var1);
    }

    public record a(MinecraftKey id, Optional<NBTBase> data) {
        public static final StreamCodec<ByteBuf, a> STREAM_CODEC = StreamCodec.composite(MinecraftKey.STREAM_CODEC, a::id, ByteBufCodecs.TAG.apply(ByteBufCodecs::optional), a::data, a::new);
    }
}

