/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.Sets;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import it.unimi.dsi.fastutil.objects.Reference2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMap;
import it.unimi.dsi.fastutil.objects.Reference2ObjectMaps;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.Unit;

public final class DataComponentPatch {
    public static final DataComponentPatch EMPTY = new DataComponentPatch(Reference2ObjectMaps.emptyMap());
    public static final Codec<DataComponentPatch> CODEC = Codec.dispatchedMap(b.CODEC, b::valueCodec).xmap(map -> {
        if (map.isEmpty()) {
            return EMPTY;
        }
        Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(map.size());
        for (Map.Entry entry : map.entrySet()) {
            b datacomponentpatch_b = (b)entry.getKey();
            if (datacomponentpatch_b.removed()) {
                reference2objectmap.put(datacomponentpatch_b.type(), Optional.empty());
                continue;
            }
            reference2objectmap.put(datacomponentpatch_b.type(), Optional.of(entry.getValue()));
        }
        return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)reference2objectmap);
    }, datacomponentpatch -> {
        Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(datacomponentpatch.map.size());
        for (Map.Entry entry : Reference2ObjectMaps.fastIterable(datacomponentpatch.map)) {
            DataComponentType datacomponenttype = (DataComponentType)entry.getKey();
            if (datacomponenttype.isTransient()) continue;
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                reference2objectmap.put((Object)new b(datacomponenttype, false), optional.get());
                continue;
            }
            reference2objectmap.put((Object)new b(datacomponenttype, true), (Object)Unit.INSTANCE);
        }
        return reference2objectmap;
    });
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch> STREAM_CODEC = new StreamCodec<RegistryFriendlyByteBuf, DataComponentPatch>(){

        @Override
        public DataComponentPatch decode(RegistryFriendlyByteBuf registryfriendlybytebuf) {
            DataComponentType datacomponenttype;
            int l2;
            int i2 = registryfriendlybytebuf.readVarInt();
            int j2 = registryfriendlybytebuf.readVarInt();
            if (i2 == 0 && j2 == 0) {
                return EMPTY;
            }
            int k2 = i2 + j2;
            Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(Math.min(k2, 65536));
            for (l2 = 0; l2 < i2; ++l2) {
                datacomponenttype = (DataComponentType)DataComponentType.STREAM_CODEC.decode(registryfriendlybytebuf);
                Object object = datacomponenttype.streamCodec().decode(registryfriendlybytebuf);
                reference2objectmap.put((Object)datacomponenttype, Optional.of(object));
            }
            for (l2 = 0; l2 < j2; ++l2) {
                datacomponenttype = (DataComponentType)DataComponentType.STREAM_CODEC.decode(registryfriendlybytebuf);
                reference2objectmap.put((Object)datacomponenttype, Optional.empty());
            }
            return new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)reference2objectmap);
        }

        @Override
        public void encode(RegistryFriendlyByteBuf registryfriendlybytebuf, DataComponentPatch datacomponentpatch) {
            if (datacomponentpatch.isEmpty()) {
                registryfriendlybytebuf.writeVarInt(0);
                registryfriendlybytebuf.writeVarInt(0);
            } else {
                int i2 = 0;
                int j2 = 0;
                for (Reference2ObjectMap.Entry it_unimi_dsi_fastutil_objects_reference2objectmap_entry : Reference2ObjectMaps.fastIterable(datacomponentpatch.map)) {
                    if (((Optional)it_unimi_dsi_fastutil_objects_reference2objectmap_entry.getValue()).isPresent()) {
                        ++i2;
                        continue;
                    }
                    ++j2;
                }
                registryfriendlybytebuf.writeVarInt(i2);
                registryfriendlybytebuf.writeVarInt(j2);
                for (Reference2ObjectMap.Entry it_unimi_dsi_fastutil_objects_reference2objectmap_entry : Reference2ObjectMaps.fastIterable(datacomponentpatch.map)) {
                    Optional optional = (Optional)it_unimi_dsi_fastutil_objects_reference2objectmap_entry.getValue();
                    if (!optional.isPresent()) continue;
                    DataComponentType datacomponenttype = (DataComponentType)it_unimi_dsi_fastutil_objects_reference2objectmap_entry.getKey();
                    DataComponentType.STREAM_CODEC.encode(registryfriendlybytebuf, datacomponenttype);
                    1.encodeComponent(registryfriendlybytebuf, datacomponenttype, optional.get());
                }
                for (Reference2ObjectMap.Entry it_unimi_dsi_fastutil_objects_reference2objectmap_entry : Reference2ObjectMaps.fastIterable(datacomponentpatch.map)) {
                    if (!((Optional)it_unimi_dsi_fastutil_objects_reference2objectmap_entry.getValue()).isEmpty()) continue;
                    DataComponentType datacomponenttype1 = (DataComponentType)it_unimi_dsi_fastutil_objects_reference2objectmap_entry.getKey();
                    DataComponentType.STREAM_CODEC.encode(registryfriendlybytebuf, datacomponenttype1);
                }
            }
        }

        private static <T> void encodeComponent(RegistryFriendlyByteBuf registryfriendlybytebuf, DataComponentType<T> datacomponenttype, Object object) {
            datacomponenttype.streamCodec().encode(registryfriendlybytebuf, object);
        }
    };
    private static final String REMOVED_PREFIX = "!";
    final Reference2ObjectMap<DataComponentType<?>, Optional<?>> map;

    DataComponentPatch(Reference2ObjectMap<DataComponentType<?>, Optional<?>> reference2objectmap) {
        this.map = reference2objectmap;
    }

    public static a builder() {
        return new a();
    }

    @Nullable
    public <T> Optional<? extends T> get(DataComponentType<? extends T> datacomponenttype) {
        return (Optional)this.map.get(datacomponenttype);
    }

    public Set<Map.Entry<DataComponentType<?>, Optional<?>>> entrySet() {
        return this.map.entrySet();
    }

    public int size() {
        return this.map.size();
    }

    public DataComponentPatch forget(Predicate<DataComponentType<?>> predicate) {
        if (this.isEmpty()) {
            return EMPTY;
        }
        Reference2ObjectArrayMap reference2objectmap = new Reference2ObjectArrayMap(this.map);
        reference2objectmap.keySet().removeIf(predicate);
        return reference2objectmap.isEmpty() ? EMPTY : new DataComponentPatch((Reference2ObjectMap<DataComponentType<?>, Optional<?>>)reference2objectmap);
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public c split() {
        if (this.isEmpty()) {
            return c.EMPTY;
        }
        DataComponentMap.a datacomponentmap_a = DataComponentMap.builder();
        Set set = Sets.newIdentityHashSet();
        this.map.forEach((datacomponenttype, optional) -> {
            if (optional.isPresent()) {
                datacomponentmap_a.setUnchecked(datacomponenttype, optional.get());
            } else {
                set.add(datacomponenttype);
            }
        });
        return new c(datacomponentmap_a.build(), set);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object instanceof DataComponentPatch) {
            DataComponentPatch datacomponentpatch = (DataComponentPatch)object;
            if (this.map.equals(datacomponentpatch.map)) {
                boolean flag = true;
                return flag;
            }
        }
        boolean flag = false;
        return flag;
    }

    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return DataComponentPatch.toString(this.map);
    }

    static String toString(Reference2ObjectMap<DataComponentType<?>, Optional<?>> reference2objectmap) {
        StringBuilder stringbuilder = new StringBuilder();
        stringbuilder.append('{');
        boolean flag = true;
        for (Map.Entry entry : Reference2ObjectMaps.fastIterable(reference2objectmap)) {
            if (flag) {
                flag = false;
            } else {
                stringbuilder.append(", ");
            }
            Optional optional = (Optional)entry.getValue();
            if (optional.isPresent()) {
                stringbuilder.append(entry.getKey());
                stringbuilder.append("=>");
                stringbuilder.append(optional.get());
                continue;
            }
            stringbuilder.append(REMOVED_PREFIX);
            stringbuilder.append(entry.getKey());
        }
        stringbuilder.append('}');
        return stringbuilder.toString();
    }

    public static class a {
        private final Reference2ObjectMap<DataComponentType<?>, Optional<?>> map = new Reference2ObjectArrayMap();

        a() {
        }

        public void copy(DataComponentPatch orig) {
            this.map.putAll(orig.map);
        }

        public void clear(DataComponentType<?> type) {
            this.map.remove(type);
        }

        public boolean isSet(DataComponentType<?> type) {
            return this.map.containsKey(type);
        }

        public boolean isEmpty() {
            return this.map.isEmpty();
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof a) {
                a patch = (a)object;
                return this.map.equals(patch.map);
            }
            return false;
        }

        public int hashCode() {
            return this.map.hashCode();
        }

        public <T> a set(DataComponentType<T> datacomponenttype, T t0) {
            this.map.put(datacomponenttype, Optional.of(t0));
            return this;
        }

        public <T> a remove(DataComponentType<T> datacomponenttype) {
            this.map.put(datacomponenttype, Optional.empty());
            return this;
        }

        public <T> a set(TypedDataComponent<T> typeddatacomponent) {
            return this.set(typeddatacomponent.type(), typeddatacomponent.value());
        }

        public DataComponentPatch build() {
            return this.map.isEmpty() ? EMPTY : new DataComponentPatch(this.map);
        }
    }

    public record c(DataComponentMap added, Set<DataComponentType<?>> removed) {
        public static final c EMPTY = new c(DataComponentMap.EMPTY, Set.of());
    }

    private record b(DataComponentType<?> type, boolean removed) {
        public static final Codec<b> CODEC = Codec.STRING.flatXmap(s2 -> {
            MinecraftKey minecraftkey;
            DataComponentType<?> datacomponenttype;
            boolean flag = s2.startsWith(DataComponentPatch.REMOVED_PREFIX);
            if (flag) {
                s2 = s2.substring(DataComponentPatch.REMOVED_PREFIX.length());
            }
            return (datacomponenttype = BuiltInRegistries.DATA_COMPONENT_TYPE.get(minecraftkey = MinecraftKey.tryParse(s2))) == null ? DataResult.error(() -> "No component with type: '" + String.valueOf(minecraftkey) + "'") : (datacomponenttype.isTransient() ? DataResult.error(() -> "'" + String.valueOf(minecraftkey) + "' is not a persistent component") : DataResult.success((Object)new b(datacomponenttype, flag)));
        }, datacomponentpatch_b -> {
            DataComponentType<?> datacomponenttype = datacomponentpatch_b.type();
            MinecraftKey minecraftkey = BuiltInRegistries.DATA_COMPONENT_TYPE.getKey(datacomponenttype);
            return minecraftkey == null ? DataResult.error(() -> "Unregistered component: " + String.valueOf(datacomponenttype)) : DataResult.success((Object)(datacomponentpatch_b.removed() ? DataComponentPatch.REMOVED_PREFIX + String.valueOf(minecraftkey) : minecraftkey.toString()));
        });

        public Codec<?> valueCodec() {
            return this.removed ? Codec.EMPTY.codec() : this.type.codecOrThrow();
        }
    }
}

