/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.component;

import com.google.common.collect.ImmutableList;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.component.DataComponentHolder;
import net.minecraft.core.component.DataComponentMap;
import net.minecraft.core.component.DataComponentPatch;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.core.component.TypedDataComponent;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;

public final class DataComponentPredicate
implements Predicate<DataComponentMap> {
    public static final Codec<DataComponentPredicate> CODEC = DataComponentType.VALUE_MAP_CODEC.xmap(var0 -> new DataComponentPredicate(var0.entrySet().stream().map(TypedDataComponent::fromEntryUnchecked).collect(Collectors.toList())), var02 -> var02.expectedComponents.stream().filter(var0 -> !var0.type().isTransient()).collect(Collectors.toMap(TypedDataComponent::type, TypedDataComponent::value)));
    public static final StreamCodec<RegistryFriendlyByteBuf, DataComponentPredicate> STREAM_CODEC = TypedDataComponent.STREAM_CODEC.apply(ByteBufCodecs.list()).map(DataComponentPredicate::new, var0 -> var0.expectedComponents);
    public static final DataComponentPredicate EMPTY = new DataComponentPredicate(List.of());
    private final List<TypedDataComponent<?>> expectedComponents;

    DataComponentPredicate(List<TypedDataComponent<?>> var0) {
        this.expectedComponents = var0;
    }

    public static a builder() {
        return new a();
    }

    public static DataComponentPredicate allOf(DataComponentMap var0) {
        return new DataComponentPredicate((List<TypedDataComponent<?>>)ImmutableList.copyOf((Iterable)var0));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object var0) {
        if (!(var0 instanceof DataComponentPredicate)) return false;
        DataComponentPredicate var1 = (DataComponentPredicate)var0;
        if (!this.expectedComponents.equals(var1.expectedComponents)) return false;
        return true;
    }

    public int hashCode() {
        return this.expectedComponents.hashCode();
    }

    public String toString() {
        return this.expectedComponents.toString();
    }

    @Override
    public boolean test(DataComponentMap var0) {
        for (TypedDataComponent<?> var2 : this.expectedComponents) {
            Object var3 = var0.get(var2.type());
            if (Objects.equals(var2.value(), var3)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean test(DataComponentHolder var0) {
        return this.test(var0.getComponents());
    }

    public boolean alwaysMatches() {
        return this.expectedComponents.isEmpty();
    }

    public DataComponentPatch asPatch() {
        DataComponentPatch.a var0 = DataComponentPatch.builder();
        for (TypedDataComponent<?> var2 : this.expectedComponents) {
            var0.set(var2);
        }
        return var0.build();
    }

    @Override
    public /* synthetic */ boolean test(Object object) {
        return this.test((DataComponentMap)object);
    }

    public static class a {
        private final List<TypedDataComponent<?>> expectedComponents = new ArrayList();

        a() {
        }

        public <T> a expect(DataComponentType<? super T> var0, T var1) {
            for (TypedDataComponent<?> var3 : this.expectedComponents) {
                if (var3.type() != var0) continue;
                throw new IllegalArgumentException("Predicate already has component of type: '" + String.valueOf(var0) + "'");
            }
            this.expectedComponents.add(new TypedDataComponent<T>(var0, var1));
            return this;
        }

        public DataComponentPredicate build() {
            return new DataComponentPredicate(List.copyOf(this.expectedComponents));
        }
    }
}

