/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.vehicle.ChestBoat;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class DispenseBehaviorBoat
extends DispenseBehaviorItem {
    private final DispenseBehaviorItem defaultDispenseItemBehavior = new DispenseBehaviorItem();
    private final EntityBoat.EnumBoatType type;
    private final boolean isChestBoat;

    public DispenseBehaviorBoat(EntityBoat.EnumBoatType entityboat_enumboattype) {
        this(entityboat_enumboattype, false);
    }

    public DispenseBehaviorBoat(EntityBoat.EnumBoatType entityboat_enumboattype, boolean flag) {
        this.type = entityboat_enumboattype;
        this.isChestBoat = flag;
    }

    @Override
    public net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
        double d4;
        EnumDirection enumdirection = sourceblock.state().getValue(BlockDispenser.FACING);
        WorldServer worldserver = sourceblock.level();
        Vec3D vec3d = sourceblock.center();
        double d0 = 0.5625 + (double)EntityTypes.BOAT.getWidth() / 2.0;
        double d1 = vec3d.x() + (double)enumdirection.getStepX() * d0;
        double d2 = vec3d.y() + (double)((float)enumdirection.getStepY() * 1.125f);
        double d3 = vec3d.z() + (double)enumdirection.getStepZ() * d0;
        BlockPosition blockposition = sourceblock.pos().relative(enumdirection);
        if (worldserver.getFluidState(blockposition).is(TagsFluid.WATER)) {
            d4 = 1.0;
        } else {
            if (!worldserver.getBlockState(blockposition).isAir() || !worldserver.getFluidState(blockposition.below()).is(TagsFluid.WATER)) {
                return this.defaultDispenseItemBehavior.dispense(sourceblock, itemstack);
            }
            d4 = 0.0;
        }
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.split(1);
        CraftBlock block = CraftBlock.at(worldserver, sourceblock.pos());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
        BlockDispenseEvent event = new BlockDispenseEvent((Block)block, (ItemStack)craftItem.clone(), new Vector(d1, d2 + d4, d3));
        if (!BlockDispenser.eventFired) {
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            itemstack.grow(1);
            return itemstack;
        }
        if (!event.getItem().equals((Object)craftItem)) {
            itemstack.grow(1);
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            IDispenseBehavior idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get(eventStack.getItem());
            if (idispensebehavior != IDispenseBehavior.NOOP && idispensebehavior != this) {
                idispensebehavior.dispense(sourceblock, eventStack);
                return itemstack;
            }
        }
        EntityBoat object = this.isChestBoat ? new ChestBoat(worldserver, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ()) : new EntityBoat(worldserver, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ());
        EntityTypes.createDefaultStackConfig(worldserver, itemstack, null).accept(object);
        object.setVariant(this.type);
        object.setYRot(enumdirection.toYRot());
        if (!worldserver.addFreshEntity(object)) {
            itemstack.grow(1);
        }
        return itemstack;
    }

    @Override
    protected void playSound(SourceBlock sourceblock) {
        sourceblock.level().levelEvent(1000, sourceblock.pos(), 0);
    }
}

