/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.world.entity.item.EntityItem;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftVector;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;

public class DispenseBehaviorItem
implements IDispenseBehavior {
    private static final int DEFAULT_ACCURACY = 6;
    private boolean dropper;

    public DispenseBehaviorItem(boolean dropper) {
        this.dropper = dropper;
    }

    public DispenseBehaviorItem() {
    }

    @Override
    public final net.minecraft.world.item.ItemStack dispense(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
        net.minecraft.world.item.ItemStack itemstack1 = this.execute(sourceblock, itemstack);
        this.playSound(sourceblock);
        this.playAnimation(sourceblock, sourceblock.state().getValue(BlockDispenser.FACING));
        return itemstack1;
    }

    protected net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
        EnumDirection enumdirection = sourceblock.state().getValue(BlockDispenser.FACING);
        IPosition iposition = BlockDispenser.getDispensePosition(sourceblock);
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.split(1);
        if (!DispenseBehaviorItem.spawnItem(sourceblock.level(), itemstack1, 6, enumdirection, sourceblock, this.dropper)) {
            itemstack.grow(1);
        }
        return itemstack;
    }

    public static void spawnItem(World world, net.minecraft.world.item.ItemStack itemstack, int i2, EnumDirection enumdirection, IPosition iposition) {
        EntityItem entityitem = DispenseBehaviorItem.prepareItem(world, itemstack, i2, enumdirection, iposition);
        world.addFreshEntity(entityitem);
    }

    private static EntityItem prepareItem(World world, net.minecraft.world.item.ItemStack itemstack, int i2, EnumDirection enumdirection, IPosition iposition) {
        double d0 = iposition.x();
        double d1 = iposition.y();
        double d2 = iposition.z();
        d1 = enumdirection.getAxis() == EnumDirection.EnumAxis.Y ? (d1 -= 0.125) : (d1 -= 0.15625);
        EntityItem entityitem = new EntityItem(world, d0, d1, d2, itemstack);
        double d3 = world.random.nextDouble() * 0.1 + 0.2;
        entityitem.setDeltaMovement(world.random.triangle((double)enumdirection.getStepX() * d3, 0.0172275 * (double)i2), world.random.triangle(0.2, 0.0172275 * (double)i2), world.random.triangle((double)enumdirection.getStepZ() * d3, 0.0172275 * (double)i2));
        return entityitem;
    }

    public static boolean spawnItem(World world, net.minecraft.world.item.ItemStack itemstack, int i2, EnumDirection enumdirection, SourceBlock sourceblock, boolean dropper) {
        if (itemstack.isEmpty()) {
            return true;
        }
        IPosition iposition = BlockDispenser.getDispensePosition(sourceblock);
        EntityItem entityitem = DispenseBehaviorItem.prepareItem(world, itemstack, i2, enumdirection, iposition);
        CraftBlock block = CraftBlock.at(world, sourceblock.pos());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
        BlockDispenseEvent event = new BlockDispenseEvent((Block)block, (ItemStack)craftItem.clone(), CraftVector.toBukkit(entityitem.getDeltaMovement()));
        if (!BlockDispenser.eventFired) {
            world.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return false;
        }
        entityitem.setItem(CraftItemStack.asNMSCopy(event.getItem()));
        entityitem.setDeltaMovement(CraftVector.toNMS(event.getVelocity()));
        if (!dropper && !event.getItem().getType().equals((Object)craftItem.getType())) {
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            IDispenseBehavior idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get(eventStack.getItem());
            if (idispensebehavior != IDispenseBehavior.NOOP && idispensebehavior.getClass() != DispenseBehaviorItem.class) {
                idispensebehavior.dispense(sourceblock, eventStack);
            } else {
                world.addFreshEntity(entityitem);
            }
            return false;
        }
        world.addFreshEntity(entityitem);
        return true;
    }

    protected void playSound(SourceBlock sourceblock) {
        DispenseBehaviorItem.playDefaultSound(sourceblock);
    }

    protected void playAnimation(SourceBlock sourceblock, EnumDirection enumdirection) {
        DispenseBehaviorItem.playDefaultAnimation(sourceblock, enumdirection);
    }

    private static void playDefaultSound(SourceBlock sourceblock) {
        sourceblock.level().levelEvent(1000, sourceblock.pos(), 0);
    }

    private static void playDefaultAnimation(SourceBlock sourceblock, EnumDirection enumdirection) {
        sourceblock.level().levelEvent(2000, sourceblock.pos(), enumdirection.get3DDataValue());
    }

    protected net.minecraft.world.item.ItemStack consumeWithRemainder(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack, net.minecraft.world.item.ItemStack itemstack1) {
        itemstack.shrink(1);
        if (itemstack.isEmpty()) {
            return itemstack1;
        }
        this.addToInventoryOrDispense(sourceblock, itemstack1);
        return itemstack;
    }

    private void addToInventoryOrDispense(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
        net.minecraft.world.item.ItemStack itemstack1 = sourceblock.blockEntity().insertItem(itemstack);
        if (!itemstack1.isEmpty()) {
            EnumDirection enumdirection = sourceblock.state().getValue(BlockDispenser.FACING);
            DispenseBehaviorItem.spawnItem(sourceblock.level(), itemstack1, 6, enumdirection, BlockDispenser.getDispensePosition(sourceblock));
            DispenseBehaviorItem.playDefaultSound(sourceblock);
            DispenseBehaviorItem.playDefaultAnimation(sourceblock, enumdirection);
        }
    }
}

