/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import net.minecraft.core.EnumDirection;
import net.minecraft.core.IPosition;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.world.entity.projectile.IProjectile;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ProjectileItem;
import net.minecraft.world.level.block.BlockDispenser;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.projectiles.CraftBlockProjectileSource;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class DispenseBehaviorProjectile
extends DispenseBehaviorItem {
    private final ProjectileItem projectileItem;
    private final ProjectileItem.a dispenseConfig;

    public DispenseBehaviorProjectile(Item item) {
        ProjectileItem projectileitem;
        if (!(item instanceof ProjectileItem)) {
            String s2 = String.valueOf(item);
            throw new IllegalArgumentException(s2 + " not instance of " + ProjectileItem.class.getSimpleName());
        }
        this.projectileItem = projectileitem = (ProjectileItem)((Object)item);
        this.dispenseConfig = projectileitem.createDispenseConfig();
    }

    @Override
    public net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
        WorldServer worldserver = sourceblock.level();
        EnumDirection enumdirection = sourceblock.state().getValue(BlockDispenser.FACING);
        IPosition iposition = this.dispenseConfig.positionFunction().getDispensePosition(sourceblock, enumdirection);
        IProjectile iprojectile = this.projectileItem.asProjectile(worldserver, iposition, itemstack, enumdirection);
        net.minecraft.world.item.ItemStack itemstack1 = itemstack.split(1);
        CraftBlock block = CraftBlock.at(worldserver, sourceblock.pos());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
        BlockDispenseEvent event = new BlockDispenseEvent((Block)block, (ItemStack)craftItem.clone(), new Vector((double)enumdirection.getStepX(), (double)enumdirection.getStepY(), (double)enumdirection.getStepZ()));
        if (!BlockDispenser.eventFired) {
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            itemstack.grow(1);
            return itemstack;
        }
        if (!event.getItem().equals((Object)craftItem)) {
            itemstack.grow(1);
            net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
            IDispenseBehavior idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get(eventStack.getItem());
            if (idispensebehavior != IDispenseBehavior.NOOP && idispensebehavior != this) {
                idispensebehavior.dispense(sourceblock, eventStack);
                return itemstack;
            }
        }
        this.projectileItem.shoot(iprojectile, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ(), this.dispenseConfig.power(), this.dispenseConfig.uncertainty());
        iprojectile.projectileSource = new CraftBlockProjectileSource(sourceblock.blockEntity());
        worldserver.addFreshEntity(iprojectile);
        return itemstack;
    }

    @Override
    protected void playSound(SourceBlock sourceblock) {
        sourceblock.level().levelEvent(this.dispenseConfig.overrideDispenseEvent().orElse(1002), sourceblock.pos(), 0);
    }
}

