/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import java.util.List;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.dispenser.DispenseBehaviorMaybe;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.IShearable;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class DispenseBehaviorShears
extends DispenseBehaviorMaybe {
    @Override
    protected net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
        net.minecraft.world.item.ItemStack eventStack;
        IDispenseBehavior idispensebehavior;
        WorldServer worldserver = sourceblock.level();
        CraftBlock bukkitBlock = CraftBlock.at(worldserver, sourceblock.pos());
        CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
        BlockDispenseEvent event = new BlockDispenseEvent((Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
        if (!BlockDispenser.eventFired) {
            worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
        }
        if (event.isCancelled()) {
            return itemstack;
        }
        if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != IDispenseBehavior.NOOP && idispensebehavior != this) {
            idispensebehavior.dispense(sourceblock, eventStack);
            return itemstack;
        }
        if (!worldserver.isClientSide()) {
            BlockPosition blockposition = sourceblock.pos().relative(sourceblock.state().getValue(BlockDispenser.FACING));
            this.setSuccess(DispenseBehaviorShears.tryShearBeehive(worldserver, blockposition) || DispenseBehaviorShears.tryShearLivingEntity(worldserver, blockposition, bukkitBlock, craftItem));
            if (this.isSuccess()) {
                itemstack.hurtAndBreak(1, worldserver, null, item -> {});
            }
        }
        return itemstack;
    }

    private static boolean tryShearBeehive(WorldServer worldserver, BlockPosition blockposition) {
        int i2;
        IBlockData iblockdata = worldserver.getBlockState(blockposition);
        if (iblockdata.is(TagsBlock.BEEHIVES, blockbase_blockdata -> blockbase_blockdata.hasProperty(BlockBeehive.HONEY_LEVEL) && blockbase_blockdata.getBlock() instanceof BlockBeehive) && (i2 = iblockdata.getValue(BlockBeehive.HONEY_LEVEL).intValue()) >= 5) {
            worldserver.playSound((EntityHuman)null, blockposition, SoundEffects.BEEHIVE_SHEAR, SoundCategory.BLOCKS, 1.0f, 1.0f);
            BlockBeehive.dropHoneycomb(worldserver, blockposition);
            ((BlockBeehive)iblockdata.getBlock()).releaseBeesAndResetHoneyLevel(worldserver, iblockdata, blockposition, null, TileEntityBeehive.ReleaseStatus.BEE_RELEASED);
            worldserver.gameEvent((Entity)null, GameEvent.SHEAR, blockposition);
            return true;
        }
        return false;
    }

    private static boolean tryShearLivingEntity(WorldServer worldserver, BlockPosition blockposition, Block bukkitBlock, CraftItemStack craftItem) {
        List<Entity> list = worldserver.getEntitiesOfClass(EntityLiving.class, new AxisAlignedBB(blockposition), IEntitySelector.NO_SPECTATORS);
        for (EntityLiving entityLiving : list) {
            IShearable ishearable;
            if (!(entityLiving instanceof IShearable) || !(ishearable = (IShearable)((Object)entityLiving)).readyForShearing() || CraftEventFactory.callBlockShearEntityEvent(entityLiving, bukkitBlock, craftItem).isCancelled()) continue;
            ishearable.shear(SoundCategory.BLOCKS);
            worldserver.gameEvent((Entity)null, GameEvent.SHEAR, blockposition);
            return true;
        }
        return false;
    }
}

