/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import com.mojang.logging.LogUtils;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.dispenser.DispenseBehaviorMaybe;
import net.minecraft.core.dispenser.IDispenseBehavior;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemBlock;
import net.minecraft.world.item.context.BlockActionContextDirectional;
import net.minecraft.world.level.World;
import net.minecraft.world.level.block.BlockDispenser;
import org.bukkit.block.Block;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public class DispenseBehaviorShulkerBox
extends DispenseBehaviorMaybe {
    private static final Logger LOGGER = LogUtils.getLogger();

    @Override
    protected net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
        this.setSuccess(false);
        Item item = itemstack.getItem();
        if (item instanceof ItemBlock) {
            net.minecraft.world.item.ItemStack eventStack;
            IDispenseBehavior idispensebehavior;
            EnumDirection enumdirection = sourceblock.state().getValue(BlockDispenser.FACING);
            BlockPosition blockposition = sourceblock.pos().relative(enumdirection);
            EnumDirection enumdirection1 = sourceblock.level().isEmptyBlock(blockposition.below()) ? enumdirection : EnumDirection.UP;
            CraftBlock bukkitBlock = CraftBlock.at(sourceblock.level(), sourceblock.pos());
            CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
            BlockDispenseEvent event = new BlockDispenseEvent((Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
            if (!BlockDispenser.eventFired) {
                sourceblock.level().getCraftServer().getPluginManager().callEvent((Event)event);
            }
            if (event.isCancelled()) {
                return itemstack;
            }
            if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != IDispenseBehavior.NOOP && idispensebehavior != this) {
                idispensebehavior.dispense(sourceblock, eventStack);
                return itemstack;
            }
            try {
                this.setSuccess(((ItemBlock)item).place(new BlockActionContextDirectional((World)sourceblock.level(), blockposition, enumdirection, itemstack, enumdirection1)).consumesAction());
            }
            catch (Exception exception) {
                LOGGER.error("Error trying to place shulker box at {}", (Object)blockposition, (Object)exception);
            }
        }
        return itemstack;
    }
}

