/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.core.dispenser;

import com.mojang.logging.LogUtils;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.dispenser.DispenseBehaviorBoat;
import net.minecraft.core.dispenser.DispenseBehaviorItem;
import net.minecraft.core.dispenser.DispenseBehaviorMaybe;
import net.minecraft.core.dispenser.DispenseBehaviorShears;
import net.minecraft.core.dispenser.DispenseBehaviorShulkerBox;
import net.minecraft.core.dispenser.SourceBlock;
import net.minecraft.core.particles.Particles;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundCategory;
import net.minecraft.sounds.SoundEffects;
import net.minecraft.tags.TagsBlock;
import net.minecraft.tags.TagsFluid;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityLiving;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.EnumItemSlot;
import net.minecraft.world.entity.EnumMobSpawn;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.ISaddleable;
import net.minecraft.world.entity.animal.armadillo.Armadillo;
import net.minecraft.world.entity.animal.horse.EntityHorseAbstract;
import net.minecraft.world.entity.animal.horse.EntityHorseChestedAbstract;
import net.minecraft.world.entity.decoration.EntityArmorStand;
import net.minecraft.world.entity.item.EntityTNTPrimed;
import net.minecraft.world.entity.player.EntityHuman;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.item.DispensibleContainerItem;
import net.minecraft.world.item.EnumColor;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemArmor;
import net.minecraft.world.item.ItemBoneMeal;
import net.minecraft.world.item.ItemBucket;
import net.minecraft.world.item.ItemMonsterEgg;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.alchemy.PotionContents;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BlockBeehive;
import net.minecraft.world.level.block.BlockCampfire;
import net.minecraft.world.level.block.BlockDispenser;
import net.minecraft.world.level.block.BlockFireAbstract;
import net.minecraft.world.level.block.BlockPumpkinCarved;
import net.minecraft.world.level.block.BlockRespawnAnchor;
import net.minecraft.world.level.block.BlockSapling;
import net.minecraft.world.level.block.BlockShulkerBox;
import net.minecraft.world.level.block.BlockSkull;
import net.minecraft.world.level.block.BlockTNT;
import net.minecraft.world.level.block.BlockWitherSkull;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.CandleCakeBlock;
import net.minecraft.world.level.block.IFluidContainer;
import net.minecraft.world.level.block.IFluidSource;
import net.minecraft.world.level.block.entity.TileEntity;
import net.minecraft.world.level.block.entity.TileEntityBeehive;
import net.minecraft.world.level.block.entity.TileEntitySkull;
import net.minecraft.world.level.block.state.IBlockData;
import net.minecraft.world.level.block.state.properties.BlockProperties;
import net.minecraft.world.level.block.state.properties.RotationSegment;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.AxisAlignedBB;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.TreeType;
import org.bukkit.World;
import org.bukkit.block.BlockState;
import org.bukkit.craftbukkit.v1_21_R1.block.CraftBlock;
import org.bukkit.craftbukkit.v1_21_R1.entity.CraftLivingEntity;
import org.bukkit.craftbukkit.v1_21_R1.event.CraftEventFactory;
import org.bukkit.craftbukkit.v1_21_R1.inventory.CraftItemStack;
import org.bukkit.craftbukkit.v1_21_R1.util.CraftLocation;
import org.bukkit.craftbukkit.v1_21_R1.util.DummyGeneratorAccess;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.event.block.BlockDispenseArmorEvent;
import org.bukkit.event.block.BlockDispenseEvent;
import org.bukkit.event.block.BlockFertilizeEvent;
import org.bukkit.event.block.TNTPrimeEvent;
import org.bukkit.event.world.StructureGrowEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;
import org.slf4j.Logger;

public interface IDispenseBehavior {
    public static final Logger LOGGER = LogUtils.getLogger();
    public static final IDispenseBehavior NOOP = (sourceblock, itemstack) -> itemstack;

    public net.minecraft.world.item.ItemStack dispense(SourceBlock var1, net.minecraft.world.item.ItemStack var2);

    public static void bootStrap() {
        BlockDispenser.registerProjectileBehavior(Items.ARROW);
        BlockDispenser.registerProjectileBehavior(Items.TIPPED_ARROW);
        BlockDispenser.registerProjectileBehavior(Items.SPECTRAL_ARROW);
        BlockDispenser.registerProjectileBehavior(Items.EGG);
        BlockDispenser.registerProjectileBehavior(Items.SNOWBALL);
        BlockDispenser.registerProjectileBehavior(Items.EXPERIENCE_BOTTLE);
        BlockDispenser.registerProjectileBehavior(Items.SPLASH_POTION);
        BlockDispenser.registerProjectileBehavior(Items.LINGERING_POTION);
        BlockDispenser.registerProjectileBehavior(Items.FIREWORK_ROCKET);
        BlockDispenser.registerProjectileBehavior(Items.FIRE_CHARGE);
        BlockDispenser.registerProjectileBehavior(Items.WIND_CHARGE);
        DispenseBehaviorItem dispensebehavioritem = new DispenseBehaviorItem(){

            @Override
            public net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                EnumDirection enumdirection = sourceblock.state().getValue(BlockDispenser.FACING);
                EntityTypes<?> entitytypes = ((ItemMonsterEgg)itemstack.getItem()).getType(itemstack);
                WorldServer worldserver = sourceblock.level();
                net.minecraft.world.item.ItemStack itemstack1 = itemstack.split(1);
                CraftBlock block = CraftBlock.at(worldserver, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    itemstack.grow(1);
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem)) {
                    itemstack.grow(1);
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get(eventStack.getItem());
                    if (idispensebehavior != NOOP && idispensebehavior != this) {
                        idispensebehavior.dispense(sourceblock, eventStack);
                        return itemstack;
                    }
                }
                try {
                    entitytypes.spawn(sourceblock.level(), itemstack, (EntityHuman)null, sourceblock.pos().relative(enumdirection), EnumMobSpawn.DISPENSER, enumdirection != EnumDirection.UP, false);
                }
                catch (Exception exception) {
                    LOGGER.error("Error while dispensing spawn egg from dispenser at {}", (Object)sourceblock.pos(), (Object)exception);
                    return net.minecraft.world.item.ItemStack.EMPTY;
                }
                sourceblock.level().gameEvent((Entity)null, GameEvent.ENTITY_PLACE, sourceblock.pos());
                return itemstack;
            }
        };
        for (ItemMonsterEgg itemmonsteregg : ItemMonsterEgg.eggs()) {
            BlockDispenser.registerBehavior(itemmonsteregg, dispensebehavioritem);
        }
        BlockDispenser.registerBehavior(Items.ARMOR_STAND, new DispenseBehaviorItem(){

            @Override
            public net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                Consumer<EntityArmorStand> consumer;
                EntityArmorStand entityarmorstand2;
                EnumDirection enumdirection = sourceblock.state().getValue(BlockDispenser.FACING);
                BlockPosition blockposition = sourceblock.pos().relative(enumdirection);
                WorldServer worldserver = sourceblock.level();
                net.minecraft.world.item.ItemStack itemstack1 = itemstack.split(1);
                CraftBlock block = CraftBlock.at(worldserver, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    itemstack.grow(1);
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem)) {
                    itemstack.grow(1);
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get(eventStack.getItem());
                    if (idispensebehavior != NOOP && idispensebehavior != this) {
                        idispensebehavior.dispense(sourceblock, eventStack);
                        return itemstack;
                    }
                }
                if ((entityarmorstand2 = EntityTypes.ARMOR_STAND.spawn(worldserver, consumer = EntityTypes.appendDefaultStackConfig(entityarmorstand -> entityarmorstand.setYRot(enumdirection.toYRot()), worldserver, itemstack, null), blockposition, EnumMobSpawn.DISPENSER, false, false)) != null) {
                    // empty if block
                }
                return itemstack;
            }
        });
        BlockDispenser.registerBehavior(Items.SADDLE, new DispenseBehaviorMaybe(){

            @Override
            public net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                BlockPosition blockposition = sourceblock.pos().relative(sourceblock.state().getValue(BlockDispenser.FACING));
                List<EntityLiving> list = sourceblock.level().getEntitiesOfClass(EntityLiving.class, new AxisAlignedBB(blockposition), entityliving -> {
                    if (!(entityliving instanceof ISaddleable)) {
                        return false;
                    }
                    ISaddleable isaddleable = (ISaddleable)((Object)entityliving);
                    return !isaddleable.isSaddled() && isaddleable.isSaddleable();
                });
                if (!list.isEmpty()) {
                    net.minecraft.world.item.ItemStack itemstack1 = itemstack.split(1);
                    WorldServer world = sourceblock.level();
                    CraftBlock block = CraftBlock.at(world, sourceblock.pos());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                    BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)list.get(0).getBukkitEntity()));
                    if (!BlockDispenser.eventFired) {
                        world.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        itemstack.grow(1);
                        return itemstack;
                    }
                    if (!event.getItem().equals((Object)craftItem)) {
                        itemstack.grow(1);
                        net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                        IDispenseBehavior idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get(eventStack.getItem());
                        if (idispensebehavior != NOOP && idispensebehavior != ItemArmor.DISPENSE_ITEM_BEHAVIOR) {
                            idispensebehavior.dispense(sourceblock, eventStack);
                            return itemstack;
                        }
                    }
                    ((ISaddleable)((Object)list.get(0))).equipSaddle(itemstack1, SoundCategory.BLOCKS);
                    this.setSuccess(true);
                    return itemstack;
                }
                return super.execute(sourceblock, itemstack);
            }
        });
        DispenseBehaviorMaybe dispensebehaviormaybe = new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                EntityHorseAbstract entityhorseabstract2;
                BlockPosition blockposition = sourceblock.pos().relative(sourceblock.state().getValue(BlockDispenser.FACING));
                List<EntityHorseAbstract> list = sourceblock.level().getEntitiesOfClass(EntityHorseAbstract.class, new AxisAlignedBB(blockposition), entityhorseabstract -> entityhorseabstract.isAlive() && entityhorseabstract.canUseSlot(EnumItemSlot.BODY));
                Iterator<EntityHorseAbstract> iterator1 = list.iterator();
                do {
                    if (iterator1.hasNext()) continue;
                    return super.execute(sourceblock, itemstack);
                } while (!(entityhorseabstract2 = iterator1.next()).isBodyArmorItem(itemstack) || entityhorseabstract2.isWearingBodyArmor() || !entityhorseabstract2.isTamed());
                net.minecraft.world.item.ItemStack itemstack1 = itemstack.split(1);
                WorldServer world = sourceblock.level();
                CraftBlock block = CraftBlock.at(world, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)entityhorseabstract2.getBukkitEntity()));
                if (!BlockDispenser.eventFired) {
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    itemstack.grow(1);
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem)) {
                    itemstack.grow(1);
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get(eventStack.getItem());
                    if (idispensebehavior != NOOP && idispensebehavior != ItemArmor.DISPENSE_ITEM_BEHAVIOR) {
                        idispensebehavior.dispense(sourceblock, eventStack);
                        return itemstack;
                    }
                }
                entityhorseabstract2.setBodyArmorItem(CraftItemStack.asNMSCopy(event.getItem()));
                this.setSuccess(true);
                return itemstack;
            }
        };
        BlockDispenser.registerBehavior(Items.LEATHER_HORSE_ARMOR, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.IRON_HORSE_ARMOR, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.GOLDEN_HORSE_ARMOR, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.DIAMOND_HORSE_ARMOR, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.WHITE_CARPET, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.ORANGE_CARPET, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.CYAN_CARPET, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.BLUE_CARPET, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.BROWN_CARPET, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.BLACK_CARPET, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.GRAY_CARPET, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.GREEN_CARPET, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.LIGHT_BLUE_CARPET, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.LIGHT_GRAY_CARPET, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.LIME_CARPET, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.MAGENTA_CARPET, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.PINK_CARPET, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.PURPLE_CARPET, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.RED_CARPET, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.YELLOW_CARPET, dispensebehaviormaybe);
        BlockDispenser.registerBehavior(Items.CHEST, new DispenseBehaviorMaybe(){

            @Override
            public net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                EntityHorseChestedAbstract entityhorsechestedabstract2;
                BlockPosition blockposition = sourceblock.pos().relative(sourceblock.state().getValue(BlockDispenser.FACING));
                List<EntityHorseChestedAbstract> list = sourceblock.level().getEntitiesOfClass(EntityHorseChestedAbstract.class, new AxisAlignedBB(blockposition), entityhorsechestedabstract -> entityhorsechestedabstract.isAlive() && !entityhorsechestedabstract.hasChest());
                Iterator<EntityHorseChestedAbstract> iterator1 = list.iterator();
                do {
                    if (iterator1.hasNext()) continue;
                    return super.execute(sourceblock, itemstack);
                } while (!(entityhorsechestedabstract2 = iterator1.next()).isTamed());
                net.minecraft.world.item.ItemStack itemstack1 = itemstack.split(1);
                WorldServer world = sourceblock.level();
                CraftBlock block = CraftBlock.at(world, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)entityhorsechestedabstract2.getBukkitEntity()));
                if (!BlockDispenser.eventFired) {
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != ItemArmor.DISPENSE_ITEM_BEHAVIOR) {
                    idispensebehavior.dispense(sourceblock, eventStack);
                    return itemstack;
                }
                entityhorsechestedabstract2.getSlot(499).set(CraftItemStack.asNMSCopy(event.getItem()));
                this.setSuccess(true);
                return itemstack;
            }
        });
        BlockDispenser.registerBehavior(Items.OAK_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.OAK));
        BlockDispenser.registerBehavior(Items.SPRUCE_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.SPRUCE));
        BlockDispenser.registerBehavior(Items.BIRCH_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.BIRCH));
        BlockDispenser.registerBehavior(Items.JUNGLE_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.JUNGLE));
        BlockDispenser.registerBehavior(Items.DARK_OAK_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.DARK_OAK));
        BlockDispenser.registerBehavior(Items.ACACIA_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.ACACIA));
        BlockDispenser.registerBehavior(Items.CHERRY_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.CHERRY));
        BlockDispenser.registerBehavior(Items.MANGROVE_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.MANGROVE));
        BlockDispenser.registerBehavior(Items.BAMBOO_RAFT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.BAMBOO));
        BlockDispenser.registerBehavior(Items.OAK_CHEST_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.OAK, true));
        BlockDispenser.registerBehavior(Items.SPRUCE_CHEST_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.SPRUCE, true));
        BlockDispenser.registerBehavior(Items.BIRCH_CHEST_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.BIRCH, true));
        BlockDispenser.registerBehavior(Items.JUNGLE_CHEST_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.JUNGLE, true));
        BlockDispenser.registerBehavior(Items.DARK_OAK_CHEST_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.DARK_OAK, true));
        BlockDispenser.registerBehavior(Items.ACACIA_CHEST_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.ACACIA, true));
        BlockDispenser.registerBehavior(Items.CHERRY_CHEST_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.CHERRY, true));
        BlockDispenser.registerBehavior(Items.MANGROVE_CHEST_BOAT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.MANGROVE, true));
        BlockDispenser.registerBehavior(Items.BAMBOO_CHEST_RAFT, new DispenseBehaviorBoat(EntityBoat.EnumBoatType.BAMBOO, true));
        DispenseBehaviorItem dispensebehavioritem1 = new DispenseBehaviorItem(){
            private final DispenseBehaviorItem defaultDispenseItemBehavior = new DispenseBehaviorItem();

            @Override
            public net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                DispensibleContainerItem dispensiblecontaineritem = (DispensibleContainerItem)((Object)itemstack.getItem());
                BlockPosition blockposition = sourceblock.pos().relative(sourceblock.state().getValue(BlockDispenser.FACING));
                WorldServer worldserver = sourceblock.level();
                int x2 = blockposition.getX();
                int y2 = blockposition.getY();
                int z2 = blockposition.getZ();
                IBlockData iblockdata = worldserver.getBlockState(blockposition);
                if (iblockdata.isAir() || iblockdata.canBeReplaced() || dispensiblecontaineritem instanceof ItemBucket && iblockdata.getBlock() instanceof IFluidContainer && ((IFluidContainer)((Object)iblockdata.getBlock())).canPlaceLiquid(null, worldserver, blockposition, iblockdata, ((ItemBucket)dispensiblecontaineritem).content)) {
                    net.minecraft.world.item.ItemStack eventStack;
                    IDispenseBehavior idispensebehavior;
                    CraftBlock block = CraftBlock.at(worldserver, sourceblock.pos());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
                    BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(x2, y2, z2));
                    if (!BlockDispenser.eventFired) {
                        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return itemstack;
                    }
                    if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                        idispensebehavior.dispense(sourceblock, eventStack);
                        return itemstack;
                    }
                    dispensiblecontaineritem = (DispensibleContainerItem)((Object)CraftItemStack.asNMSCopy(event.getItem()).getItem());
                }
                if (dispensiblecontaineritem.emptyContents(null, worldserver, blockposition, null)) {
                    dispensiblecontaineritem.checkExtraContent(null, worldserver, itemstack, blockposition);
                    return this.consumeWithRemainder(sourceblock, itemstack, new net.minecraft.world.item.ItemStack(Items.BUCKET));
                }
                return this.defaultDispenseItemBehavior.dispense(sourceblock, itemstack);
            }
        };
        BlockDispenser.registerBehavior(Items.LAVA_BUCKET, dispensebehavioritem1);
        BlockDispenser.registerBehavior(Items.WATER_BUCKET, dispensebehavioritem1);
        BlockDispenser.registerBehavior(Items.POWDER_SNOW_BUCKET, dispensebehavioritem1);
        BlockDispenser.registerBehavior(Items.SALMON_BUCKET, dispensebehavioritem1);
        BlockDispenser.registerBehavior(Items.COD_BUCKET, dispensebehavioritem1);
        BlockDispenser.registerBehavior(Items.PUFFERFISH_BUCKET, dispensebehavioritem1);
        BlockDispenser.registerBehavior(Items.TROPICAL_FISH_BUCKET, dispensebehavioritem1);
        BlockDispenser.registerBehavior(Items.AXOLOTL_BUCKET, dispensebehavioritem1);
        BlockDispenser.registerBehavior(Items.TADPOLE_BUCKET, dispensebehavioritem1);
        BlockDispenser.registerBehavior(Items.BUCKET, new DispenseBehaviorItem(){

            @Override
            public net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                BlockPosition blockposition;
                WorldServer worldserver = sourceblock.level();
                IBlockData iblockdata = worldserver.getBlockState(blockposition = sourceblock.pos().relative(sourceblock.state().getValue(BlockDispenser.FACING)));
                Block block = iblockdata.getBlock();
                if (block instanceof IFluidSource) {
                    net.minecraft.world.item.ItemStack eventStack;
                    IDispenseBehavior idispensebehavior;
                    IFluidSource ifluidsource = (IFluidSource)((Object)block);
                    net.minecraft.world.item.ItemStack itemstack1 = ifluidsource.pickupBlock(null, DummyGeneratorAccess.INSTANCE, blockposition, iblockdata);
                    if (itemstack1.isEmpty()) {
                        return super.execute(sourceblock, itemstack);
                    }
                    worldserver.gameEvent((Entity)null, GameEvent.FLUID_PICKUP, blockposition);
                    Item item = itemstack1.getItem();
                    CraftBlock bukkitBlock = CraftBlock.at(worldserver, sourceblock.pos());
                    CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
                    BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                    if (!BlockDispenser.eventFired) {
                        worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                    }
                    if (event.isCancelled()) {
                        return itemstack;
                    }
                    if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                        idispensebehavior.dispense(sourceblock, eventStack);
                        return itemstack;
                    }
                    itemstack1 = ifluidsource.pickupBlock(null, worldserver, blockposition, iblockdata);
                    return this.consumeWithRemainder(sourceblock, itemstack, new net.minecraft.world.item.ItemStack(item));
                }
                return super.execute(sourceblock, itemstack);
            }
        });
        BlockDispenser.registerBehavior(Items.FLINT_AND_STEEL, new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                WorldServer worldserver = sourceblock.level();
                CraftBlock bukkitBlock = CraftBlock.at(worldserver, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                    idispensebehavior.dispense(sourceblock, eventStack);
                    return itemstack;
                }
                this.setSuccess(true);
                EnumDirection enumdirection = sourceblock.state().getValue(BlockDispenser.FACING);
                BlockPosition blockposition = sourceblock.pos().relative(enumdirection);
                IBlockData iblockdata = worldserver.getBlockState(blockposition);
                if (BlockFireAbstract.canBePlacedAt(worldserver, blockposition, enumdirection)) {
                    if (!CraftEventFactory.callBlockIgniteEvent((net.minecraft.world.level.World)worldserver, blockposition, sourceblock.pos()).isCancelled()) {
                        worldserver.setBlockAndUpdate(blockposition, BlockFireAbstract.getState(worldserver, blockposition));
                        worldserver.gameEvent((Entity)null, GameEvent.BLOCK_PLACE, blockposition);
                    }
                } else if (!(BlockCampfire.canLight(iblockdata) || CandleBlock.canLight(iblockdata) || CandleCakeBlock.canLight(iblockdata))) {
                    if (iblockdata.getBlock() instanceof BlockTNT && CraftEventFactory.callTNTPrimeEvent(worldserver, blockposition, TNTPrimeEvent.PrimeCause.DISPENSER, null, sourceblock.pos())) {
                        BlockTNT.explode(worldserver, blockposition);
                        worldserver.removeBlock(blockposition, false);
                    } else {
                        this.setSuccess(false);
                    }
                } else {
                    worldserver.setBlockAndUpdate(blockposition, (IBlockData)iblockdata.setValue(BlockProperties.LIT, true));
                    worldserver.gameEvent((Entity)null, GameEvent.BLOCK_CHANGE, blockposition);
                }
                if (this.isSuccess()) {
                    itemstack.hurtAndBreak(1, worldserver, null, item -> {});
                }
                return itemstack;
            }
        });
        BlockDispenser.registerBehavior(Items.BONE_MEAL, new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                this.setSuccess(true);
                WorldServer worldserver = sourceblock.level();
                BlockPosition blockposition = sourceblock.pos().relative(sourceblock.state().getValue(BlockDispenser.FACING));
                CraftBlock block = CraftBlock.at(worldserver, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector(0, 0, 0));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                    idispensebehavior.dispense(sourceblock, eventStack);
                    return itemstack;
                }
                worldserver.captureTreeGeneration = true;
                if (!ItemBoneMeal.growCrop(itemstack, worldserver, blockposition) && !ItemBoneMeal.growWaterPlant(itemstack, worldserver, blockposition, null)) {
                    this.setSuccess(false);
                } else if (!worldserver.isClientSide) {
                    worldserver.levelEvent(1505, blockposition, 15);
                }
                worldserver.captureTreeGeneration = false;
                if (worldserver.capturedBlockStates.size() > 0) {
                    TreeType treeType = BlockSapling.treeType;
                    BlockSapling.treeType = null;
                    Location location = CraftLocation.toBukkit(blockposition, (World)worldserver.getWorld());
                    ArrayList blocks = new ArrayList(worldserver.capturedBlockStates.values());
                    worldserver.capturedBlockStates.clear();
                    StructureGrowEvent structureEvent = null;
                    if (treeType != null) {
                        structureEvent = new StructureGrowEvent(location, treeType, false, null, blocks);
                        Bukkit.getPluginManager().callEvent((Event)structureEvent);
                    }
                    BlockFertilizeEvent fertilizeEvent = new BlockFertilizeEvent(location.getBlock(), null, blocks);
                    fertilizeEvent.setCancelled(structureEvent != null && structureEvent.isCancelled());
                    Bukkit.getPluginManager().callEvent((Event)fertilizeEvent);
                    if (!fertilizeEvent.isCancelled()) {
                        for (BlockState blockstate : blocks) {
                            blockstate.update(true);
                        }
                    }
                }
                return itemstack;
            }
        });
        BlockDispenser.registerBehavior(Blocks.TNT, new DispenseBehaviorItem(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                WorldServer worldserver = sourceblock.level();
                BlockPosition blockposition = sourceblock.pos().relative(sourceblock.state().getValue(BlockDispenser.FACING));
                net.minecraft.world.item.ItemStack itemstack1 = itemstack.split(1);
                CraftBlock block = CraftBlock.at(worldserver, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), new Vector((double)blockposition.getX() + 0.5, (double)blockposition.getY(), (double)blockposition.getZ() + 0.5));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    itemstack.grow(1);
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem)) {
                    itemstack.grow(1);
                    net.minecraft.world.item.ItemStack eventStack = CraftItemStack.asNMSCopy(event.getItem());
                    IDispenseBehavior idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get(eventStack.getItem());
                    if (idispensebehavior != NOOP && idispensebehavior != this) {
                        idispensebehavior.dispense(sourceblock, eventStack);
                        return itemstack;
                    }
                }
                EntityTNTPrimed entitytntprimed = new EntityTNTPrimed(worldserver, event.getVelocity().getX(), event.getVelocity().getY(), event.getVelocity().getZ(), null);
                worldserver.addFreshEntity(entitytntprimed);
                worldserver.playSound((EntityHuman)null, entitytntprimed.getX(), entitytntprimed.getY(), entitytntprimed.getZ(), SoundEffects.TNT_PRIMED, SoundCategory.BLOCKS, 1.0f, 1.0f);
                worldserver.gameEvent((Entity)null, GameEvent.ENTITY_PLACE, blockposition);
                return itemstack;
            }
        });
        DispenseBehaviorMaybe dispensebehaviormaybe1 = new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                this.setSuccess(ItemArmor.dispenseArmor(sourceblock, itemstack));
                return itemstack;
            }
        };
        BlockDispenser.registerBehavior(Items.CREEPER_HEAD, dispensebehaviormaybe1);
        BlockDispenser.registerBehavior(Items.ZOMBIE_HEAD, dispensebehaviormaybe1);
        BlockDispenser.registerBehavior(Items.DRAGON_HEAD, dispensebehaviormaybe1);
        BlockDispenser.registerBehavior(Items.SKELETON_SKULL, dispensebehaviormaybe1);
        BlockDispenser.registerBehavior(Items.PIGLIN_HEAD, dispensebehaviormaybe1);
        BlockDispenser.registerBehavior(Items.PLAYER_HEAD, dispensebehaviormaybe1);
        BlockDispenser.registerBehavior(Items.WITHER_SKELETON_SKULL, new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                WorldServer worldserver = sourceblock.level();
                EnumDirection enumdirection = sourceblock.state().getValue(BlockDispenser.FACING);
                BlockPosition blockposition = sourceblock.pos().relative(enumdirection);
                CraftBlock bukkitBlock = CraftBlock.at(worldserver, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                    idispensebehavior.dispense(sourceblock, eventStack);
                    return itemstack;
                }
                if (worldserver.isEmptyBlock(blockposition) && BlockWitherSkull.canSpawnMob(worldserver, blockposition, itemstack)) {
                    worldserver.setBlock(blockposition, (IBlockData)Blocks.WITHER_SKELETON_SKULL.defaultBlockState().setValue(BlockSkull.ROTATION, RotationSegment.convertToSegment(enumdirection)), 3);
                    worldserver.gameEvent((Entity)null, GameEvent.BLOCK_PLACE, blockposition);
                    TileEntity tileentity = worldserver.getBlockEntity(blockposition);
                    if (tileentity instanceof TileEntitySkull) {
                        BlockWitherSkull.checkSpawn(worldserver, blockposition, (TileEntitySkull)tileentity);
                    }
                    itemstack.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(ItemArmor.dispenseArmor(sourceblock, itemstack));
                }
                return itemstack;
            }
        });
        BlockDispenser.registerBehavior(Blocks.CARVED_PUMPKIN, new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                WorldServer worldserver = sourceblock.level();
                BlockPosition blockposition = sourceblock.pos().relative(sourceblock.state().getValue(BlockDispenser.FACING));
                BlockPumpkinCarved blockpumpkincarved = (BlockPumpkinCarved)Blocks.CARVED_PUMPKIN;
                CraftBlock bukkitBlock = CraftBlock.at(worldserver, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                    idispensebehavior.dispense(sourceblock, eventStack);
                    return itemstack;
                }
                if (worldserver.isEmptyBlock(blockposition) && blockpumpkincarved.canSpawnGolem(worldserver, blockposition)) {
                    if (!worldserver.isClientSide) {
                        worldserver.setBlock(blockposition, blockpumpkincarved.defaultBlockState(), 3);
                        worldserver.gameEvent((Entity)null, GameEvent.BLOCK_PLACE, blockposition);
                    }
                    itemstack.shrink(1);
                    this.setSuccess(true);
                } else {
                    this.setSuccess(ItemArmor.dispenseArmor(sourceblock, itemstack));
                }
                return itemstack;
            }
        });
        BlockDispenser.registerBehavior(Blocks.SHULKER_BOX.asItem(), new DispenseBehaviorShulkerBox());
        for (EnumColor enumcolor : EnumColor.values()) {
            BlockDispenser.registerBehavior(BlockShulkerBox.getBlockByColor(enumcolor).asItem(), new DispenseBehaviorShulkerBox());
        }
        BlockDispenser.registerBehavior(Items.GLASS_BOTTLE.asItem(), new DispenseBehaviorMaybe(){

            private net.minecraft.world.item.ItemStack takeLiquid(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack, net.minecraft.world.item.ItemStack itemstack1) {
                sourceblock.level().gameEvent((Entity)null, GameEvent.FLUID_PICKUP, sourceblock.pos());
                return this.consumeWithRemainder(sourceblock, itemstack, itemstack1);
            }

            @Override
            public net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                this.setSuccess(false);
                WorldServer worldserver = sourceblock.level();
                BlockPosition blockposition = sourceblock.pos().relative(sourceblock.state().getValue(BlockDispenser.FACING));
                IBlockData iblockdata = worldserver.getBlockState(blockposition);
                CraftBlock bukkitBlock = CraftBlock.at(worldserver, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack);
                BlockDispenseEvent event = new BlockDispenseEvent((org.bukkit.block.Block)bukkitBlock, (ItemStack)craftItem.clone(), new Vector(blockposition.getX(), blockposition.getY(), blockposition.getZ()));
                if (!BlockDispenser.eventFired) {
                    worldserver.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != this) {
                    idispensebehavior.dispense(sourceblock, eventStack);
                    return itemstack;
                }
                if (iblockdata.is(TagsBlock.BEEHIVES, blockbase_blockdata -> blockbase_blockdata.hasProperty(BlockBeehive.HONEY_LEVEL) && blockbase_blockdata.getBlock() instanceof BlockBeehive) && iblockdata.getValue(BlockBeehive.HONEY_LEVEL) >= 5) {
                    ((BlockBeehive)iblockdata.getBlock()).releaseBeesAndResetHoneyLevel(worldserver, iblockdata, blockposition, null, TileEntityBeehive.ReleaseStatus.BEE_RELEASED);
                    this.setSuccess(true);
                    return this.takeLiquid(sourceblock, itemstack, new net.minecraft.world.item.ItemStack(Items.HONEY_BOTTLE));
                }
                if (worldserver.getFluidState(blockposition).is(TagsFluid.WATER)) {
                    this.setSuccess(true);
                    return this.takeLiquid(sourceblock, itemstack, PotionContents.createItemStack(Items.POTION, Potions.WATER));
                }
                return super.execute(sourceblock, itemstack);
            }
        });
        BlockDispenser.registerBehavior(Items.GLOWSTONE, new DispenseBehaviorMaybe(){

            @Override
            public net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                EnumDirection enumdirection = sourceblock.state().getValue(BlockDispenser.FACING);
                BlockPosition blockposition = sourceblock.pos().relative(enumdirection);
                WorldServer worldserver = sourceblock.level();
                IBlockData iblockdata = worldserver.getBlockState(blockposition);
                this.setSuccess(true);
                if (iblockdata.is(Blocks.RESPAWN_ANCHOR)) {
                    if (iblockdata.getValue(BlockRespawnAnchor.CHARGE) != 4) {
                        BlockRespawnAnchor.charge(null, worldserver, blockposition, iblockdata);
                        itemstack.shrink(1);
                    } else {
                        this.setSuccess(false);
                    }
                    return itemstack;
                }
                return super.execute(sourceblock, itemstack);
            }
        });
        BlockDispenser.registerBehavior(Items.SHEARS.asItem(), new DispenseBehaviorShears());
        BlockDispenser.registerBehavior(Items.BRUSH.asItem(), new DispenseBehaviorMaybe(){

            @Override
            protected net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                Armadillo armadillo;
                net.minecraft.world.item.ItemStack eventStack;
                IDispenseBehavior idispensebehavior;
                BlockPosition blockposition;
                WorldServer worldserver = sourceblock.level();
                List<Entity> list = worldserver.getEntitiesOfClass(Armadillo.class, new AxisAlignedBB(blockposition = sourceblock.pos().relative(sourceblock.state().getValue(BlockDispenser.FACING))), IEntitySelector.NO_SPECTATORS);
                if (list.isEmpty()) {
                    this.setSuccess(false);
                    return itemstack;
                }
                net.minecraft.world.item.ItemStack itemstack1 = itemstack;
                WorldServer world = sourceblock.level();
                CraftBlock block = CraftBlock.at(world, sourceblock.pos());
                CraftItemStack craftItem = CraftItemStack.asCraftMirror(itemstack1);
                BlockDispenseArmorEvent event = new BlockDispenseArmorEvent((org.bukkit.block.Block)block, (ItemStack)craftItem.clone(), (LivingEntity)((CraftLivingEntity)((Armadillo)list.get(0)).getBukkitEntity()));
                if (!BlockDispenser.eventFired) {
                    world.getCraftServer().getPluginManager().callEvent((Event)event);
                }
                if (event.isCancelled()) {
                    return itemstack;
                }
                if (!event.getItem().equals((Object)craftItem) && (idispensebehavior = BlockDispenser.DISPENSER_REGISTRY.get((eventStack = CraftItemStack.asNMSCopy(event.getItem())).getItem())) != NOOP && idispensebehavior != ItemArmor.DISPENSE_ITEM_BEHAVIOR) {
                    idispensebehavior.dispense(sourceblock, eventStack);
                    return itemstack;
                }
                Iterator<Entity> iterator1 = list.iterator();
                do {
                    if (iterator1.hasNext()) continue;
                    this.setSuccess(false);
                    return itemstack;
                } while (!(armadillo = (Armadillo)iterator1.next()).brushOffScute());
                itemstack.hurtAndBreak(16, worldserver, null, item -> {});
                return itemstack;
            }
        });
        BlockDispenser.registerBehavior(Items.HONEYCOMB, new DispenseBehaviorMaybe(){

            @Override
            public net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                BlockPosition blockposition = sourceblock.pos().relative(sourceblock.state().getValue(BlockDispenser.FACING));
                WorldServer worldserver = sourceblock.level();
                IBlockData iblockdata = worldserver.getBlockState(blockposition);
                Optional<IBlockData> optional = HoneycombItem.getWaxed(iblockdata);
                if (optional.isPresent()) {
                    worldserver.setBlockAndUpdate(blockposition, optional.get());
                    worldserver.levelEvent(3003, blockposition, 0);
                    itemstack.shrink(1);
                    this.setSuccess(true);
                    return itemstack;
                }
                return super.execute(sourceblock, itemstack);
            }
        });
        BlockDispenser.registerBehavior(Items.POTION, new DispenseBehaviorItem(){
            private final DispenseBehaviorItem defaultDispenseItemBehavior = new DispenseBehaviorItem();

            @Override
            public net.minecraft.world.item.ItemStack execute(SourceBlock sourceblock, net.minecraft.world.item.ItemStack itemstack) {
                PotionContents potioncontents = itemstack.getOrDefault(DataComponents.POTION_CONTENTS, PotionContents.EMPTY);
                if (!potioncontents.is(Potions.WATER)) {
                    return this.defaultDispenseItemBehavior.dispense(sourceblock, itemstack);
                }
                WorldServer worldserver = sourceblock.level();
                BlockPosition blockposition = sourceblock.pos();
                BlockPosition blockposition1 = sourceblock.pos().relative(sourceblock.state().getValue(BlockDispenser.FACING));
                if (!worldserver.getBlockState(blockposition1).is(TagsBlock.CONVERTABLE_TO_MUD)) {
                    return this.defaultDispenseItemBehavior.dispense(sourceblock, itemstack);
                }
                if (!worldserver.isClientSide) {
                    for (int k2 = 0; k2 < 5; ++k2) {
                        worldserver.sendParticles(Particles.SPLASH, (double)blockposition.getX() + worldserver.random.nextDouble(), blockposition.getY() + 1, (double)blockposition.getZ() + worldserver.random.nextDouble(), 1, 0.0, 0.0, 0.0, 1.0);
                    }
                }
                worldserver.playSound((EntityHuman)null, blockposition, SoundEffects.BOTTLE_EMPTY, SoundCategory.BLOCKS, 1.0f, 1.0f);
                worldserver.gameEvent((Entity)null, GameEvent.FLUID_PLACE, blockposition);
                worldserver.setBlockAndUpdate(blockposition1, Blocks.MUD.defaultBlockState());
                return this.consumeWithRemainder(sourceblock, itemstack, new net.minecraft.world.item.ItemStack(Items.GLASS_BOTTLE));
            }
        });
    }
}

