/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.google.common.collect.Lists;
import java.util.Iterator;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.gametest.framework.GameTestHarnessAssertion;
import net.minecraft.gametest.framework.GameTestHarnessEvent;
import net.minecraft.gametest.framework.GameTestHarnessInfo;

public class GameTestHarnessSequence {
    final GameTestHarnessInfo parent;
    private final List<GameTestHarnessEvent> events = Lists.newArrayList();
    private long lastTick;

    GameTestHarnessSequence(GameTestHarnessInfo var0) {
        this.parent = var0;
        this.lastTick = var0.getTick();
    }

    public GameTestHarnessSequence thenWaitUntil(Runnable var0) {
        this.events.add(GameTestHarnessEvent.create(var0));
        return this;
    }

    public GameTestHarnessSequence thenWaitUntil(long var0, Runnable var2) {
        this.events.add(GameTestHarnessEvent.create(var0, var2));
        return this;
    }

    public GameTestHarnessSequence thenIdle(int var0) {
        return this.thenExecuteAfter(var0, () -> {});
    }

    public GameTestHarnessSequence thenExecute(Runnable var0) {
        this.events.add(GameTestHarnessEvent.create(() -> this.executeWithoutFail(var0)));
        return this;
    }

    public GameTestHarnessSequence thenExecuteAfter(int var0, Runnable var1) {
        this.events.add(GameTestHarnessEvent.create(() -> {
            if (this.parent.getTick() < this.lastTick + (long)var0) {
                throw new GameTestHarnessAssertion("Test timed out before sequence completed");
            }
            this.executeWithoutFail(var1);
        }));
        return this;
    }

    public GameTestHarnessSequence thenExecuteFor(int var0, Runnable var1) {
        this.events.add(GameTestHarnessEvent.create(() -> {
            if (this.parent.getTick() < this.lastTick + (long)var0) {
                this.executeWithoutFail(var1);
                throw new GameTestHarnessAssertion("Test timed out before sequence completed");
            }
        }));
        return this;
    }

    public void thenSucceed() {
        this.events.add(GameTestHarnessEvent.create(this.parent::succeed));
    }

    public void thenFail(Supplier<Exception> var0) {
        this.events.add(GameTestHarnessEvent.create(() -> this.parent.fail((Throwable)var0.get())));
    }

    public a thenTrigger() {
        a var0 = new a();
        this.events.add(GameTestHarnessEvent.create(() -> var0.trigger(this.parent.getTick())));
        return var0;
    }

    public void tickAndContinue(long var0) {
        try {
            this.tick(var0);
        }
        catch (GameTestHarnessAssertion gameTestHarnessAssertion) {
            // empty catch block
        }
    }

    public void tickAndFailIfNotComplete(long var0) {
        try {
            this.tick(var0);
        }
        catch (GameTestHarnessAssertion var2) {
            this.parent.fail(var2);
        }
    }

    private void executeWithoutFail(Runnable var0) {
        try {
            var0.run();
        }
        catch (GameTestHarnessAssertion var1) {
            this.parent.fail(var1);
        }
    }

    private void tick(long var0) {
        Iterator<GameTestHarnessEvent> var2 = this.events.iterator();
        while (var2.hasNext()) {
            GameTestHarnessEvent var3 = var2.next();
            var3.assertion.run();
            var2.remove();
            long var4 = var0 - this.lastTick;
            long var6 = this.lastTick;
            this.lastTick = var0;
            if (var3.expectedDelay == null || var3.expectedDelay == var4) continue;
            this.parent.fail(new GameTestHarnessAssertion("Succeeded in invalid tick: expected " + (var6 + var3.expectedDelay) + ", but current tick is " + var0));
            break;
        }
    }

    public class a {
        private static final long NOT_TRIGGERED = -1L;
        private long triggerTime = -1L;

        void trigger(long var0) {
            if (this.triggerTime != -1L) {
                throw new IllegalStateException("Condition already triggered at " + this.triggerTime);
            }
            this.triggerTime = var0;
        }

        public void assertTriggeredThisTick() {
            long var0 = GameTestHarnessSequence.this.parent.getTick();
            if (this.triggerTime != var0) {
                if (this.triggerTime == -1L) {
                    throw new GameTestHarnessAssertion("Condition not triggered (t=" + var0 + ")");
                }
                throw new GameTestHarnessAssertion("Condition triggered at " + this.triggerTime + ", (t=" + var0 + ")");
            }
        }
    }
}

