/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.gametest.framework;

import com.mojang.brigadier.context.CommandContext;
import java.util.LinkedList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.BlockPosition;
import net.minecraft.gametest.framework.GameTestHarnessRegistry;
import net.minecraft.gametest.framework.GameTestHarnessStructures;
import net.minecraft.gametest.framework.GameTestHarnessTestFunction;
import net.minecraft.gametest.framework.GameTestHarnessTestFunctionArgument;
import net.minecraft.gametest.framework.StructureBlockPosFinder;
import net.minecraft.gametest.framework.TestFunctionFinder;

public class TestFinder<T>
implements StructureBlockPosFinder,
TestFunctionFinder {
    static final TestFunctionFinder NO_FUNCTIONS = Stream::empty;
    static final StructureBlockPosFinder NO_STRUCTURES = Stream::empty;
    private final TestFunctionFinder testFunctionFinder;
    private final StructureBlockPosFinder structureBlockPosFinder;
    private final CommandListenerWrapper source;
    private final Function<TestFinder<T>, T> contextProvider;

    @Override
    public Stream<BlockPosition> findStructureBlockPos() {
        return this.structureBlockPosFinder.findStructureBlockPos();
    }

    TestFinder(CommandListenerWrapper var0, Function<TestFinder<T>, T> var1, TestFunctionFinder var2, StructureBlockPosFinder var3) {
        this.source = var0;
        this.contextProvider = var1;
        this.testFunctionFinder = var2;
        this.structureBlockPosFinder = var3;
    }

    T get() {
        return this.contextProvider.apply(this);
    }

    public CommandListenerWrapper source() {
        return this.source;
    }

    @Override
    public Stream<GameTestHarnessTestFunction> findTestFunctions() {
        return this.testFunctionFinder.findTestFunctions();
    }

    public static class a<T> {
        private final Function<TestFinder<T>, T> contextProvider;
        private final UnaryOperator<Supplier<Stream<GameTestHarnessTestFunction>>> testFunctionFinderWrapper;
        private final UnaryOperator<Supplier<Stream<BlockPosition>>> structureBlockPosFinderWrapper;

        public a(Function<TestFinder<T>, T> var02) {
            this.contextProvider = var02;
            this.testFunctionFinderWrapper = var0 -> var0;
            this.structureBlockPosFinderWrapper = var0 -> var0;
        }

        private a(Function<TestFinder<T>, T> var0, UnaryOperator<Supplier<Stream<GameTestHarnessTestFunction>>> var1, UnaryOperator<Supplier<Stream<BlockPosition>>> var2) {
            this.contextProvider = var0;
            this.testFunctionFinderWrapper = var1;
            this.structureBlockPosFinderWrapper = var2;
        }

        public a<T> createMultipleCopies(int var0) {
            return new a<T>(this.contextProvider, a.createCopies(var0), a.createCopies(var0));
        }

        private static <Q> UnaryOperator<Supplier<Stream<Q>>> createCopies(int var0) {
            return var1 -> {
                LinkedList var2 = new LinkedList();
                List var3 = ((Stream)var1.get()).toList();
                for (int var4 = 0; var4 < var0; ++var4) {
                    var2.addAll(var3);
                }
                return var2::stream;
            };
        }

        private T build(CommandListenerWrapper var0, TestFunctionFinder var1, StructureBlockPosFinder var2) {
            return new TestFinder<T>(var0, this.contextProvider, ((Supplier)((Supplier)this.testFunctionFinderWrapper.apply(var1::findTestFunctions)))::get, ((Supplier)((Supplier)this.structureBlockPosFinderWrapper.apply(var2::findStructureBlockPos)))::get).get();
        }

        public T radius(CommandContext<CommandListenerWrapper> var0, int var1) {
            CommandListenerWrapper var2 = (CommandListenerWrapper)var0.getSource();
            BlockPosition var3 = BlockPosition.containing(var2.getPosition());
            return this.build(var2, NO_FUNCTIONS, () -> GameTestHarnessStructures.findStructureBlocks(var3, var1, var2.getLevel()));
        }

        public T nearest(CommandContext<CommandListenerWrapper> var0) {
            CommandListenerWrapper var1 = (CommandListenerWrapper)var0.getSource();
            BlockPosition var2 = BlockPosition.containing(var1.getPosition());
            return this.build(var1, NO_FUNCTIONS, () -> GameTestHarnessStructures.findNearestStructureBlock(var2, 15, var1.getLevel()).stream());
        }

        public T allNearby(CommandContext<CommandListenerWrapper> var0) {
            CommandListenerWrapper var1 = (CommandListenerWrapper)var0.getSource();
            BlockPosition var2 = BlockPosition.containing(var1.getPosition());
            return this.build(var1, NO_FUNCTIONS, () -> GameTestHarnessStructures.findStructureBlocks(var2, 200, var1.getLevel()));
        }

        public T lookedAt(CommandContext<CommandListenerWrapper> var0) {
            CommandListenerWrapper var1 = (CommandListenerWrapper)var0.getSource();
            return this.build(var1, NO_FUNCTIONS, () -> GameTestHarnessStructures.lookedAtStructureBlockPos(BlockPosition.containing(var1.getPosition()), var1.getPlayer().getCamera(), var1.getLevel()));
        }

        public T allTests(CommandContext<CommandListenerWrapper> var0) {
            return this.build((CommandListenerWrapper)var0.getSource(), () -> GameTestHarnessRegistry.getAllTestFunctions().stream().filter(var0 -> !var0.manualOnly()), NO_STRUCTURES);
        }

        public T allTestsInClass(CommandContext<CommandListenerWrapper> var0, String var1) {
            return this.build((CommandListenerWrapper)var0.getSource(), () -> GameTestHarnessRegistry.getTestFunctionsForClassName(var1).filter(var0 -> !var0.manualOnly()), NO_STRUCTURES);
        }

        public T failedTests(CommandContext<CommandListenerWrapper> var0, boolean var1) {
            return this.build((CommandListenerWrapper)var0.getSource(), () -> GameTestHarnessRegistry.getLastFailedTests().filter(var1 -> !var1 || var1.required()), NO_STRUCTURES);
        }

        public T byArgument(CommandContext<CommandListenerWrapper> var0, String var1) {
            return this.build((CommandListenerWrapper)var0.getSource(), () -> Stream.of(GameTestHarnessTestFunctionArgument.getTestFunction(var0, var1)), NO_STRUCTURES);
        }

        public T locateByName(CommandContext<CommandListenerWrapper> var0, String var1) {
            CommandListenerWrapper var2 = (CommandListenerWrapper)var0.getSource();
            BlockPosition var3 = BlockPosition.containing(var2.getPosition());
            return this.build(var2, NO_FUNCTIONS, () -> GameTestHarnessStructures.findStructureByTestFunction(var3, 1024, var2.getLevel(), var1));
        }

        public T failedTests(CommandContext<CommandListenerWrapper> var0) {
            return this.failedTests(var0, false);
        }
    }
}

