/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import io.netty.buffer.ByteBufInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UTFDataFormatException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.annotation.Nullable;
import net.minecraft.CrashReport;
import net.minecraft.CrashReportSystemDetails;
import net.minecraft.SystemUtils;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.NBTTagTypes;
import net.minecraft.nbt.ReportedNbtException;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.util.DelegateDataOutput;
import net.minecraft.util.FastBufferedInputStream;
import org.spigotmc.LimitStream;

public class NBTCompressedStreamTools {
    private static final OpenOption[] SYNC_OUTPUT_OPTIONS = new OpenOption[]{StandardOpenOption.SYNC, StandardOpenOption.WRITE, StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING};

    public static NBTTagCompound readCompressed(Path path, NBTReadLimiter nbtreadlimiter) throws IOException {
        NBTTagCompound nbttagcompound;
        try (InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);
             FastBufferedInputStream fastbufferedinputstream = new FastBufferedInputStream(inputstream);){
            nbttagcompound = NBTCompressedStreamTools.readCompressed(fastbufferedinputstream, nbtreadlimiter);
        }
        return nbttagcompound;
    }

    private static DataInputStream createDecompressorStream(InputStream inputstream) throws IOException {
        return new DataInputStream(new FastBufferedInputStream(new GZIPInputStream(inputstream)));
    }

    private static DataOutputStream createCompressorStream(OutputStream outputstream) throws IOException {
        return new DataOutputStream(new BufferedOutputStream(new GZIPOutputStream(outputstream)));
    }

    public static NBTTagCompound readCompressed(InputStream inputstream, NBTReadLimiter nbtreadlimiter) throws IOException {
        NBTTagCompound nbttagcompound;
        try (DataInputStream datainputstream = NBTCompressedStreamTools.createDecompressorStream(inputstream);){
            nbttagcompound = NBTCompressedStreamTools.read(datainputstream, nbtreadlimiter);
        }
        return nbttagcompound;
    }

    public static void parseCompressed(Path path, StreamTagVisitor streamtagvisitor, NBTReadLimiter nbtreadlimiter) throws IOException {
        try (InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);
             FastBufferedInputStream fastbufferedinputstream = new FastBufferedInputStream(inputstream);){
            NBTCompressedStreamTools.parseCompressed(fastbufferedinputstream, streamtagvisitor, nbtreadlimiter);
        }
    }

    public static void parseCompressed(InputStream inputstream, StreamTagVisitor streamtagvisitor, NBTReadLimiter nbtreadlimiter) throws IOException {
        try (DataInputStream datainputstream = NBTCompressedStreamTools.createDecompressorStream(inputstream);){
            NBTCompressedStreamTools.parse(datainputstream, streamtagvisitor, nbtreadlimiter);
        }
    }

    public static void writeCompressed(NBTTagCompound nbttagcompound, Path path) throws IOException {
        try (OutputStream outputstream = Files.newOutputStream(path, SYNC_OUTPUT_OPTIONS);
             BufferedOutputStream bufferedoutputstream = new BufferedOutputStream(outputstream);){
            NBTCompressedStreamTools.writeCompressed(nbttagcompound, bufferedoutputstream);
        }
    }

    public static void writeCompressed(NBTTagCompound nbttagcompound, OutputStream outputstream) throws IOException {
        try (DataOutputStream dataoutputstream = NBTCompressedStreamTools.createCompressorStream(outputstream);){
            NBTCompressedStreamTools.write(nbttagcompound, dataoutputstream);
        }
    }

    public static void write(NBTTagCompound nbttagcompound, Path path) throws IOException {
        try (OutputStream outputstream = Files.newOutputStream(path, SYNC_OUTPUT_OPTIONS);
             BufferedOutputStream bufferedoutputstream = new BufferedOutputStream(outputstream);
             DataOutputStream dataoutputstream = new DataOutputStream(bufferedoutputstream);){
            NBTCompressedStreamTools.write(nbttagcompound, dataoutputstream);
        }
    }

    @Nullable
    public static NBTTagCompound read(Path path) throws IOException {
        NBTTagCompound nbttagcompound;
        if (!Files.exists(path, new LinkOption[0])) {
            return null;
        }
        try (InputStream inputstream = Files.newInputStream(path, new OpenOption[0]);
             DataInputStream datainputstream = new DataInputStream(inputstream);){
            nbttagcompound = NBTCompressedStreamTools.read(datainputstream, NBTReadLimiter.unlimitedHeap());
        }
        return nbttagcompound;
    }

    public static NBTTagCompound read(DataInput datainput) throws IOException {
        return NBTCompressedStreamTools.read(datainput, NBTReadLimiter.unlimitedHeap());
    }

    public static NBTTagCompound read(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
        NBTBase nbtbase;
        if (datainput instanceof ByteBufInputStream) {
            datainput = new DataInputStream(new LimitStream((InputStream)((Object)datainput), nbtreadlimiter));
        }
        if ((nbtbase = NBTCompressedStreamTools.readUnnamedTag(datainput, nbtreadlimiter)) instanceof NBTTagCompound) {
            return (NBTTagCompound)nbtbase;
        }
        throw new IOException("Root tag must be a named compound tag");
    }

    public static void write(NBTTagCompound nbttagcompound, DataOutput dataoutput) throws IOException {
        NBTCompressedStreamTools.writeUnnamedTagWithFallback(nbttagcompound, dataoutput);
    }

    public static void parse(DataInput datainput, StreamTagVisitor streamtagvisitor, NBTReadLimiter nbtreadlimiter) throws IOException {
        NBTTagType<?> nbttagtype = NBTTagTypes.getType(datainput.readByte());
        if (nbttagtype == NBTTagEnd.TYPE) {
            if (streamtagvisitor.visitRootEntry(NBTTagEnd.TYPE) == StreamTagVisitor.b.CONTINUE) {
                streamtagvisitor.visitEnd();
            }
        } else {
            switch (streamtagvisitor.visitRootEntry(nbttagtype)) {
                default: {
                    break;
                }
                case BREAK: {
                    NBTTagString.skipString(datainput);
                    nbttagtype.skip(datainput, nbtreadlimiter);
                    break;
                }
                case CONTINUE: {
                    NBTTagString.skipString(datainput);
                    nbttagtype.parse(datainput, streamtagvisitor, nbtreadlimiter);
                }
            }
        }
    }

    public static NBTBase readAnyTag(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
        byte b0 = datainput.readByte();
        return b0 == 0 ? NBTTagEnd.INSTANCE : NBTCompressedStreamTools.readTagSafe(datainput, nbtreadlimiter, b0);
    }

    public static void writeAnyTag(NBTBase nbtbase, DataOutput dataoutput) throws IOException {
        dataoutput.writeByte(nbtbase.getId());
        if (nbtbase.getId() != 0) {
            nbtbase.write(dataoutput);
        }
    }

    public static void writeUnnamedTag(NBTBase nbtbase, DataOutput dataoutput) throws IOException {
        dataoutput.writeByte(nbtbase.getId());
        if (nbtbase.getId() != 0) {
            dataoutput.writeUTF("");
            nbtbase.write(dataoutput);
        }
    }

    public static void writeUnnamedTagWithFallback(NBTBase nbtbase, DataOutput dataoutput) throws IOException {
        NBTCompressedStreamTools.writeUnnamedTag(nbtbase, new a(dataoutput));
    }

    private static NBTBase readUnnamedTag(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
        byte b0 = datainput.readByte();
        if (b0 == 0) {
            return NBTTagEnd.INSTANCE;
        }
        NBTTagString.skipString(datainput);
        return NBTCompressedStreamTools.readTagSafe(datainput, nbtreadlimiter, b0);
    }

    private static NBTBase readTagSafe(DataInput datainput, NBTReadLimiter nbtreadlimiter, byte b0) {
        try {
            return NBTTagTypes.getType(b0).load(datainput, nbtreadlimiter);
        }
        catch (IOException ioexception) {
            CrashReport crashreport = CrashReport.forThrowable(ioexception, "Loading NBT data");
            CrashReportSystemDetails crashreportsystemdetails = crashreport.addCategory("NBT Tag");
            crashreportsystemdetails.setDetail("Tag type", b0);
            throw new ReportedNbtException(crashreport);
        }
    }

    public static class a
    extends DelegateDataOutput {
        public a(DataOutput dataoutput) {
            super(dataoutput);
        }

        @Override
        public void writeUTF(String s2) throws IOException {
            try {
                super.writeUTF(s2);
            }
            catch (UTFDataFormatException utfdataformatexception) {
                SystemUtils.logAndPauseIfInIde("Failed to write NBT String", utfdataformatexception);
                super.writeUTF("");
            }
        }
    }
}

