/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public class NBTTagByteArray
extends NBTList<NBTTagByte> {
    private static final int SELF_SIZE_IN_BYTES = 24;
    public static final NBTTagType<NBTTagByteArray> TYPE = new NBTTagType.b<NBTTagByteArray>(){

        @Override
        public NBTTagByteArray load(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
            return new NBTTagByteArray(1.readAccounted(datainput, nbtreadlimiter));
        }

        @Override
        public StreamTagVisitor.b parse(DataInput datainput, StreamTagVisitor streamtagvisitor, NBTReadLimiter nbtreadlimiter) throws IOException {
            return streamtagvisitor.visit(1.readAccounted(datainput, nbtreadlimiter));
        }

        private static byte[] readAccounted(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
            nbtreadlimiter.accountBytes(24L);
            int i2 = datainput.readInt();
            Preconditions.checkArgument((i2 < 0x1000000 ? 1 : 0) != 0);
            nbtreadlimiter.accountBytes(1L, i2);
            byte[] abyte = new byte[i2];
            datainput.readFully(abyte);
            return abyte;
        }

        @Override
        public void skip(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
            datainput.skipBytes(datainput.readInt() * 1);
        }

        @Override
        public String getName() {
            return "BYTE[]";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Byte_Array";
        }
    };
    private byte[] data;

    public NBTTagByteArray(byte[] abyte) {
        this.data = abyte;
    }

    public NBTTagByteArray(List<Byte> list) {
        this(NBTTagByteArray.toArray(list));
    }

    private static byte[] toArray(List<Byte> list) {
        byte[] abyte = new byte[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Byte obyte = list.get(i2);
            abyte[i2] = obyte == null ? (byte)0 : obyte;
        }
        return abyte;
    }

    @Override
    public void write(DataOutput dataoutput) throws IOException {
        dataoutput.writeInt(this.data.length);
        dataoutput.write(this.data);
    }

    @Override
    public int sizeInBytes() {
        return 24 + 1 * this.data.length;
    }

    @Override
    public byte getId() {
        return 7;
    }

    public NBTTagType<NBTTagByteArray> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    @Override
    public NBTBase copy() {
        byte[] abyte = new byte[this.data.length];
        System.arraycopy(this.data, 0, abyte, 0, this.data.length);
        return new NBTTagByteArray(abyte);
    }

    @Override
    public boolean equals(Object object) {
        return this == object ? true : object instanceof NBTTagByteArray && Arrays.equals(this.data, ((NBTTagByteArray)object).data);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    @Override
    public void accept(TagVisitor tagvisitor) {
        tagvisitor.visitByteArray(this);
    }

    public byte[] getAsByteArray() {
        return this.data;
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public NBTTagByte get(int i2) {
        return NBTTagByte.valueOf(this.data[i2]);
    }

    @Override
    public NBTTagByte set(int i2, NBTTagByte nbttagbyte) {
        byte b0 = this.data[i2];
        this.data[i2] = nbttagbyte.getAsByte();
        return NBTTagByte.valueOf(b0);
    }

    @Override
    public void add(int i2, NBTTagByte nbttagbyte) {
        this.data = ArrayUtils.add((byte[])this.data, (int)i2, (byte)nbttagbyte.getAsByte());
    }

    @Override
    public boolean setTag(int i2, NBTBase nbtbase) {
        if (nbtbase instanceof NBTNumber) {
            this.data[i2] = ((NBTNumber)nbtbase).getAsByte();
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int i2, NBTBase nbtbase) {
        if (nbtbase instanceof NBTNumber) {
            this.data = ArrayUtils.add((byte[])this.data, (int)i2, (byte)((NBTNumber)nbtbase).getAsByte());
            return true;
        }
        return false;
    }

    @Override
    public NBTTagByte remove(int i2) {
        byte b0 = this.data[i2];
        this.data = ArrayUtils.remove((byte[])this.data, (int)i2);
        return NBTTagByte.valueOf(b0);
    }

    @Override
    public byte getElementType() {
        return 1;
    }

    @Override
    public void clear() {
        this.data = new byte[0];
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor streamtagvisitor) {
        return streamtagvisitor.visit(this.data);
    }
}

