/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTList;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;
import org.apache.commons.lang3.ArrayUtils;

public class NBTTagIntArray
extends NBTList<NBTTagInt> {
    private static final int SELF_SIZE_IN_BYTES = 24;
    public static final NBTTagType<NBTTagIntArray> TYPE = new NBTTagType.b<NBTTagIntArray>(){

        @Override
        public NBTTagIntArray load(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
            return new NBTTagIntArray(1.readAccounted(datainput, nbtreadlimiter));
        }

        @Override
        public StreamTagVisitor.b parse(DataInput datainput, StreamTagVisitor streamtagvisitor, NBTReadLimiter nbtreadlimiter) throws IOException {
            return streamtagvisitor.visit(1.readAccounted(datainput, nbtreadlimiter));
        }

        private static int[] readAccounted(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
            nbtreadlimiter.accountBytes(24L);
            int i2 = datainput.readInt();
            Preconditions.checkArgument((i2 < 0x1000000 ? 1 : 0) != 0);
            nbtreadlimiter.accountBytes(4L, i2);
            int[] aint = new int[i2];
            for (int j2 = 0; j2 < i2; ++j2) {
                aint[j2] = datainput.readInt();
            }
            return aint;
        }

        @Override
        public void skip(DataInput datainput, NBTReadLimiter nbtreadlimiter) throws IOException {
            datainput.skipBytes(datainput.readInt() * 4);
        }

        @Override
        public String getName() {
            return "INT[]";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Int_Array";
        }
    };
    private int[] data;

    public NBTTagIntArray(int[] aint) {
        this.data = aint;
    }

    public NBTTagIntArray(List<Integer> list) {
        this(NBTTagIntArray.toArray(list));
    }

    private static int[] toArray(List<Integer> list) {
        int[] aint = new int[list.size()];
        for (int i2 = 0; i2 < list.size(); ++i2) {
            Integer integer = list.get(i2);
            aint[i2] = integer == null ? 0 : integer;
        }
        return aint;
    }

    @Override
    public void write(DataOutput dataoutput) throws IOException {
        dataoutput.writeInt(this.data.length);
        for (int k2 : this.data) {
            dataoutput.writeInt(k2);
        }
    }

    @Override
    public int sizeInBytes() {
        return 24 + 4 * this.data.length;
    }

    @Override
    public byte getId() {
        return 11;
    }

    public NBTTagType<NBTTagIntArray> getType() {
        return TYPE;
    }

    @Override
    public String toString() {
        return this.getAsString();
    }

    @Override
    public NBTTagIntArray copy() {
        int[] aint = new int[this.data.length];
        System.arraycopy(this.data, 0, aint, 0, this.data.length);
        return new NBTTagIntArray(aint);
    }

    @Override
    public boolean equals(Object object) {
        return this == object ? true : object instanceof NBTTagIntArray && Arrays.equals(this.data, ((NBTTagIntArray)object).data);
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.data);
    }

    public int[] getAsIntArray() {
        return this.data;
    }

    @Override
    public void accept(TagVisitor tagvisitor) {
        tagvisitor.visitIntArray(this);
    }

    @Override
    public int size() {
        return this.data.length;
    }

    @Override
    public NBTTagInt get(int i2) {
        return NBTTagInt.valueOf(this.data[i2]);
    }

    @Override
    public NBTTagInt set(int i2, NBTTagInt nbttagint) {
        int j2 = this.data[i2];
        this.data[i2] = nbttagint.getAsInt();
        return NBTTagInt.valueOf(j2);
    }

    @Override
    public void add(int i2, NBTTagInt nbttagint) {
        this.data = ArrayUtils.add((int[])this.data, (int)i2, (int)nbttagint.getAsInt());
    }

    @Override
    public boolean setTag(int i2, NBTBase nbtbase) {
        if (nbtbase instanceof NBTNumber) {
            this.data[i2] = ((NBTNumber)nbtbase).getAsInt();
            return true;
        }
        return false;
    }

    @Override
    public boolean addTag(int i2, NBTBase nbtbase) {
        if (nbtbase instanceof NBTNumber) {
            this.data = ArrayUtils.add((int[])this.data, (int)i2, (int)((NBTNumber)nbtbase).getAsInt());
            return true;
        }
        return false;
    }

    @Override
    public NBTTagInt remove(int i2) {
        int j2 = this.data[i2];
        this.data = ArrayUtils.remove((int[])this.data, (int)i2);
        return NBTTagInt.valueOf(j2);
    }

    @Override
    public byte getElementType() {
        return 3;
    }

    @Override
    public void clear() {
        this.data = new int[0];
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor streamtagvisitor) {
        return streamtagvisitor.visit(this.data);
    }
}

