/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTNumber;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;
import net.minecraft.nbt.TagVisitor;

public class NBTTagLong
extends NBTNumber {
    private static final int SELF_SIZE_IN_BYTES = 16;
    public static final NBTTagType<NBTTagLong> TYPE = new NBTTagType.a<NBTTagLong>(){

        @Override
        public NBTTagLong load(DataInput var0, NBTReadLimiter var1) throws IOException {
            return NBTTagLong.valueOf(1.readAccounted(var0, var1));
        }

        @Override
        public StreamTagVisitor.b parse(DataInput var0, StreamTagVisitor var1, NBTReadLimiter var2) throws IOException {
            return var1.visit(1.readAccounted(var0, var2));
        }

        private static long readAccounted(DataInput var0, NBTReadLimiter var1) throws IOException {
            var1.accountBytes(16L);
            return var0.readLong();
        }

        @Override
        public int size() {
            return 8;
        }

        @Override
        public String getName() {
            return "LONG";
        }

        @Override
        public String getPrettyName() {
            return "TAG_Long";
        }

        @Override
        public boolean isValue() {
            return true;
        }

        @Override
        public /* synthetic */ NBTBase load(DataInput dataInput, NBTReadLimiter nBTReadLimiter) throws IOException {
            return this.load(dataInput, nBTReadLimiter);
        }
    };
    private final long data;

    NBTTagLong(long var0) {
        this.data = var0;
    }

    public static NBTTagLong valueOf(long var0) {
        if (var0 >= -128L && var0 <= 1024L) {
            return a.cache[(int)var0 - -128];
        }
        return new NBTTagLong(var0);
    }

    @Override
    public void write(DataOutput var0) throws IOException {
        var0.writeLong(this.data);
    }

    @Override
    public int sizeInBytes() {
        return 16;
    }

    @Override
    public byte getId() {
        return 4;
    }

    public NBTTagType<NBTTagLong> getType() {
        return TYPE;
    }

    @Override
    public NBTTagLong copy() {
        return this;
    }

    public boolean equals(Object var0) {
        if (this == var0) {
            return true;
        }
        return var0 instanceof NBTTagLong && this.data == ((NBTTagLong)var0).data;
    }

    public int hashCode() {
        return (int)(this.data ^ this.data >>> 32);
    }

    @Override
    public void accept(TagVisitor var0) {
        var0.visitLong(this);
    }

    @Override
    public long getAsLong() {
        return this.data;
    }

    @Override
    public int getAsInt() {
        return (int)(this.data & 0xFFFFFFFFFFFFFFFFL);
    }

    @Override
    public short getAsShort() {
        return (short)(this.data & 0xFFFFL);
    }

    @Override
    public byte getAsByte() {
        return (byte)(this.data & 0xFFL);
    }

    @Override
    public double getAsDouble() {
        return this.data;
    }

    @Override
    public float getAsFloat() {
        return this.data;
    }

    @Override
    public Number getAsNumber() {
        return this.data;
    }

    @Override
    public StreamTagVisitor.b accept(StreamTagVisitor var0) {
        return var0.visit(this.data);
    }

    @Override
    public /* synthetic */ NBTBase copy() {
        return this.copy();
    }

    static class a {
        private static final int HIGH = 1024;
        private static final int LOW = -128;
        static final NBTTagLong[] cache = new NBTTagLong[1153];

        private a() {
        }

        static {
            for (int var0 = 0; var0 < cache.length; ++var0) {
                a.cache[var0] = new NBTTagLong(-128 + var0);
            }
        }
    }
}

