/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.nbt.visitors;

import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagByte;
import net.minecraft.nbt.NBTTagByteArray;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagDouble;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.nbt.NBTTagFloat;
import net.minecraft.nbt.NBTTagInt;
import net.minecraft.nbt.NBTTagIntArray;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.nbt.NBTTagLongArray;
import net.minecraft.nbt.NBTTagShort;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.nbt.NBTTagType;
import net.minecraft.nbt.StreamTagVisitor;

public class CollectToTag
implements StreamTagVisitor {
    private String lastId = "";
    @Nullable
    private NBTBase rootTag;
    private final Deque<Consumer<NBTBase>> consumerStack = new ArrayDeque<Consumer<NBTBase>>();

    @Nullable
    public NBTBase getResult() {
        return this.rootTag;
    }

    protected int depth() {
        return this.consumerStack.size();
    }

    private void appendEntry(NBTBase var0) {
        this.consumerStack.getLast().accept(var0);
    }

    @Override
    public StreamTagVisitor.b visitEnd() {
        this.appendEntry(NBTTagEnd.INSTANCE);
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(String var0) {
        this.appendEntry(NBTTagString.valueOf(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(byte var0) {
        this.appendEntry(NBTTagByte.valueOf(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(short var0) {
        this.appendEntry(NBTTagShort.valueOf(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(int var0) {
        this.appendEntry(NBTTagInt.valueOf(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(long var0) {
        this.appendEntry(NBTTagLong.valueOf(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(float var0) {
        this.appendEntry(NBTTagFloat.valueOf(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(double var0) {
        this.appendEntry(NBTTagDouble.valueOf(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(byte[] var0) {
        this.appendEntry(new NBTTagByteArray(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(int[] var0) {
        this.appendEntry(new NBTTagIntArray(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visit(long[] var0) {
        this.appendEntry(new NBTTagLongArray(var0));
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visitList(NBTTagType<?> var0, int var1) {
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.a visitElement(NBTTagType<?> var0, int var1) {
        this.enterContainerIfNeeded(var0);
        return StreamTagVisitor.a.ENTER;
    }

    @Override
    public StreamTagVisitor.a visitEntry(NBTTagType<?> var0) {
        return StreamTagVisitor.a.ENTER;
    }

    @Override
    public StreamTagVisitor.a visitEntry(NBTTagType<?> var0, String var1) {
        this.lastId = var1;
        this.enterContainerIfNeeded(var0);
        return StreamTagVisitor.a.ENTER;
    }

    private void enterContainerIfNeeded(NBTTagType<?> var0) {
        if (var0 == NBTTagList.TYPE) {
            NBTTagList var12 = new NBTTagList();
            this.appendEntry(var12);
            this.consumerStack.addLast(var12::add);
        } else if (var0 == NBTTagCompound.TYPE) {
            NBTTagCompound var13 = new NBTTagCompound();
            this.appendEntry(var13);
            this.consumerStack.addLast(var1 -> var13.put(this.lastId, (NBTBase)var1));
        }
    }

    @Override
    public StreamTagVisitor.b visitContainerEnd() {
        this.consumerStack.removeLast();
        return StreamTagVisitor.b.CONTINUE;
    }

    @Override
    public StreamTagVisitor.b visitRootEntry(NBTTagType<?> var02) {
        if (var02 == NBTTagList.TYPE) {
            NBTTagList var12 = new NBTTagList();
            this.rootTag = var12;
            this.consumerStack.addLast(var12::add);
        } else if (var02 == NBTTagCompound.TYPE) {
            NBTTagCompound var13 = new NBTTagCompound();
            this.rootTag = var13;
            this.consumerStack.addLast(var1 -> var13.put(this.lastId, (NBTBase)var1));
        } else {
            this.consumerStack.addLast(var0 -> {
                this.rootTag = var0;
            });
        }
        return StreamTagVisitor.b.CONTINUE;
    }
}

