/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.base.Suppliers;
import com.google.common.collect.Queues;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.authlib.properties.Property;
import com.mojang.logging.LogUtils;
import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelException;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelOutboundHandler;
import io.netty.channel.ChannelOutboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.ChannelPromise;
import io.netty.channel.DefaultEventLoopGroup;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.channel.epoll.Epoll;
import io.netty.channel.epoll.EpollEventLoopGroup;
import io.netty.channel.epoll.EpollSocketChannel;
import io.netty.channel.local.LocalChannel;
import io.netty.channel.local.LocalServerChannel;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.flow.FlowControlHandler;
import io.netty.handler.timeout.ReadTimeoutHandler;
import io.netty.handler.timeout.TimeoutException;
import io.netty.util.concurrent.GenericFutureListener;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.channels.ClosedChannelException;
import java.util.Objects;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.RejectedExecutionException;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import javax.crypto.Cipher;
import net.minecraft.SharedConstants;
import net.minecraft.SystemUtils;
import net.minecraft.network.BandwidthDebugMonitor;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.DisconnectionDetails;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.MonitorFrameDecoder;
import net.minecraft.network.NoOpFrameDecoder;
import net.minecraft.network.NoOpFrameEncoder;
import net.minecraft.network.PacketBundlePacker;
import net.minecraft.network.PacketBundleUnpacker;
import net.minecraft.network.PacketCompressor;
import net.minecraft.network.PacketDecoder;
import net.minecraft.network.PacketDecompressor;
import net.minecraft.network.PacketDecrypter;
import net.minecraft.network.PacketEncoder;
import net.minecraft.network.PacketEncrypter;
import net.minecraft.network.PacketListener;
import net.minecraft.network.PacketPrepender;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.PacketSplitter;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.SkipEncodeException;
import net.minecraft.network.TickablePacketListener;
import net.minecraft.network.UnconfiguredPipelineHandler;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.common.ClientboundDisconnectPacket;
import net.minecraft.network.protocol.handshake.ClientIntent;
import net.minecraft.network.protocol.handshake.HandshakeProtocols;
import net.minecraft.network.protocol.handshake.PacketHandshakingInListener;
import net.minecraft.network.protocol.handshake.PacketHandshakingInSetProtocol;
import net.minecraft.network.protocol.login.LoginProtocols;
import net.minecraft.network.protocol.login.PacketLoginOutDisconnect;
import net.minecraft.network.protocol.login.PacketLoginOutListener;
import net.minecraft.network.protocol.status.PacketStatusOutListener;
import net.minecraft.network.protocol.status.StatusProtocols;
import net.minecraft.server.CancelledPacketHandleException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.MathHelper;
import net.minecraft.util.debugchart.LocalSampleLogger;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class NetworkManager
extends SimpleChannelInboundHandler<Packet<?>> {
    private static final float AVERAGE_PACKETS_SMOOTHING = 0.75f;
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final Marker ROOT_MARKER = MarkerFactory.getMarker((String)"NETWORK");
    public static final Marker PACKET_MARKER = SystemUtils.make(MarkerFactory.getMarker((String)"NETWORK_PACKETS"), marker -> marker.add(ROOT_MARKER));
    public static final Marker PACKET_RECEIVED_MARKER = SystemUtils.make(MarkerFactory.getMarker((String)"PACKET_RECEIVED"), marker -> marker.add(PACKET_MARKER));
    public static final Marker PACKET_SENT_MARKER = SystemUtils.make(MarkerFactory.getMarker((String)"PACKET_SENT"), marker -> marker.add(PACKET_MARKER));
    public static final Supplier<NioEventLoopGroup> NETWORK_WORKER_GROUP = Suppliers.memoize(() -> new NioEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Client IO #%d").setDaemon(true).build()));
    public static final Supplier<EpollEventLoopGroup> NETWORK_EPOLL_WORKER_GROUP = Suppliers.memoize(() -> new EpollEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Epoll Client IO #%d").setDaemon(true).build()));
    public static final Supplier<DefaultEventLoopGroup> LOCAL_WORKER_GROUP = Suppliers.memoize(() -> new DefaultEventLoopGroup(0, new ThreadFactoryBuilder().setNameFormat("Netty Local Client IO #%d").setDaemon(true).build()));
    private static final ProtocolInfo<PacketHandshakingInListener> INITIAL_PROTOCOL = HandshakeProtocols.SERVERBOUND;
    private final EnumProtocolDirection receiving;
    private volatile boolean sendLoginDisconnect = true;
    private final Queue<Consumer<NetworkManager>> pendingActions = Queues.newConcurrentLinkedQueue();
    public Channel channel;
    public SocketAddress address;
    public UUID spoofedUUID;
    public Property[] spoofedProfile;
    public boolean preparing = true;
    @Nullable
    private volatile PacketListener disconnectListener;
    @Nullable
    private volatile PacketListener packetListener;
    @Nullable
    private DisconnectionDetails disconnectionDetails;
    private boolean encrypted;
    private boolean disconnectionHandled;
    private int receivedPackets;
    private int sentPackets;
    private float averageReceivedPackets;
    private float averageSentPackets;
    private int tickCount;
    private boolean handlingFault;
    @Nullable
    private volatile DisconnectionDetails delayedDisconnect;
    @Nullable
    BandwidthDebugMonitor bandwidthDebugMonitor;
    public String hostname = "";

    public NetworkManager(EnumProtocolDirection enumprotocoldirection) {
        this.receiving = enumprotocoldirection;
    }

    public void channelActive(ChannelHandlerContext channelhandlercontext) throws Exception {
        super.channelActive(channelhandlercontext);
        this.channel = channelhandlercontext.channel();
        this.address = this.channel.remoteAddress();
        this.preparing = false;
        if (this.delayedDisconnect != null) {
            this.disconnect(this.delayedDisconnect);
        }
    }

    public void channelInactive(ChannelHandlerContext channelhandlercontext) {
        this.disconnect(IChatBaseComponent.translatable("disconnect.endOfStream"));
    }

    public void exceptionCaught(ChannelHandlerContext channelhandlercontext, Throwable throwable) {
        if (throwable instanceof SkipEncodeException) {
            LOGGER.debug("Skipping packet due to errors", throwable.getCause());
        } else {
            boolean flag = !this.handlingFault;
            this.handlingFault = true;
            if (this.channel.isOpen()) {
                if (throwable instanceof TimeoutException) {
                    LOGGER.debug("Timeout", throwable);
                    this.disconnect(IChatBaseComponent.translatable("disconnect.timeout"));
                } else {
                    IChatMutableComponent ichatmutablecomponent = IChatBaseComponent.translatable("disconnect.genericReason", "Internal Exception: " + String.valueOf(throwable));
                    PacketListener packetlistener = this.packetListener;
                    DisconnectionDetails disconnectiondetails = packetlistener != null ? packetlistener.createDisconnectionInfo(ichatmutablecomponent, throwable) : new DisconnectionDetails(ichatmutablecomponent);
                    if (flag) {
                        LOGGER.debug("Failed to sent packet", throwable);
                        if (this.getSending() == EnumProtocolDirection.CLIENTBOUND) {
                            Packet<PacketLoginOutListener> packet = this.sendLoginDisconnect ? new PacketLoginOutDisconnect(ichatmutablecomponent) : new ClientboundDisconnectPacket(ichatmutablecomponent);
                            this.send(packet, PacketSendListener.thenRun(() -> this.disconnect(disconnectiondetails)));
                        } else {
                            this.disconnect(disconnectiondetails);
                        }
                        this.setReadOnly();
                    } else {
                        LOGGER.debug("Double fault", throwable);
                        this.disconnect(disconnectiondetails);
                    }
                }
            }
        }
        if (MinecraftServer.getServer().isDebugging()) {
            throwable.printStackTrace();
        }
    }

    protected void channelRead0(ChannelHandlerContext channelhandlercontext, Packet<?> packet) {
        if (this.channel.isOpen()) {
            PacketListener packetlistener = this.packetListener;
            if (packetlistener == null) {
                throw new IllegalStateException("Received a packet before the packet listener was initialized");
            }
            if (packetlistener.shouldHandleMessage(packet)) {
                try {
                    NetworkManager.genericsFtw(packet, packetlistener);
                }
                catch (CancelledPacketHandleException cancelledPacketHandleException) {
                }
                catch (RejectedExecutionException rejectedexecutionexception) {
                    this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.server_shutdown"));
                }
                catch (ClassCastException classcastexception) {
                    LOGGER.error("Received {} that couldn't be processed", packet.getClass(), (Object)classcastexception);
                    this.disconnect(IChatBaseComponent.translatable("multiplayer.disconnect.invalid_packet"));
                }
                ++this.receivedPackets;
            }
        }
    }

    private static <T extends PacketListener> void genericsFtw(Packet<T> packet, PacketListener packetlistener) {
        packet.handle(packetlistener);
    }

    private void validateListener(ProtocolInfo<?> protocolinfo, PacketListener packetlistener) {
        Validate.notNull((Object)packetlistener, (String)"packetListener", (Object[])new Object[0]);
        EnumProtocolDirection enumprotocoldirection = packetlistener.flow();
        if (enumprotocoldirection != this.receiving) {
            String s2 = String.valueOf((Object)this.receiving);
            throw new IllegalStateException("Trying to set listener for wrong side: connection is " + s2 + ", but listener is " + String.valueOf((Object)enumprotocoldirection));
        }
        EnumProtocol enumprotocol = packetlistener.protocol();
        if (protocolinfo.id() != enumprotocol) {
            String s3 = String.valueOf((Object)enumprotocol);
            throw new IllegalStateException("Listener protocol (" + s3 + ") does not match requested one " + String.valueOf(protocolinfo));
        }
    }

    private static void syncAfterConfigurationChange(ChannelFuture channelfuture) {
        try {
            channelfuture.syncUninterruptibly();
        }
        catch (Exception exception) {
            if (exception instanceof ClosedChannelException) {
                LOGGER.info("Connection closed during protocol change");
            }
            throw exception;
        }
    }

    public <T extends PacketListener> void setupInboundProtocol(ProtocolInfo<T> protocolinfo, T t0) {
        this.validateListener(protocolinfo, t0);
        if (protocolinfo.flow() != this.getReceiving()) {
            throw new IllegalStateException("Invalid inbound protocol: " + String.valueOf((Object)protocolinfo.id()));
        }
        this.packetListener = t0;
        this.disconnectListener = null;
        UnconfiguredPipelineHandler.b unconfiguredpipelinehandler_b = UnconfiguredPipelineHandler.setupInboundProtocol(protocolinfo);
        BundlerInfo bundlerinfo = protocolinfo.bundlerInfo();
        if (bundlerinfo != null) {
            PacketBundlePacker packetbundlepacker = new PacketBundlePacker(bundlerinfo);
            unconfiguredpipelinehandler_b = unconfiguredpipelinehandler_b.andThen(channelhandlercontext -> channelhandlercontext.pipeline().addAfter("decoder", "bundler", (ChannelHandler)packetbundlepacker));
        }
        NetworkManager.syncAfterConfigurationChange(this.channel.writeAndFlush((Object)unconfiguredpipelinehandler_b));
    }

    public void setupOutboundProtocol(ProtocolInfo<?> protocolinfo) {
        if (protocolinfo.flow() != this.getSending()) {
            throw new IllegalStateException("Invalid outbound protocol: " + String.valueOf((Object)protocolinfo.id()));
        }
        UnconfiguredPipelineHandler.d unconfiguredpipelinehandler_d = UnconfiguredPipelineHandler.setupOutboundProtocol(protocolinfo);
        BundlerInfo bundlerinfo = protocolinfo.bundlerInfo();
        if (bundlerinfo != null) {
            PacketBundleUnpacker packetbundleunpacker = new PacketBundleUnpacker(bundlerinfo);
            unconfiguredpipelinehandler_d = unconfiguredpipelinehandler_d.andThen(channelhandlercontext -> channelhandlercontext.pipeline().addAfter("encoder", "unbundler", (ChannelHandler)packetbundleunpacker));
        }
        boolean flag = protocolinfo.id() == EnumProtocol.LOGIN;
        NetworkManager.syncAfterConfigurationChange(this.channel.writeAndFlush((Object)unconfiguredpipelinehandler_d.andThen(channelhandlercontext -> {
            this.sendLoginDisconnect = flag;
        })));
    }

    public void setListenerForServerboundHandshake(PacketListener packetlistener) {
        if (this.packetListener != null) {
            throw new IllegalStateException("Listener already set");
        }
        if (this.receiving != EnumProtocolDirection.SERVERBOUND || packetlistener.flow() != EnumProtocolDirection.SERVERBOUND || packetlistener.protocol() != INITIAL_PROTOCOL.id()) {
            throw new IllegalStateException("Invalid initial listener");
        }
        this.packetListener = packetlistener;
    }

    public void initiateServerboundStatusConnection(String s2, int i2, PacketStatusOutListener packetstatusoutlistener) {
        this.initiateServerboundConnection(s2, i2, StatusProtocols.SERVERBOUND, StatusProtocols.CLIENTBOUND, packetstatusoutlistener, ClientIntent.STATUS);
    }

    public void initiateServerboundPlayConnection(String s2, int i2, PacketLoginOutListener packetloginoutlistener) {
        this.initiateServerboundConnection(s2, i2, LoginProtocols.SERVERBOUND, LoginProtocols.CLIENTBOUND, packetloginoutlistener, ClientIntent.LOGIN);
    }

    public <S extends ServerboundPacketListener, C extends ClientboundPacketListener> void initiateServerboundPlayConnection(String s2, int i2, ProtocolInfo<S> protocolinfo, ProtocolInfo<C> protocolinfo1, C c0, boolean flag) {
        this.initiateServerboundConnection(s2, i2, protocolinfo, protocolinfo1, c0, flag ? ClientIntent.TRANSFER : ClientIntent.LOGIN);
    }

    private <S extends ServerboundPacketListener, C extends ClientboundPacketListener> void initiateServerboundConnection(String s2, int i2, ProtocolInfo<S> protocolinfo, ProtocolInfo<C> protocolinfo1, C c0, ClientIntent clientintent) {
        if (protocolinfo.id() != protocolinfo1.id()) {
            throw new IllegalStateException("Mismatched initial protocols");
        }
        this.disconnectListener = c0;
        this.runOnceConnected(networkmanager -> {
            this.setupInboundProtocol(protocolinfo1, c0);
            networkmanager.sendPacket(new PacketHandshakingInSetProtocol(SharedConstants.getCurrentVersion().getProtocolVersion(), s2, i2, clientintent), null, true);
            this.setupOutboundProtocol(protocolinfo);
        });
    }

    public void send(Packet<?> packet) {
        this.send(packet, null);
    }

    public void send(Packet<?> packet, @Nullable PacketSendListener packetsendlistener) {
        this.send(packet, packetsendlistener, true);
    }

    public void send(Packet<?> packet, @Nullable PacketSendListener packetsendlistener, boolean flag) {
        if (this.isConnected()) {
            this.flushQueue();
            this.sendPacket(packet, packetsendlistener, flag);
        } else {
            this.pendingActions.add(networkmanager -> networkmanager.sendPacket(packet, packetsendlistener, flag));
        }
    }

    public void runOnceConnected(Consumer<NetworkManager> consumer) {
        if (this.isConnected()) {
            this.flushQueue();
            consumer.accept(this);
        } else {
            this.pendingActions.add(consumer);
        }
    }

    private void sendPacket(Packet<?> packet, @Nullable PacketSendListener packetsendlistener, boolean flag) {
        ++this.sentPackets;
        if (this.channel.eventLoop().inEventLoop()) {
            this.doSendPacket(packet, packetsendlistener, flag);
        } else {
            this.channel.eventLoop().execute(() -> this.doSendPacket(packet, packetsendlistener, flag));
        }
    }

    private void doSendPacket(Packet<?> packet, @Nullable PacketSendListener packetsendlistener, boolean flag) {
        ChannelFuture channelfuture;
        ChannelFuture channelFuture = channelfuture = flag ? this.channel.writeAndFlush(packet) : this.channel.write(packet);
        if (packetsendlistener != null) {
            channelfuture.addListener(future -> {
                if (future.isSuccess()) {
                    packetsendlistener.onSuccess();
                } else {
                    Packet<?> packet1 = packetsendlistener.onFailure();
                    if (packet1 != null) {
                        ChannelFuture channelfuture1 = this.channel.writeAndFlush(packet1);
                        channelfuture1.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
                    }
                }
            });
        }
        channelfuture.addListener((GenericFutureListener)ChannelFutureListener.FIRE_EXCEPTION_ON_FAILURE);
    }

    public void flushChannel() {
        if (this.isConnected()) {
            this.flush();
        } else {
            this.pendingActions.add(NetworkManager::flush);
        }
    }

    private void flush() {
        if (this.channel.eventLoop().inEventLoop()) {
            this.channel.flush();
        } else {
            this.channel.eventLoop().execute(() -> this.channel.flush());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flushQueue() {
        if (this.channel != null && this.channel.isOpen()) {
            Queue<Consumer<NetworkManager>> queue = this.pendingActions;
            Queue<Consumer<NetworkManager>> queue2 = this.pendingActions;
            synchronized (queue2) {
                Consumer<NetworkManager> consumer;
                while ((consumer = this.pendingActions.poll()) != null) {
                    consumer.accept(this);
                }
            }
        }
    }

    public void tick() {
        this.flushQueue();
        PacketListener packetlistener = this.packetListener;
        if (packetlistener instanceof TickablePacketListener) {
            TickablePacketListener tickablepacketlistener = (TickablePacketListener)packetlistener;
            tickablepacketlistener.tick();
        }
        if (!this.isConnected() && !this.disconnectionHandled) {
            this.handleDisconnection();
        }
        if (this.channel != null) {
            this.channel.flush();
        }
        if (this.tickCount++ % 20 == 0) {
            this.tickSecond();
        }
        if (this.bandwidthDebugMonitor != null) {
            this.bandwidthDebugMonitor.tick();
        }
    }

    protected void tickSecond() {
        this.averageSentPackets = MathHelper.lerp(0.75f, this.sentPackets, this.averageSentPackets);
        this.averageReceivedPackets = MathHelper.lerp(0.75f, this.receivedPackets, this.averageReceivedPackets);
        this.sentPackets = 0;
        this.receivedPackets = 0;
    }

    public SocketAddress getRemoteAddress() {
        return this.address;
    }

    public String getLoggableAddress(boolean flag) {
        return this.address == null ? "local" : (flag ? this.address.toString() : "IP hidden");
    }

    public void disconnect(IChatBaseComponent ichatbasecomponent) {
        this.disconnect(new DisconnectionDetails(ichatbasecomponent));
    }

    public void disconnect(DisconnectionDetails disconnectiondetails) {
        this.preparing = false;
        if (this.channel == null) {
            this.delayedDisconnect = disconnectiondetails;
        }
        if (this.isConnected()) {
            this.channel.close();
            this.disconnectionDetails = disconnectiondetails;
        }
    }

    public boolean isMemoryConnection() {
        return this.channel instanceof LocalChannel || this.channel instanceof LocalServerChannel;
    }

    public EnumProtocolDirection getReceiving() {
        return this.receiving;
    }

    public EnumProtocolDirection getSending() {
        return this.receiving.getOpposite();
    }

    public static NetworkManager connectToServer(InetSocketAddress inetsocketaddress, boolean flag, @Nullable LocalSampleLogger localsamplelogger) {
        NetworkManager networkmanager = new NetworkManager(EnumProtocolDirection.CLIENTBOUND);
        if (localsamplelogger != null) {
            networkmanager.setBandwidthLogger(localsamplelogger);
        }
        ChannelFuture channelfuture = NetworkManager.connect(inetsocketaddress, flag, networkmanager);
        channelfuture.syncUninterruptibly();
        return networkmanager;
    }

    public static ChannelFuture connect(InetSocketAddress inetsocketaddress, boolean flag, final NetworkManager networkmanager) {
        EventLoopGroup eventloopgroup;
        Class<NioSocketChannel> oclass;
        if (Epoll.isAvailable() && flag) {
            oclass = EpollSocketChannel.class;
            eventloopgroup = (EventLoopGroup)NETWORK_EPOLL_WORKER_GROUP.get();
        } else {
            oclass = NioSocketChannel.class;
            eventloopgroup = (EventLoopGroup)NETWORK_WORKER_GROUP.get();
        }
        return ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(eventloopgroup)).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                try {
                    channel.config().setOption(ChannelOption.TCP_NODELAY, (Object)true);
                }
                catch (ChannelException channelException) {
                    // empty catch block
                }
                ChannelPipeline channelpipeline = channel.pipeline().addLast("timeout", (ChannelHandler)new ReadTimeoutHandler(30));
                NetworkManager.configureSerialization(channelpipeline, EnumProtocolDirection.CLIENTBOUND, false, networkmanager.bandwidthDebugMonitor);
                networkmanager.configurePacketHandler(channelpipeline);
            }
        })).channel(oclass)).connect(inetsocketaddress.getAddress(), inetsocketaddress.getPort());
    }

    private static String outboundHandlerName(boolean flag) {
        return flag ? "encoder" : "outbound_config";
    }

    private static String inboundHandlerName(boolean flag) {
        return flag ? "decoder" : "inbound_config";
    }

    public void configurePacketHandler(ChannelPipeline channelpipeline) {
        channelpipeline.addLast("hackfix", (ChannelHandler)new ChannelOutboundHandlerAdapter(this){

            public void write(ChannelHandlerContext channelhandlercontext, Object object, ChannelPromise channelpromise) throws Exception {
                super.write(channelhandlercontext, object, channelpromise);
            }
        }).addLast("packet_handler", (ChannelHandler)this);
    }

    public static void configureSerialization(ChannelPipeline channelpipeline, EnumProtocolDirection enumprotocoldirection, boolean flag, @Nullable BandwidthDebugMonitor bandwidthdebugmonitor) {
        EnumProtocolDirection enumprotocoldirection1 = enumprotocoldirection.getOpposite();
        boolean flag1 = enumprotocoldirection == EnumProtocolDirection.SERVERBOUND;
        boolean flag2 = enumprotocoldirection1 == EnumProtocolDirection.SERVERBOUND;
        channelpipeline.addLast("splitter", (ChannelHandler)NetworkManager.createFrameDecoder(bandwidthdebugmonitor, flag)).addLast(new ChannelHandler[]{new FlowControlHandler()}).addLast(NetworkManager.inboundHandlerName(flag1), flag1 ? new PacketDecoder<PacketHandshakingInListener>(INITIAL_PROTOCOL) : new UnconfiguredPipelineHandler.a()).addLast("prepender", (ChannelHandler)NetworkManager.createFrameEncoder(flag)).addLast(NetworkManager.outboundHandlerName(flag2), flag2 ? new PacketEncoder<PacketHandshakingInListener>(INITIAL_PROTOCOL) : new UnconfiguredPipelineHandler.c());
    }

    private static ChannelOutboundHandler createFrameEncoder(boolean flag) {
        return flag ? new NoOpFrameEncoder() : new PacketPrepender();
    }

    private static ChannelInboundHandler createFrameDecoder(@Nullable BandwidthDebugMonitor bandwidthdebugmonitor, boolean flag) {
        return !flag ? new PacketSplitter(bandwidthdebugmonitor) : (bandwidthdebugmonitor != null ? new MonitorFrameDecoder(bandwidthdebugmonitor) : new NoOpFrameDecoder());
    }

    public static void configureInMemoryPipeline(ChannelPipeline channelpipeline, EnumProtocolDirection enumprotocoldirection) {
        NetworkManager.configureSerialization(channelpipeline, enumprotocoldirection, true, null);
    }

    public static NetworkManager connectToLocalServer(SocketAddress socketaddress) {
        final NetworkManager networkmanager = new NetworkManager(EnumProtocolDirection.CLIENTBOUND);
        ((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group((EventLoopGroup)LOCAL_WORKER_GROUP.get())).handler((ChannelHandler)new ChannelInitializer<Channel>(){

            protected void initChannel(Channel channel) {
                ChannelPipeline channelpipeline = channel.pipeline();
                NetworkManager.configureInMemoryPipeline(channelpipeline, EnumProtocolDirection.CLIENTBOUND);
                networkmanager.configurePacketHandler(channelpipeline);
            }
        })).channel(LocalChannel.class)).connect(socketaddress).syncUninterruptibly();
        return networkmanager;
    }

    public void setEncryptionKey(Cipher cipher, Cipher cipher1) {
        this.encrypted = true;
        this.channel.pipeline().addBefore("splitter", "decrypt", (ChannelHandler)new PacketDecrypter(cipher));
        this.channel.pipeline().addBefore("prepender", "encrypt", (ChannelHandler)new PacketEncrypter(cipher1));
    }

    public boolean isEncrypted() {
        return this.encrypted;
    }

    public boolean isConnected() {
        return this.channel != null && this.channel.isOpen();
    }

    public boolean isConnecting() {
        return this.channel == null;
    }

    @Nullable
    public PacketListener getPacketListener() {
        return this.packetListener;
    }

    @Nullable
    public DisconnectionDetails getDisconnectionDetails() {
        return this.disconnectionDetails;
    }

    public void setReadOnly() {
        if (this.channel != null) {
            this.channel.config().setAutoRead(false);
        }
    }

    public void setupCompression(int i2, boolean flag) {
        if (i2 >= 0) {
            ChannelHandler channelhandler = this.channel.pipeline().get("decompress");
            if (channelhandler instanceof PacketDecompressor) {
                PacketDecompressor packetdecompressor = (PacketDecompressor)channelhandler;
                packetdecompressor.setThreshold(i2, flag);
            } else {
                this.channel.pipeline().addAfter("splitter", "decompress", (ChannelHandler)new PacketDecompressor(i2, flag));
            }
            channelhandler = this.channel.pipeline().get("compress");
            if (channelhandler instanceof PacketCompressor) {
                PacketCompressor packetcompressor = (PacketCompressor)channelhandler;
                packetcompressor.setThreshold(i2);
            } else {
                this.channel.pipeline().addAfter("prepender", "compress", (ChannelHandler)new PacketCompressor(i2));
            }
        } else {
            if (this.channel.pipeline().get("decompress") instanceof PacketDecompressor) {
                this.channel.pipeline().remove("decompress");
            }
            if (this.channel.pipeline().get("compress") instanceof PacketCompressor) {
                this.channel.pipeline().remove("compress");
            }
        }
    }

    public void handleDisconnection() {
        if (this.channel != null && !this.channel.isOpen()) {
            if (this.disconnectionHandled) {
                LOGGER.warn("handleDisconnection() called twice");
            } else {
                PacketListener packetlistener1;
                this.disconnectionHandled = true;
                PacketListener packetlistener = this.getPacketListener();
                PacketListener packetListener = packetlistener1 = packetlistener != null ? packetlistener : this.disconnectListener;
                if (packetlistener1 != null) {
                    DisconnectionDetails disconnectiondetails = Objects.requireNonNullElseGet(this.getDisconnectionDetails(), () -> new DisconnectionDetails(IChatBaseComponent.translatable("multiplayer.disconnect.generic")));
                    packetlistener1.onDisconnect(disconnectiondetails);
                }
                this.pendingActions.clear();
            }
        }
    }

    public float getAverageReceivedPackets() {
        return this.averageReceivedPackets;
    }

    public float getAverageSentPackets() {
        return this.averageSentPackets;
    }

    public void setBandwidthLogger(LocalSampleLogger localsamplelogger) {
        this.bandwidthDebugMonitor = new BandwidthDebugMonitor(localsamplelogger);
    }
}

