/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufInputStream;
import io.netty.buffer.ByteBufOutputStream;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.codec.EncoderException;
import io.netty.util.ByteProcessor;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.FileChannel;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.security.PublicKey;
import java.time.Instant;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.ToIntFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.core.EnumDirection;
import net.minecraft.core.GlobalPos;
import net.minecraft.core.IRegistry;
import net.minecraft.core.SectionPosition;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTCompressedStreamTools;
import net.minecraft.nbt.NBTReadLimiter;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagEnd;
import net.minecraft.network.Utf8String;
import net.minecraft.network.VarInt;
import net.minecraft.network.VarLong;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.util.ChatDeserializer;
import net.minecraft.util.CryptographyException;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MinecraftEncryption;
import net.minecraft.world.level.ChunkCoordIntPair;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.MovingObjectPositionBlock;
import net.minecraft.world.phys.Vec3D;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class PacketDataSerializer
extends ByteBuf {
    public static final int DEFAULT_NBT_QUOTA = 0x200000;
    private final ByteBuf source;
    public static final short MAX_STRING_LENGTH = Short.MAX_VALUE;
    public static final int MAX_COMPONENT_STRING_LENGTH = 262144;
    private static final int PUBLIC_KEY_SIZE = 256;
    private static final int MAX_PUBLIC_KEY_HEADER_SIZE = 256;
    private static final int MAX_PUBLIC_KEY_LENGTH = 512;
    private static final Gson GSON = new Gson();

    public PacketDataSerializer(ByteBuf bytebuf) {
        this.source = bytebuf;
    }

    @Deprecated
    public <T> T readWithCodecTrusted(DynamicOps<NBTBase> dynamicops, Codec<T> codec) {
        return this.readWithCodec(dynamicops, codec, NBTReadLimiter.unlimitedHeap());
    }

    @Deprecated
    public <T> T readWithCodec(DynamicOps<NBTBase> dynamicops, Codec<T> codec, NBTReadLimiter nbtreadlimiter) {
        NBTBase nbtbase = this.readNbt(nbtreadlimiter);
        return (T)codec.parse(dynamicops, (Object)nbtbase).getOrThrow(s2 -> new DecoderException("Failed to decode: " + s2 + " " + String.valueOf(nbtbase)));
    }

    @Deprecated
    public <T> PacketDataSerializer writeWithCodec(DynamicOps<NBTBase> dynamicops, Codec<T> codec, T t0) {
        NBTBase nbtbase = (NBTBase)codec.encodeStart(dynamicops, t0).getOrThrow(s2 -> new EncoderException("Failed to encode: " + s2 + " " + String.valueOf(t0)));
        this.writeNbt(nbtbase);
        return this;
    }

    public <T> T readJsonWithCodec(Codec<T> codec) {
        JsonElement jsonelement = ChatDeserializer.fromJson(GSON, this.readUtf(), JsonElement.class);
        DataResult dataresult = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonelement);
        return (T)dataresult.getOrThrow(s2 -> new DecoderException("Failed to decode json: " + s2));
    }

    public <T> void writeJsonWithCodec(Codec<T> codec, T t0) {
        DataResult dataresult = codec.encodeStart((DynamicOps)JsonOps.INSTANCE, t0);
        this.writeUtf(GSON.toJson((JsonElement)dataresult.getOrThrow(s2 -> new EncoderException("Failed to encode: " + s2 + " " + String.valueOf(t0)))));
    }

    public static <T> IntFunction<T> limitValue(IntFunction<T> intfunction, int i2) {
        return j2 -> {
            if (j2 > i2) {
                throw new DecoderException("Value " + j2 + " is larger than limit " + i2);
            }
            return intfunction.apply(j2);
        };
    }

    public <T, C extends Collection<T>> C readCollection(IntFunction<C> intfunction, StreamDecoder<? super PacketDataSerializer, T> streamdecoder) {
        int i2 = this.readVarInt();
        Collection c0 = (Collection)intfunction.apply(i2);
        for (int j2 = 0; j2 < i2; ++j2) {
            c0.add(streamdecoder.decode(this));
        }
        return (C)c0;
    }

    public <T> void writeCollection(Collection<T> collection, StreamEncoder<? super PacketDataSerializer, T> streamencoder) {
        this.writeVarInt(collection.size());
        for (T t0 : collection) {
            streamencoder.encode(this, t0);
        }
    }

    public <T> List<T> readList(StreamDecoder<? super PacketDataSerializer, T> streamdecoder) {
        return this.readCollection(Lists::newArrayListWithCapacity, streamdecoder);
    }

    public IntList readIntIdList() {
        int i2 = this.readVarInt();
        IntArrayList intarraylist = new IntArrayList();
        for (int j2 = 0; j2 < i2; ++j2) {
            intarraylist.add(this.readVarInt());
        }
        return intarraylist;
    }

    public void writeIntIdList(IntList intlist) {
        this.writeVarInt(intlist.size());
        intlist.forEach(this::writeVarInt);
    }

    public <K, V, M extends Map<K, V>> M readMap(IntFunction<M> intfunction, StreamDecoder<? super PacketDataSerializer, K> streamdecoder, StreamDecoder<? super PacketDataSerializer, V> streamdecoder1) {
        int i2 = this.readVarInt();
        Map m0 = (Map)intfunction.apply(i2);
        for (int j2 = 0; j2 < i2; ++j2) {
            K k0 = streamdecoder.decode(this);
            V v0 = streamdecoder1.decode(this);
            m0.put(k0, v0);
        }
        return (M)m0;
    }

    public <K, V> Map<K, V> readMap(StreamDecoder<? super PacketDataSerializer, K> streamdecoder, StreamDecoder<? super PacketDataSerializer, V> streamdecoder1) {
        return this.readMap(Maps::newHashMapWithExpectedSize, streamdecoder, streamdecoder1);
    }

    public <K, V> void writeMap(Map<K, V> map, StreamEncoder<? super PacketDataSerializer, K> streamencoder, StreamEncoder<? super PacketDataSerializer, V> streamencoder1) {
        this.writeVarInt(map.size());
        map.forEach((object, object1) -> {
            streamencoder.encode(this, object);
            streamencoder1.encode(this, object1);
        });
    }

    public void readWithCount(Consumer<PacketDataSerializer> consumer) {
        int i2 = this.readVarInt();
        for (int j2 = 0; j2 < i2; ++j2) {
            consumer.accept(this);
        }
    }

    public <E extends Enum<E>> void writeEnumSet(EnumSet<E> enumset, Class<E> oclass) {
        Enum[] ae = (Enum[])oclass.getEnumConstants();
        BitSet bitset = new BitSet(ae.length);
        for (int i2 = 0; i2 < ae.length; ++i2) {
            bitset.set(i2, enumset.contains(ae[i2]));
        }
        this.writeFixedBitSet(bitset, ae.length);
    }

    public <E extends Enum<E>> EnumSet<E> readEnumSet(Class<E> oclass) {
        Enum[] ae = (Enum[])oclass.getEnumConstants();
        BitSet bitset = this.readFixedBitSet(ae.length);
        EnumSet<Enum> enumset = EnumSet.noneOf(oclass);
        for (int i2 = 0; i2 < ae.length; ++i2) {
            if (!bitset.get(i2)) continue;
            enumset.add(ae[i2]);
        }
        return enumset;
    }

    public <T> void writeOptional(Optional<T> optional, StreamEncoder<? super PacketDataSerializer, T> streamencoder) {
        if (optional.isPresent()) {
            this.writeBoolean(true);
            streamencoder.encode(this, optional.get());
        } else {
            this.writeBoolean(false);
        }
    }

    public <T> Optional<T> readOptional(StreamDecoder<? super PacketDataSerializer, T> streamdecoder) {
        return this.readBoolean() ? Optional.of(streamdecoder.decode(this)) : Optional.empty();
    }

    @Nullable
    public <T> T readNullable(StreamDecoder<? super PacketDataSerializer, T> streamdecoder) {
        return PacketDataSerializer.readNullable(this, streamdecoder);
    }

    @Nullable
    public static <T, B extends ByteBuf> T readNullable(B b0, StreamDecoder<? super B, T> streamdecoder) {
        return b0.readBoolean() ? (T)streamdecoder.decode((B)b0) : null;
    }

    public <T> void writeNullable(@Nullable T t0, StreamEncoder<? super PacketDataSerializer, T> streamencoder) {
        PacketDataSerializer.writeNullable(this, t0, streamencoder);
    }

    public static <T, B extends ByteBuf> void writeNullable(B b0, @Nullable T t0, StreamEncoder<? super B, T> streamencoder) {
        if (t0 != null) {
            b0.writeBoolean(true);
            streamencoder.encode(b0, t0);
        } else {
            b0.writeBoolean(false);
        }
    }

    public byte[] readByteArray() {
        return PacketDataSerializer.readByteArray(this);
    }

    public static byte[] readByteArray(ByteBuf bytebuf) {
        return PacketDataSerializer.readByteArray(bytebuf, bytebuf.readableBytes());
    }

    public PacketDataSerializer writeByteArray(byte[] abyte) {
        PacketDataSerializer.writeByteArray(this, abyte);
        return this;
    }

    public static void writeByteArray(ByteBuf bytebuf, byte[] abyte) {
        VarInt.write(bytebuf, abyte.length);
        bytebuf.writeBytes(abyte);
    }

    public byte[] readByteArray(int i2) {
        return PacketDataSerializer.readByteArray(this, i2);
    }

    public static byte[] readByteArray(ByteBuf bytebuf, int i2) {
        int j2 = VarInt.read(bytebuf);
        if (j2 > i2) {
            throw new DecoderException("ByteArray with size " + j2 + " is bigger than allowed " + i2);
        }
        byte[] abyte = new byte[j2];
        bytebuf.readBytes(abyte);
        return abyte;
    }

    public PacketDataSerializer writeVarIntArray(int[] aint) {
        this.writeVarInt(aint.length);
        int[] aint1 = aint;
        int i2 = aint.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            int k2 = aint1[j2];
            this.writeVarInt(k2);
        }
        return this;
    }

    public int[] readVarIntArray() {
        return this.readVarIntArray(this.readableBytes());
    }

    public int[] readVarIntArray(int i2) {
        int j2 = this.readVarInt();
        if (j2 > i2) {
            throw new DecoderException("VarIntArray with size " + j2 + " is bigger than allowed " + i2);
        }
        int[] aint = new int[j2];
        for (int k2 = 0; k2 < aint.length; ++k2) {
            aint[k2] = this.readVarInt();
        }
        return aint;
    }

    public PacketDataSerializer writeLongArray(long[] along) {
        this.writeVarInt(along.length);
        long[] along1 = along;
        int i2 = along.length;
        for (int j2 = 0; j2 < i2; ++j2) {
            long k2 = along1[j2];
            this.writeLong(k2);
        }
        return this;
    }

    public long[] readLongArray() {
        return this.readLongArray(null);
    }

    public long[] readLongArray(@Nullable long[] along) {
        return this.readLongArray(along, this.readableBytes() / 8);
    }

    public long[] readLongArray(@Nullable long[] along, int i2) {
        int j2 = this.readVarInt();
        if (along == null || along.length != j2) {
            if (j2 > i2) {
                throw new DecoderException("LongArray with size " + j2 + " is bigger than allowed " + i2);
            }
            along = new long[j2];
        }
        for (int k2 = 0; k2 < along.length; ++k2) {
            along[k2] = this.readLong();
        }
        return along;
    }

    public BlockPosition readBlockPos() {
        return PacketDataSerializer.readBlockPos(this);
    }

    public static BlockPosition readBlockPos(ByteBuf bytebuf) {
        return BlockPosition.of(bytebuf.readLong());
    }

    public PacketDataSerializer writeBlockPos(BlockPosition blockposition) {
        PacketDataSerializer.writeBlockPos(this, blockposition);
        return this;
    }

    public static void writeBlockPos(ByteBuf bytebuf, BlockPosition blockposition) {
        bytebuf.writeLong(blockposition.asLong());
    }

    public ChunkCoordIntPair readChunkPos() {
        return new ChunkCoordIntPair(this.readLong());
    }

    public PacketDataSerializer writeChunkPos(ChunkCoordIntPair chunkcoordintpair) {
        this.writeLong(chunkcoordintpair.toLong());
        return this;
    }

    public SectionPosition readSectionPos() {
        return SectionPosition.of(this.readLong());
    }

    public PacketDataSerializer writeSectionPos(SectionPosition sectionposition) {
        this.writeLong(sectionposition.asLong());
        return this;
    }

    public GlobalPos readGlobalPos() {
        ResourceKey<World> resourcekey = this.readResourceKey(Registries.DIMENSION);
        BlockPosition blockposition = this.readBlockPos();
        return GlobalPos.of(resourcekey, blockposition);
    }

    public void writeGlobalPos(GlobalPos globalpos) {
        this.writeResourceKey(globalpos.dimension());
        this.writeBlockPos(globalpos.pos());
    }

    public Vector3f readVector3f() {
        return PacketDataSerializer.readVector3f(this);
    }

    public static Vector3f readVector3f(ByteBuf bytebuf) {
        return new Vector3f(bytebuf.readFloat(), bytebuf.readFloat(), bytebuf.readFloat());
    }

    public void writeVector3f(Vector3f vector3f) {
        PacketDataSerializer.writeVector3f(this, vector3f);
    }

    public static void writeVector3f(ByteBuf bytebuf, Vector3f vector3f) {
        bytebuf.writeFloat(vector3f.x());
        bytebuf.writeFloat(vector3f.y());
        bytebuf.writeFloat(vector3f.z());
    }

    public Quaternionf readQuaternion() {
        return PacketDataSerializer.readQuaternion(this);
    }

    public static Quaternionf readQuaternion(ByteBuf bytebuf) {
        return new Quaternionf(bytebuf.readFloat(), bytebuf.readFloat(), bytebuf.readFloat(), bytebuf.readFloat());
    }

    public void writeQuaternion(Quaternionf quaternionf) {
        PacketDataSerializer.writeQuaternion(this, quaternionf);
    }

    public static void writeQuaternion(ByteBuf bytebuf, Quaternionf quaternionf) {
        bytebuf.writeFloat(quaternionf.x);
        bytebuf.writeFloat(quaternionf.y);
        bytebuf.writeFloat(quaternionf.z);
        bytebuf.writeFloat(quaternionf.w);
    }

    public Vec3D readVec3() {
        return new Vec3D(this.readDouble(), this.readDouble(), this.readDouble());
    }

    public void writeVec3(Vec3D vec3d) {
        this.writeDouble(vec3d.x());
        this.writeDouble(vec3d.y());
        this.writeDouble(vec3d.z());
    }

    public <T extends Enum<T>> T readEnum(Class<T> oclass) {
        return (T)((Enum[])oclass.getEnumConstants())[this.readVarInt()];
    }

    public PacketDataSerializer writeEnum(Enum<?> oenum) {
        return this.writeVarInt(oenum.ordinal());
    }

    public <T> T readById(IntFunction<T> intfunction) {
        int i2 = this.readVarInt();
        return intfunction.apply(i2);
    }

    public <T> PacketDataSerializer writeById(ToIntFunction<T> tointfunction, T t0) {
        int i2 = tointfunction.applyAsInt(t0);
        return this.writeVarInt(i2);
    }

    public int readVarInt() {
        return VarInt.read(this.source);
    }

    public long readVarLong() {
        return VarLong.read(this.source);
    }

    public PacketDataSerializer writeUUID(UUID uuid) {
        PacketDataSerializer.writeUUID(this, uuid);
        return this;
    }

    public static void writeUUID(ByteBuf bytebuf, UUID uuid) {
        bytebuf.writeLong(uuid.getMostSignificantBits());
        bytebuf.writeLong(uuid.getLeastSignificantBits());
    }

    public UUID readUUID() {
        return PacketDataSerializer.readUUID(this);
    }

    public static UUID readUUID(ByteBuf bytebuf) {
        return new UUID(bytebuf.readLong(), bytebuf.readLong());
    }

    public PacketDataSerializer writeVarInt(int i2) {
        VarInt.write(this.source, i2);
        return this;
    }

    public PacketDataSerializer writeVarLong(long i2) {
        VarLong.write(this.source, i2);
        return this;
    }

    public PacketDataSerializer writeNbt(@Nullable NBTBase nbtbase) {
        PacketDataSerializer.writeNbt(this, nbtbase);
        return this;
    }

    public static void writeNbt(ByteBuf bytebuf, @Nullable NBTBase nbtbase) {
        if (nbtbase == null) {
            nbtbase = NBTTagEnd.INSTANCE;
        }
        try {
            NBTCompressedStreamTools.writeAnyTag(nbtbase, (DataOutput)new ByteBufOutputStream(bytebuf));
        }
        catch (Exception ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }

    @Nullable
    public NBTTagCompound readNbt() {
        return PacketDataSerializer.readNbt(this);
    }

    @Nullable
    public static NBTTagCompound readNbt(ByteBuf bytebuf) {
        NBTBase nbtbase = PacketDataSerializer.readNbt(bytebuf, NBTReadLimiter.create(0x200000L));
        if (nbtbase != null && !(nbtbase instanceof NBTTagCompound)) {
            throw new DecoderException("Not a compound tag: " + String.valueOf(nbtbase));
        }
        return (NBTTagCompound)nbtbase;
    }

    @Nullable
    public static NBTBase readNbt(ByteBuf bytebuf, NBTReadLimiter nbtreadlimiter) {
        try {
            NBTBase nbtbase = NBTCompressedStreamTools.readAnyTag((DataInput)new ByteBufInputStream(bytebuf), nbtreadlimiter);
            return nbtbase.getId() == 0 ? null : nbtbase;
        }
        catch (IOException ioexception) {
            throw new EncoderException((Throwable)ioexception);
        }
    }

    @Nullable
    public NBTBase readNbt(NBTReadLimiter nbtreadlimiter) {
        return PacketDataSerializer.readNbt(this, nbtreadlimiter);
    }

    public String readUtf() {
        return this.readUtf(Short.MAX_VALUE);
    }

    public String readUtf(int i2) {
        return Utf8String.read(this.source, i2);
    }

    public PacketDataSerializer writeUtf(String s2) {
        return this.writeUtf(s2, Short.MAX_VALUE);
    }

    public PacketDataSerializer writeUtf(String s2, int i2) {
        Utf8String.write(this.source, s2, i2);
        return this;
    }

    public MinecraftKey readResourceLocation() {
        return MinecraftKey.parse(this.readUtf(Short.MAX_VALUE));
    }

    public PacketDataSerializer writeResourceLocation(MinecraftKey minecraftkey) {
        this.writeUtf(minecraftkey.toString());
        return this;
    }

    public <T> ResourceKey<T> readResourceKey(ResourceKey<? extends IRegistry<T>> resourcekey) {
        MinecraftKey minecraftkey = this.readResourceLocation();
        return ResourceKey.create(resourcekey, minecraftkey);
    }

    public void writeResourceKey(ResourceKey<?> resourcekey) {
        this.writeResourceLocation(resourcekey.location());
    }

    public <T> ResourceKey<? extends IRegistry<T>> readRegistryKey() {
        MinecraftKey minecraftkey = this.readResourceLocation();
        return ResourceKey.createRegistryKey(minecraftkey);
    }

    public Date readDate() {
        return new Date(this.readLong());
    }

    public PacketDataSerializer writeDate(Date date) {
        this.writeLong(date.getTime());
        return this;
    }

    public Instant readInstant() {
        return Instant.ofEpochMilli(this.readLong());
    }

    public void writeInstant(Instant instant) {
        this.writeLong(instant.toEpochMilli());
    }

    public PublicKey readPublicKey() {
        try {
            return MinecraftEncryption.byteToPublicKey(this.readByteArray(512));
        }
        catch (CryptographyException cryptographyexception) {
            throw new DecoderException("Malformed public key bytes", (Throwable)cryptographyexception);
        }
    }

    public PacketDataSerializer writePublicKey(PublicKey publickey) {
        this.writeByteArray(publickey.getEncoded());
        return this;
    }

    public MovingObjectPositionBlock readBlockHitResult() {
        BlockPosition blockposition = this.readBlockPos();
        EnumDirection enumdirection = this.readEnum(EnumDirection.class);
        float f2 = this.readFloat();
        float f1 = this.readFloat();
        float f22 = this.readFloat();
        boolean flag = this.readBoolean();
        return new MovingObjectPositionBlock(new Vec3D((double)blockposition.getX() + (double)f2, (double)blockposition.getY() + (double)f1, (double)blockposition.getZ() + (double)f22), enumdirection, blockposition, flag);
    }

    public void writeBlockHitResult(MovingObjectPositionBlock movingobjectpositionblock) {
        BlockPosition blockposition = movingobjectpositionblock.getBlockPos();
        this.writeBlockPos(blockposition);
        this.writeEnum(movingobjectpositionblock.getDirection());
        Vec3D vec3d = movingobjectpositionblock.getLocation();
        this.writeFloat((float)(vec3d.x - (double)blockposition.getX()));
        this.writeFloat((float)(vec3d.y - (double)blockposition.getY()));
        this.writeFloat((float)(vec3d.z - (double)blockposition.getZ()));
        this.writeBoolean(movingobjectpositionblock.isInside());
    }

    public BitSet readBitSet() {
        return BitSet.valueOf(this.readLongArray());
    }

    public void writeBitSet(BitSet bitset) {
        this.writeLongArray(bitset.toLongArray());
    }

    public BitSet readFixedBitSet(int i2) {
        byte[] abyte = new byte[MathHelper.positiveCeilDiv(i2, 8)];
        this.readBytes(abyte);
        return BitSet.valueOf(abyte);
    }

    public void writeFixedBitSet(BitSet bitset, int i2) {
        if (bitset.length() > i2) {
            int j2 = bitset.length();
            throw new EncoderException("BitSet is larger than expected size (" + j2 + ">" + i2 + ")");
        }
        byte[] abyte = bitset.toByteArray();
        this.writeBytes(Arrays.copyOf(abyte, MathHelper.positiveCeilDiv(i2, 8)));
    }

    public boolean isContiguous() {
        return this.source.isContiguous();
    }

    public int maxFastWritableBytes() {
        return this.source.maxFastWritableBytes();
    }

    public int capacity() {
        return this.source.capacity();
    }

    public PacketDataSerializer capacity(int i2) {
        this.source.capacity(i2);
        return this;
    }

    public int maxCapacity() {
        return this.source.maxCapacity();
    }

    public ByteBufAllocator alloc() {
        return this.source.alloc();
    }

    public ByteOrder order() {
        return this.source.order();
    }

    public ByteBuf order(ByteOrder byteorder) {
        return this.source.order(byteorder);
    }

    public ByteBuf unwrap() {
        return this.source;
    }

    public boolean isDirect() {
        return this.source.isDirect();
    }

    public boolean isReadOnly() {
        return this.source.isReadOnly();
    }

    public ByteBuf asReadOnly() {
        return this.source.asReadOnly();
    }

    public int readerIndex() {
        return this.source.readerIndex();
    }

    public PacketDataSerializer readerIndex(int i2) {
        this.source.readerIndex(i2);
        return this;
    }

    public int writerIndex() {
        return this.source.writerIndex();
    }

    public PacketDataSerializer writerIndex(int i2) {
        this.source.writerIndex(i2);
        return this;
    }

    public PacketDataSerializer setIndex(int i2, int j2) {
        this.source.setIndex(i2, j2);
        return this;
    }

    public int readableBytes() {
        return this.source.readableBytes();
    }

    public int writableBytes() {
        return this.source.writableBytes();
    }

    public int maxWritableBytes() {
        return this.source.maxWritableBytes();
    }

    public boolean isReadable() {
        return this.source.isReadable();
    }

    public boolean isReadable(int i2) {
        return this.source.isReadable(i2);
    }

    public boolean isWritable() {
        return this.source.isWritable();
    }

    public boolean isWritable(int i2) {
        return this.source.isWritable(i2);
    }

    public PacketDataSerializer clear() {
        this.source.clear();
        return this;
    }

    public PacketDataSerializer markReaderIndex() {
        this.source.markReaderIndex();
        return this;
    }

    public PacketDataSerializer resetReaderIndex() {
        this.source.resetReaderIndex();
        return this;
    }

    public PacketDataSerializer markWriterIndex() {
        this.source.markWriterIndex();
        return this;
    }

    public PacketDataSerializer resetWriterIndex() {
        this.source.resetWriterIndex();
        return this;
    }

    public PacketDataSerializer discardReadBytes() {
        this.source.discardReadBytes();
        return this;
    }

    public PacketDataSerializer discardSomeReadBytes() {
        this.source.discardSomeReadBytes();
        return this;
    }

    public PacketDataSerializer ensureWritable(int i2) {
        this.source.ensureWritable(i2);
        return this;
    }

    public int ensureWritable(int i2, boolean flag) {
        return this.source.ensureWritable(i2, flag);
    }

    public boolean getBoolean(int i2) {
        return this.source.getBoolean(i2);
    }

    public byte getByte(int i2) {
        return this.source.getByte(i2);
    }

    public short getUnsignedByte(int i2) {
        return this.source.getUnsignedByte(i2);
    }

    public short getShort(int i2) {
        return this.source.getShort(i2);
    }

    public short getShortLE(int i2) {
        return this.source.getShortLE(i2);
    }

    public int getUnsignedShort(int i2) {
        return this.source.getUnsignedShort(i2);
    }

    public int getUnsignedShortLE(int i2) {
        return this.source.getUnsignedShortLE(i2);
    }

    public int getMedium(int i2) {
        return this.source.getMedium(i2);
    }

    public int getMediumLE(int i2) {
        return this.source.getMediumLE(i2);
    }

    public int getUnsignedMedium(int i2) {
        return this.source.getUnsignedMedium(i2);
    }

    public int getUnsignedMediumLE(int i2) {
        return this.source.getUnsignedMediumLE(i2);
    }

    public int getInt(int i2) {
        return this.source.getInt(i2);
    }

    public int getIntLE(int i2) {
        return this.source.getIntLE(i2);
    }

    public long getUnsignedInt(int i2) {
        return this.source.getUnsignedInt(i2);
    }

    public long getUnsignedIntLE(int i2) {
        return this.source.getUnsignedIntLE(i2);
    }

    public long getLong(int i2) {
        return this.source.getLong(i2);
    }

    public long getLongLE(int i2) {
        return this.source.getLongLE(i2);
    }

    public char getChar(int i2) {
        return this.source.getChar(i2);
    }

    public float getFloat(int i2) {
        return this.source.getFloat(i2);
    }

    public double getDouble(int i2) {
        return this.source.getDouble(i2);
    }

    public PacketDataSerializer getBytes(int i2, ByteBuf bytebuf) {
        this.source.getBytes(i2, bytebuf);
        return this;
    }

    public PacketDataSerializer getBytes(int i2, ByteBuf bytebuf, int j2) {
        this.source.getBytes(i2, bytebuf, j2);
        return this;
    }

    public PacketDataSerializer getBytes(int i2, ByteBuf bytebuf, int j2, int k2) {
        this.source.getBytes(i2, bytebuf, j2, k2);
        return this;
    }

    public PacketDataSerializer getBytes(int i2, byte[] abyte) {
        this.source.getBytes(i2, abyte);
        return this;
    }

    public PacketDataSerializer getBytes(int i2, byte[] abyte, int j2, int k2) {
        this.source.getBytes(i2, abyte, j2, k2);
        return this;
    }

    public PacketDataSerializer getBytes(int i2, ByteBuffer bytebuffer) {
        this.source.getBytes(i2, bytebuffer);
        return this;
    }

    public PacketDataSerializer getBytes(int i2, OutputStream outputstream, int j2) throws IOException {
        this.source.getBytes(i2, outputstream, j2);
        return this;
    }

    public int getBytes(int i2, GatheringByteChannel gatheringbytechannel, int j2) throws IOException {
        return this.source.getBytes(i2, gatheringbytechannel, j2);
    }

    public int getBytes(int i2, FileChannel filechannel, long j2, int k2) throws IOException {
        return this.source.getBytes(i2, filechannel, j2, k2);
    }

    public CharSequence getCharSequence(int i2, int j2, Charset charset) {
        return this.source.getCharSequence(i2, j2, charset);
    }

    public PacketDataSerializer setBoolean(int i2, boolean flag) {
        this.source.setBoolean(i2, flag);
        return this;
    }

    public PacketDataSerializer setByte(int i2, int j2) {
        this.source.setByte(i2, j2);
        return this;
    }

    public PacketDataSerializer setShort(int i2, int j2) {
        this.source.setShort(i2, j2);
        return this;
    }

    public PacketDataSerializer setShortLE(int i2, int j2) {
        this.source.setShortLE(i2, j2);
        return this;
    }

    public PacketDataSerializer setMedium(int i2, int j2) {
        this.source.setMedium(i2, j2);
        return this;
    }

    public PacketDataSerializer setMediumLE(int i2, int j2) {
        this.source.setMediumLE(i2, j2);
        return this;
    }

    public PacketDataSerializer setInt(int i2, int j2) {
        this.source.setInt(i2, j2);
        return this;
    }

    public PacketDataSerializer setIntLE(int i2, int j2) {
        this.source.setIntLE(i2, j2);
        return this;
    }

    public PacketDataSerializer setLong(int i2, long j2) {
        this.source.setLong(i2, j2);
        return this;
    }

    public PacketDataSerializer setLongLE(int i2, long j2) {
        this.source.setLongLE(i2, j2);
        return this;
    }

    public PacketDataSerializer setChar(int i2, int j2) {
        this.source.setChar(i2, j2);
        return this;
    }

    public PacketDataSerializer setFloat(int i2, float f2) {
        this.source.setFloat(i2, f2);
        return this;
    }

    public PacketDataSerializer setDouble(int i2, double d0) {
        this.source.setDouble(i2, d0);
        return this;
    }

    public PacketDataSerializer setBytes(int i2, ByteBuf bytebuf) {
        this.source.setBytes(i2, bytebuf);
        return this;
    }

    public PacketDataSerializer setBytes(int i2, ByteBuf bytebuf, int j2) {
        this.source.setBytes(i2, bytebuf, j2);
        return this;
    }

    public PacketDataSerializer setBytes(int i2, ByteBuf bytebuf, int j2, int k2) {
        this.source.setBytes(i2, bytebuf, j2, k2);
        return this;
    }

    public PacketDataSerializer setBytes(int i2, byte[] abyte) {
        this.source.setBytes(i2, abyte);
        return this;
    }

    public PacketDataSerializer setBytes(int i2, byte[] abyte, int j2, int k2) {
        this.source.setBytes(i2, abyte, j2, k2);
        return this;
    }

    public PacketDataSerializer setBytes(int i2, ByteBuffer bytebuffer) {
        this.source.setBytes(i2, bytebuffer);
        return this;
    }

    public int setBytes(int i2, InputStream inputstream, int j2) throws IOException {
        return this.source.setBytes(i2, inputstream, j2);
    }

    public int setBytes(int i2, ScatteringByteChannel scatteringbytechannel, int j2) throws IOException {
        return this.source.setBytes(i2, scatteringbytechannel, j2);
    }

    public int setBytes(int i2, FileChannel filechannel, long j2, int k2) throws IOException {
        return this.source.setBytes(i2, filechannel, j2, k2);
    }

    public PacketDataSerializer setZero(int i2, int j2) {
        this.source.setZero(i2, j2);
        return this;
    }

    public int setCharSequence(int i2, CharSequence charsequence, Charset charset) {
        return this.source.setCharSequence(i2, charsequence, charset);
    }

    public boolean readBoolean() {
        return this.source.readBoolean();
    }

    public byte readByte() {
        return this.source.readByte();
    }

    public short readUnsignedByte() {
        return this.source.readUnsignedByte();
    }

    public short readShort() {
        return this.source.readShort();
    }

    public short readShortLE() {
        return this.source.readShortLE();
    }

    public int readUnsignedShort() {
        return this.source.readUnsignedShort();
    }

    public int readUnsignedShortLE() {
        return this.source.readUnsignedShortLE();
    }

    public int readMedium() {
        return this.source.readMedium();
    }

    public int readMediumLE() {
        return this.source.readMediumLE();
    }

    public int readUnsignedMedium() {
        return this.source.readUnsignedMedium();
    }

    public int readUnsignedMediumLE() {
        return this.source.readUnsignedMediumLE();
    }

    public int readInt() {
        return this.source.readInt();
    }

    public int readIntLE() {
        return this.source.readIntLE();
    }

    public long readUnsignedInt() {
        return this.source.readUnsignedInt();
    }

    public long readUnsignedIntLE() {
        return this.source.readUnsignedIntLE();
    }

    public long readLong() {
        return this.source.readLong();
    }

    public long readLongLE() {
        return this.source.readLongLE();
    }

    public char readChar() {
        return this.source.readChar();
    }

    public float readFloat() {
        return this.source.readFloat();
    }

    public double readDouble() {
        return this.source.readDouble();
    }

    public ByteBuf readBytes(int i2) {
        return this.source.readBytes(i2);
    }

    public ByteBuf readSlice(int i2) {
        return this.source.readSlice(i2);
    }

    public ByteBuf readRetainedSlice(int i2) {
        return this.source.readRetainedSlice(i2);
    }

    public PacketDataSerializer readBytes(ByteBuf bytebuf) {
        this.source.readBytes(bytebuf);
        return this;
    }

    public PacketDataSerializer readBytes(ByteBuf bytebuf, int i2) {
        this.source.readBytes(bytebuf, i2);
        return this;
    }

    public PacketDataSerializer readBytes(ByteBuf bytebuf, int i2, int j2) {
        this.source.readBytes(bytebuf, i2, j2);
        return this;
    }

    public PacketDataSerializer readBytes(byte[] abyte) {
        this.source.readBytes(abyte);
        return this;
    }

    public PacketDataSerializer readBytes(byte[] abyte, int i2, int j2) {
        this.source.readBytes(abyte, i2, j2);
        return this;
    }

    public PacketDataSerializer readBytes(ByteBuffer bytebuffer) {
        this.source.readBytes(bytebuffer);
        return this;
    }

    public PacketDataSerializer readBytes(OutputStream outputstream, int i2) throws IOException {
        this.source.readBytes(outputstream, i2);
        return this;
    }

    public int readBytes(GatheringByteChannel gatheringbytechannel, int i2) throws IOException {
        return this.source.readBytes(gatheringbytechannel, i2);
    }

    public CharSequence readCharSequence(int i2, Charset charset) {
        return this.source.readCharSequence(i2, charset);
    }

    public int readBytes(FileChannel filechannel, long i2, int j2) throws IOException {
        return this.source.readBytes(filechannel, i2, j2);
    }

    public PacketDataSerializer skipBytes(int i2) {
        this.source.skipBytes(i2);
        return this;
    }

    public PacketDataSerializer writeBoolean(boolean flag) {
        this.source.writeBoolean(flag);
        return this;
    }

    public PacketDataSerializer writeByte(int i2) {
        this.source.writeByte(i2);
        return this;
    }

    public PacketDataSerializer writeShort(int i2) {
        this.source.writeShort(i2);
        return this;
    }

    public PacketDataSerializer writeShortLE(int i2) {
        this.source.writeShortLE(i2);
        return this;
    }

    public PacketDataSerializer writeMedium(int i2) {
        this.source.writeMedium(i2);
        return this;
    }

    public PacketDataSerializer writeMediumLE(int i2) {
        this.source.writeMediumLE(i2);
        return this;
    }

    public PacketDataSerializer writeInt(int i2) {
        this.source.writeInt(i2);
        return this;
    }

    public PacketDataSerializer writeIntLE(int i2) {
        this.source.writeIntLE(i2);
        return this;
    }

    public PacketDataSerializer writeLong(long i2) {
        this.source.writeLong(i2);
        return this;
    }

    public PacketDataSerializer writeLongLE(long i2) {
        this.source.writeLongLE(i2);
        return this;
    }

    public PacketDataSerializer writeChar(int i2) {
        this.source.writeChar(i2);
        return this;
    }

    public PacketDataSerializer writeFloat(float f2) {
        this.source.writeFloat(f2);
        return this;
    }

    public PacketDataSerializer writeDouble(double d0) {
        this.source.writeDouble(d0);
        return this;
    }

    public PacketDataSerializer writeBytes(ByteBuf bytebuf) {
        this.source.writeBytes(bytebuf);
        return this;
    }

    public PacketDataSerializer writeBytes(ByteBuf bytebuf, int i2) {
        this.source.writeBytes(bytebuf, i2);
        return this;
    }

    public PacketDataSerializer writeBytes(ByteBuf bytebuf, int i2, int j2) {
        this.source.writeBytes(bytebuf, i2, j2);
        return this;
    }

    public PacketDataSerializer writeBytes(byte[] abyte) {
        this.source.writeBytes(abyte);
        return this;
    }

    public PacketDataSerializer writeBytes(byte[] abyte, int i2, int j2) {
        this.source.writeBytes(abyte, i2, j2);
        return this;
    }

    public PacketDataSerializer writeBytes(ByteBuffer bytebuffer) {
        this.source.writeBytes(bytebuffer);
        return this;
    }

    public int writeBytes(InputStream inputstream, int i2) throws IOException {
        return this.source.writeBytes(inputstream, i2);
    }

    public int writeBytes(ScatteringByteChannel scatteringbytechannel, int i2) throws IOException {
        return this.source.writeBytes(scatteringbytechannel, i2);
    }

    public int writeBytes(FileChannel filechannel, long i2, int j2) throws IOException {
        return this.source.writeBytes(filechannel, i2, j2);
    }

    public PacketDataSerializer writeZero(int i2) {
        this.source.writeZero(i2);
        return this;
    }

    public int writeCharSequence(CharSequence charsequence, Charset charset) {
        return this.source.writeCharSequence(charsequence, charset);
    }

    public int indexOf(int i2, int j2, byte b0) {
        return this.source.indexOf(i2, j2, b0);
    }

    public int bytesBefore(byte b0) {
        return this.source.bytesBefore(b0);
    }

    public int bytesBefore(int i2, byte b0) {
        return this.source.bytesBefore(i2, b0);
    }

    public int bytesBefore(int i2, int j2, byte b0) {
        return this.source.bytesBefore(i2, j2, b0);
    }

    public int forEachByte(ByteProcessor byteprocessor) {
        return this.source.forEachByte(byteprocessor);
    }

    public int forEachByte(int i2, int j2, ByteProcessor byteprocessor) {
        return this.source.forEachByte(i2, j2, byteprocessor);
    }

    public int forEachByteDesc(ByteProcessor byteprocessor) {
        return this.source.forEachByteDesc(byteprocessor);
    }

    public int forEachByteDesc(int i2, int j2, ByteProcessor byteprocessor) {
        return this.source.forEachByteDesc(i2, j2, byteprocessor);
    }

    public ByteBuf copy() {
        return this.source.copy();
    }

    public ByteBuf copy(int i2, int j2) {
        return this.source.copy(i2, j2);
    }

    public ByteBuf slice() {
        return this.source.slice();
    }

    public ByteBuf retainedSlice() {
        return this.source.retainedSlice();
    }

    public ByteBuf slice(int i2, int j2) {
        return this.source.slice(i2, j2);
    }

    public ByteBuf retainedSlice(int i2, int j2) {
        return this.source.retainedSlice(i2, j2);
    }

    public ByteBuf duplicate() {
        return this.source.duplicate();
    }

    public ByteBuf retainedDuplicate() {
        return this.source.retainedDuplicate();
    }

    public int nioBufferCount() {
        return this.source.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        return this.source.nioBuffer();
    }

    public ByteBuffer nioBuffer(int i2, int j2) {
        return this.source.nioBuffer(i2, j2);
    }

    public ByteBuffer internalNioBuffer(int i2, int j2) {
        return this.source.internalNioBuffer(i2, j2);
    }

    public ByteBuffer[] nioBuffers() {
        return this.source.nioBuffers();
    }

    public ByteBuffer[] nioBuffers(int i2, int j2) {
        return this.source.nioBuffers(i2, j2);
    }

    public boolean hasArray() {
        return this.source.hasArray();
    }

    public byte[] array() {
        return this.source.array();
    }

    public int arrayOffset() {
        return this.source.arrayOffset();
    }

    public boolean hasMemoryAddress() {
        return this.source.hasMemoryAddress();
    }

    public long memoryAddress() {
        return this.source.memoryAddress();
    }

    public String toString(Charset charset) {
        return this.source.toString(charset);
    }

    public String toString(int i2, int j2, Charset charset) {
        return this.source.toString(i2, j2, charset);
    }

    public int hashCode() {
        return this.source.hashCode();
    }

    public boolean equals(Object object) {
        return this.source.equals(object);
    }

    public int compareTo(ByteBuf bytebuf) {
        return this.source.compareTo(bytebuf);
    }

    public String toString() {
        return this.source.toString();
    }

    public PacketDataSerializer retain(int i2) {
        this.source.retain(i2);
        return this;
    }

    public PacketDataSerializer retain() {
        this.source.retain();
        return this;
    }

    public PacketDataSerializer touch() {
        this.source.touch();
        return this;
    }

    public PacketDataSerializer touch(Object object) {
        this.source.touch(object);
        return this;
    }

    public int refCnt() {
        return this.source.refCnt();
    }

    public boolean release() {
        return this.source.release();
    }

    public boolean release(int i2) {
        return this.source.release(i2);
    }
}

