/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.Lifecycle;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.EnumChatFormat;

public final class ChatHexColor {
    private static final String CUSTOM_COLOR_PREFIX = "#";
    public static final Codec<ChatHexColor> CODEC = Codec.STRING.comapFlatMap(ChatHexColor::parseColor, ChatHexColor::serialize);
    private static final Map<EnumChatFormat, ChatHexColor> LEGACY_FORMAT_TO_COLOR = (Map)Stream.of(EnumChatFormat.values()).filter(EnumChatFormat::isColor).collect(ImmutableMap.toImmutableMap(Function.identity(), enumchatformat -> new ChatHexColor(enumchatformat.getColor(), enumchatformat.getName(), (EnumChatFormat)enumchatformat)));
    private static final Map<String, ChatHexColor> NAMED_COLORS = (Map)LEGACY_FORMAT_TO_COLOR.values().stream().collect(ImmutableMap.toImmutableMap(chathexcolor -> chathexcolor.name, Function.identity()));
    private final int value;
    @Nullable
    public final String name;
    @Nullable
    public final EnumChatFormat format;

    private ChatHexColor(int i2, String s2, EnumChatFormat format) {
        this.value = i2 & 0xFFFFFF;
        this.name = s2;
        this.format = format;
    }

    private ChatHexColor(int i2) {
        this.value = i2 & 0xFFFFFF;
        this.name = null;
        this.format = null;
    }

    public int getValue() {
        return this.value;
    }

    public String serialize() {
        return this.name != null ? this.name : this.formatValue();
    }

    private String formatValue() {
        return String.format(Locale.ROOT, "#%06X", this.value);
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object != null && this.getClass() == object.getClass()) {
            ChatHexColor chathexcolor = (ChatHexColor)object;
            return this.value == chathexcolor.value;
        }
        return false;
    }

    public int hashCode() {
        return Objects.hash(this.value, this.name);
    }

    public String toString() {
        return this.serialize();
    }

    @Nullable
    public static ChatHexColor fromLegacyFormat(EnumChatFormat enumchatformat) {
        return LEGACY_FORMAT_TO_COLOR.get(enumchatformat);
    }

    public static ChatHexColor fromRgb(int i2) {
        return new ChatHexColor(i2);
    }

    public static DataResult<ChatHexColor> parseColor(String s2) {
        if (s2.startsWith(CUSTOM_COLOR_PREFIX)) {
            try {
                int i2 = Integer.parseInt(s2.substring(1), 16);
                return i2 >= 0 && i2 <= 0xFFFFFF ? DataResult.success((Object)ChatHexColor.fromRgb(i2), (Lifecycle)Lifecycle.stable()) : DataResult.error(() -> "Color value out of range: " + s2);
            }
            catch (NumberFormatException numberformatexception) {
                return DataResult.error(() -> "Invalid color value: " + s2);
            }
        }
        ChatHexColor chathexcolor = NAMED_COLORS.get(s2);
        return chathexcolor == null ? DataResult.error(() -> "Invalid color name: " + s2) : DataResult.success((Object)chathexcolor, (Lifecycle)Lifecycle.stable());
    }
}

