/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import net.minecraft.commands.CommandListenerWrapper;
import net.minecraft.core.Holder;
import net.minecraft.core.IRegistry;
import net.minecraft.core.IRegistryCustom;
import net.minecraft.core.registries.Registries;
import net.minecraft.data.worldgen.BootstrapContext;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.ChatDecoration;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatBaseComponent;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;

public record ChatMessageType(ChatDecoration chat, ChatDecoration narration) {
    public static final Codec<ChatMessageType> DIRECT_CODEC = RecordCodecBuilder.create((T var0) -> var0.group((App)ChatDecoration.CODEC.fieldOf("chat").forGetter(ChatMessageType::chat), (App)ChatDecoration.CODEC.fieldOf("narration").forGetter(ChatMessageType::narration)).apply((Applicative)var0, ChatMessageType::new));
    public static final StreamCodec<RegistryFriendlyByteBuf, ChatMessageType> DIRECT_STREAM_CODEC = StreamCodec.composite(ChatDecoration.STREAM_CODEC, ChatMessageType::chat, ChatDecoration.STREAM_CODEC, ChatMessageType::narration, ChatMessageType::new);
    public static final StreamCodec<RegistryFriendlyByteBuf, Holder<ChatMessageType>> STREAM_CODEC = ByteBufCodecs.holder(Registries.CHAT_TYPE, DIRECT_STREAM_CODEC);
    public static final ChatDecoration DEFAULT_CHAT_DECORATION = ChatDecoration.withSender("chat.type.text");
    public static final ResourceKey<ChatMessageType> CHAT = ChatMessageType.create("chat");
    public static final ResourceKey<ChatMessageType> SAY_COMMAND = ChatMessageType.create("say_command");
    public static final ResourceKey<ChatMessageType> MSG_COMMAND_INCOMING = ChatMessageType.create("msg_command_incoming");
    public static final ResourceKey<ChatMessageType> MSG_COMMAND_OUTGOING = ChatMessageType.create("msg_command_outgoing");
    public static final ResourceKey<ChatMessageType> TEAM_MSG_COMMAND_INCOMING = ChatMessageType.create("team_msg_command_incoming");
    public static final ResourceKey<ChatMessageType> TEAM_MSG_COMMAND_OUTGOING = ChatMessageType.create("team_msg_command_outgoing");
    public static final ResourceKey<ChatMessageType> EMOTE_COMMAND = ChatMessageType.create("emote_command");

    private static ResourceKey<ChatMessageType> create(String var0) {
        return ResourceKey.create(Registries.CHAT_TYPE, MinecraftKey.withDefaultNamespace(var0));
    }

    public static void bootstrap(BootstrapContext<ChatMessageType> var0) {
        var0.register(CHAT, new ChatMessageType(DEFAULT_CHAT_DECORATION, ChatDecoration.withSender("chat.type.text.narrate")));
        var0.register(SAY_COMMAND, new ChatMessageType(ChatDecoration.withSender("chat.type.announcement"), ChatDecoration.withSender("chat.type.text.narrate")));
        var0.register(MSG_COMMAND_INCOMING, new ChatMessageType(ChatDecoration.incomingDirectMessage("commands.message.display.incoming"), ChatDecoration.withSender("chat.type.text.narrate")));
        var0.register(MSG_COMMAND_OUTGOING, new ChatMessageType(ChatDecoration.outgoingDirectMessage("commands.message.display.outgoing"), ChatDecoration.withSender("chat.type.text.narrate")));
        var0.register(TEAM_MSG_COMMAND_INCOMING, new ChatMessageType(ChatDecoration.teamMessage("chat.type.team.text"), ChatDecoration.withSender("chat.type.text.narrate")));
        var0.register(TEAM_MSG_COMMAND_OUTGOING, new ChatMessageType(ChatDecoration.teamMessage("chat.type.team.sent"), ChatDecoration.withSender("chat.type.text.narrate")));
        var0.register(EMOTE_COMMAND, new ChatMessageType(ChatDecoration.withSender("chat.type.emote"), ChatDecoration.withSender("chat.type.emote")));
    }

    public static a bind(ResourceKey<ChatMessageType> var0, Entity var1) {
        return ChatMessageType.bind(var0, var1.level().registryAccess(), var1.getDisplayName());
    }

    public static a bind(ResourceKey<ChatMessageType> var0, CommandListenerWrapper var1) {
        return ChatMessageType.bind(var0, var1.registryAccess(), var1.getDisplayName());
    }

    public static a bind(ResourceKey<ChatMessageType> var0, IRegistryCustom var1, IChatBaseComponent var2) {
        IRegistry<ChatMessageType> var3 = var1.registryOrThrow(Registries.CHAT_TYPE);
        return new a(var3.getHolderOrThrow(var0), var2);
    }

    public record a(Holder<ChatMessageType> chatType, IChatBaseComponent name, Optional<IChatBaseComponent> targetName) {
        public static final StreamCodec<RegistryFriendlyByteBuf, a> STREAM_CODEC = StreamCodec.composite(STREAM_CODEC, a::chatType, ComponentSerialization.TRUSTED_STREAM_CODEC, a::name, ComponentSerialization.TRUSTED_OPTIONAL_STREAM_CODEC, a::targetName, a::new);

        a(Holder<ChatMessageType> var0, IChatBaseComponent var1) {
            this(var0, var1, Optional.empty());
        }

        public IChatBaseComponent decorate(IChatBaseComponent var0) {
            return this.chatType.value().chat().decorate(var0, this);
        }

        public IChatBaseComponent decorateNarration(IChatBaseComponent var0) {
            return this.chatType.value().narration().decorate(var0, this);
        }

        public a withTargetName(IChatBaseComponent var0) {
            return new a(this.chatType, this.name, Optional.of(var0));
        }
    }
}

