/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.collect.Lists;
import com.google.common.collect.Streams;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.google.gson.JsonParser;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import com.google.gson.stream.JsonReader;
import com.mojang.brigadier.Message;
import com.mojang.serialization.JsonOps;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Type;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.ChatModifier;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.ComponentSerialization;
import net.minecraft.network.chat.IChatFormatted;
import net.minecraft.network.chat.IChatMutableComponent;
import net.minecraft.network.chat.contents.DataSource;
import net.minecraft.network.chat.contents.KeybindContents;
import net.minecraft.network.chat.contents.LiteralContents;
import net.minecraft.network.chat.contents.NbtContents;
import net.minecraft.network.chat.contents.ScoreContents;
import net.minecraft.network.chat.contents.SelectorContents;
import net.minecraft.network.chat.contents.TranslatableContents;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.util.FormattedString;
import net.minecraft.world.level.ChunkCoordIntPair;

public interface IChatBaseComponent
extends Message,
IChatFormatted,
Iterable<IChatBaseComponent> {
    default public Stream<IChatBaseComponent> stream() {
        return Streams.concat((Stream[])new Stream[]{Stream.of(this), this.getSiblings().stream().flatMap(IChatBaseComponent::stream)});
    }

    @Override
    default public Iterator<IChatBaseComponent> iterator() {
        return this.stream().iterator();
    }

    public ChatModifier getStyle();

    public ComponentContents getContents();

    @Override
    default public String getString() {
        return IChatFormatted.super.getString();
    }

    default public String getString(int i2) {
        StringBuilder stringbuilder = new StringBuilder();
        this.visit(s2 -> {
            int j2 = i2 - stringbuilder.length();
            if (j2 <= 0) {
                return STOP_ITERATION;
            }
            stringbuilder.append(s2.length() <= j2 ? s2 : s2.substring(0, j2));
            return Optional.empty();
        });
        return stringbuilder.toString();
    }

    public List<IChatBaseComponent> getSiblings();

    @Nullable
    default public String tryCollapseToString() {
        ComponentContents componentcontents = this.getContents();
        if (componentcontents instanceof LiteralContents) {
            LiteralContents literalcontents = (LiteralContents)componentcontents;
            if (this.getSiblings().isEmpty() && this.getStyle().isEmpty()) {
                return literalcontents.text();
            }
        }
        return null;
    }

    default public IChatMutableComponent plainCopy() {
        return IChatMutableComponent.create(this.getContents());
    }

    default public IChatMutableComponent copy() {
        return new IChatMutableComponent(this.getContents(), new ArrayList<IChatBaseComponent>(this.getSiblings()), this.getStyle());
    }

    public FormattedString getVisualOrderText();

    @Override
    default public <T> Optional<T> visit(IChatFormatted.b<T> ichatformatted_b, ChatModifier chatmodifier) {
        IChatBaseComponent ichatbasecomponent;
        Optional<T> optional1;
        ChatModifier chatmodifier1 = this.getStyle().applyTo(chatmodifier);
        Optional<T> optional = this.getContents().visit(ichatformatted_b, chatmodifier1);
        if (optional.isPresent()) {
            return optional;
        }
        Iterator<IChatBaseComponent> iterator = this.getSiblings().iterator();
        do {
            if (iterator.hasNext()) continue;
            return Optional.empty();
        } while (!(optional1 = (ichatbasecomponent = iterator.next()).visit(ichatformatted_b, chatmodifier1)).isPresent());
        return optional1;
    }

    @Override
    default public <T> Optional<T> visit(IChatFormatted.a<T> ichatformatted_a) {
        IChatBaseComponent ichatbasecomponent;
        Optional<T> optional1;
        Optional<T> optional = this.getContents().visit(ichatformatted_a);
        if (optional.isPresent()) {
            return optional;
        }
        Iterator<IChatBaseComponent> iterator = this.getSiblings().iterator();
        do {
            if (iterator.hasNext()) continue;
            return Optional.empty();
        } while (!(optional1 = (ichatbasecomponent = iterator.next()).visit(ichatformatted_a)).isPresent());
        return optional1;
    }

    default public List<IChatBaseComponent> toFlatList() {
        return this.toFlatList(ChatModifier.EMPTY);
    }

    default public List<IChatBaseComponent> toFlatList(ChatModifier chatmodifier) {
        ArrayList list = Lists.newArrayList();
        this.visit((chatmodifier1, s2) -> {
            if (!s2.isEmpty()) {
                list.add(IChatBaseComponent.literal(s2).withStyle(chatmodifier1));
            }
            return Optional.empty();
        }, chatmodifier);
        return list;
    }

    default public boolean contains(IChatBaseComponent ichatbasecomponent) {
        List<IChatBaseComponent> list1;
        if (this.equals(ichatbasecomponent)) {
            return true;
        }
        List<IChatBaseComponent> list = this.toFlatList();
        return Collections.indexOfSubList(list, list1 = ichatbasecomponent.toFlatList(this.getStyle())) != -1;
    }

    public static IChatBaseComponent nullToEmpty(@Nullable String s2) {
        return s2 != null ? IChatBaseComponent.literal(s2) : CommonComponents.EMPTY;
    }

    public static IChatMutableComponent literal(String s2) {
        return IChatMutableComponent.create(LiteralContents.create(s2));
    }

    public static IChatMutableComponent translatable(String s2) {
        return IChatMutableComponent.create(new TranslatableContents(s2, null, TranslatableContents.NO_ARGS));
    }

    public static IChatMutableComponent translatable(String s2, Object ... aobject) {
        return IChatMutableComponent.create(new TranslatableContents(s2, null, aobject));
    }

    public static IChatMutableComponent translatableEscape(String s2, Object ... aobject) {
        for (int i2 = 0; i2 < aobject.length; ++i2) {
            Object object = aobject[i2];
            if (TranslatableContents.isAllowedPrimitiveArgument(object) || object instanceof IChatBaseComponent) continue;
            aobject[i2] = String.valueOf(object);
        }
        return IChatBaseComponent.translatable(s2, aobject);
    }

    public static IChatMutableComponent translatableWithFallback(String s2, @Nullable String s1) {
        return IChatMutableComponent.create(new TranslatableContents(s2, s1, TranslatableContents.NO_ARGS));
    }

    public static IChatMutableComponent translatableWithFallback(String s2, @Nullable String s1, Object ... aobject) {
        return IChatMutableComponent.create(new TranslatableContents(s2, s1, aobject));
    }

    public static IChatMutableComponent empty() {
        return IChatMutableComponent.create(LiteralContents.EMPTY);
    }

    public static IChatMutableComponent keybind(String s2) {
        return IChatMutableComponent.create(new KeybindContents(s2));
    }

    public static IChatMutableComponent nbt(String s2, boolean flag, Optional<IChatBaseComponent> optional, DataSource datasource) {
        return IChatMutableComponent.create(new NbtContents(s2, flag, optional, datasource));
    }

    public static IChatMutableComponent score(String s2, String s1) {
        return IChatMutableComponent.create(new ScoreContents(s2, s1));
    }

    public static IChatMutableComponent selector(String s2, Optional<IChatBaseComponent> optional) {
        return IChatMutableComponent.create(new SelectorContents(s2, optional));
    }

    public static IChatBaseComponent translationArg(Date date) {
        return IChatBaseComponent.literal(date.toString());
    }

    public static IChatBaseComponent translationArg(Message message) {
        IChatBaseComponent object;
        if (message instanceof IChatBaseComponent) {
            IChatBaseComponent ichatbasecomponent = (IChatBaseComponent)message;
            object = ichatbasecomponent;
        } else {
            object = IChatBaseComponent.literal(message.getString());
        }
        return object;
    }

    public static IChatBaseComponent translationArg(UUID uuid) {
        return IChatBaseComponent.literal(uuid.toString());
    }

    public static IChatBaseComponent translationArg(MinecraftKey minecraftkey) {
        return IChatBaseComponent.literal(minecraftkey.toString());
    }

    public static IChatBaseComponent translationArg(ChunkCoordIntPair chunkcoordintpair) {
        return IChatBaseComponent.literal(chunkcoordintpair.toString());
    }

    public static IChatBaseComponent translationArg(URI uri) {
        return IChatBaseComponent.literal(uri.toString());
    }

    public static class ChatSerializer {
        private static final Gson GSON = new GsonBuilder().disableHtmlEscaping().create();

        private ChatSerializer() {
        }

        static IChatMutableComponent deserialize(JsonElement jsonelement, HolderLookup.a holderlookup_a) {
            return (IChatMutableComponent)ComponentSerialization.CODEC.parse(holderlookup_a.createSerializationContext(JsonOps.INSTANCE), (Object)jsonelement).getOrThrow(JsonParseException::new);
        }

        static JsonElement serialize(IChatBaseComponent ichatbasecomponent, HolderLookup.a holderlookup_a) {
            return (JsonElement)ComponentSerialization.CODEC.encodeStart(holderlookup_a.createSerializationContext(JsonOps.INSTANCE), (Object)ichatbasecomponent).getOrThrow(JsonParseException::new);
        }

        public static String toJson(IChatBaseComponent ichatbasecomponent, HolderLookup.a holderlookup_a) {
            return GSON.toJson(ChatSerializer.serialize(ichatbasecomponent, holderlookup_a));
        }

        @Nullable
        public static IChatMutableComponent fromJson(String s2, HolderLookup.a holderlookup_a) {
            JsonElement jsonelement = JsonParser.parseString((String)s2);
            return jsonelement == null ? null : ChatSerializer.deserialize(jsonelement, holderlookup_a);
        }

        @Nullable
        public static IChatMutableComponent fromJson(@Nullable JsonElement jsonelement, HolderLookup.a holderlookup_a) {
            return jsonelement == null ? null : ChatSerializer.deserialize(jsonelement, holderlookup_a);
        }

        @Nullable
        public static IChatMutableComponent fromJsonLenient(String s2, HolderLookup.a holderlookup_a) {
            JsonReader jsonreader = new JsonReader((Reader)new StringReader(s2));
            jsonreader.setLenient(true);
            JsonElement jsonelement = JsonParser.parseReader((JsonReader)jsonreader);
            return jsonelement == null ? null : ChatSerializer.deserialize(jsonelement, holderlookup_a);
        }
    }

    public static class b
    implements JsonDeserializer<IChatMutableComponent>,
    JsonSerializer<IChatBaseComponent> {
        private final HolderLookup.a registries;

        public b(HolderLookup.a holderlookup_a) {
            this.registries = holderlookup_a;
        }

        public IChatMutableComponent deserialize(JsonElement jsonelement, Type type, JsonDeserializationContext jsondeserializationcontext) throws JsonParseException {
            return ChatSerializer.deserialize(jsonelement, this.registries);
        }

        public JsonElement serialize(IChatBaseComponent ichatbasecomponent, Type type, JsonSerializationContext jsonserializationcontext) {
            return ChatSerializer.serialize(ichatbasecomponent, this.registries);
        }
    }
}

