/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import com.google.common.primitives.Ints;
import com.mojang.serialization.Codec;
import java.security.SignatureException;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import java.util.Optional;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.chat.MessageSignature;
import net.minecraft.network.chat.MessageSignatureCache;
import net.minecraft.util.SignatureUpdater;

public record LastSeenMessages(List<MessageSignature> entries) {
    public static final Codec<LastSeenMessages> CODEC = MessageSignature.CODEC.listOf().xmap(LastSeenMessages::new, LastSeenMessages::entries);
    public static LastSeenMessages EMPTY = new LastSeenMessages(List.of());
    public static final int LAST_SEEN_MESSAGES_MAX_LENGTH = 20;

    public void updateSignature(SignatureUpdater.a var0) throws SignatureException {
        var0.update(Ints.toByteArray((int)this.entries.size()));
        for (MessageSignature var2 : this.entries) {
            var0.update(var2.bytes());
        }
    }

    public a pack(MessageSignatureCache var0) {
        return new a(this.entries.stream().map(var1 -> var1.pack(var0)).toList());
    }

    public record a(List<MessageSignature.a> entries) {
        public static final a EMPTY = new a(List.of());

        public a(PacketDataSerializer var0) {
            this(var0.readCollection(PacketDataSerializer.limitValue(ArrayList::new, 20), MessageSignature.a::read));
        }

        public void write(PacketDataSerializer var0) {
            var0.writeCollection(this.entries, MessageSignature.a::write);
        }

        public Optional<LastSeenMessages> unpack(MessageSignatureCache var0) {
            ArrayList<MessageSignature> var1 = new ArrayList<MessageSignature>(this.entries.size());
            for (MessageSignature.a var3 : this.entries) {
                Optional<MessageSignature> var4 = var3.unpack(var0);
                if (var4.isEmpty()) {
                    return Optional.empty();
                }
                var1.add(var4.get());
            }
            return Optional.of(new LastSeenMessages(var1));
        }
    }

    public record b(int offset, BitSet acknowledged) {
        public b(PacketDataSerializer var0) {
            this(var0.readVarInt(), var0.readFixedBitSet(20));
        }

        public void write(PacketDataSerializer var0) {
            var0.writeVarInt(this.offset);
            var0.writeFixedBitSet(this.acknowledged, 20);
        }
    }
}

