/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.chat;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.network.chat.LastSeenMessages;
import net.minecraft.network.chat.LastSeenTrackedEntry;
import net.minecraft.network.chat.MessageSignature;

public class LastSeenMessagesValidator {
    private final int lastSeenCount;
    private final ObjectList<LastSeenTrackedEntry> trackedMessages = new ObjectArrayList();
    @Nullable
    private MessageSignature lastPendingMessage;

    public LastSeenMessagesValidator(int var0) {
        this.lastSeenCount = var0;
        for (int var1 = 0; var1 < var0; ++var1) {
            this.trackedMessages.add(null);
        }
    }

    public void addPending(MessageSignature var0) {
        if (!var0.equals(this.lastPendingMessage)) {
            this.trackedMessages.add((Object)new LastSeenTrackedEntry(var0, true));
            this.lastPendingMessage = var0;
        }
    }

    public int trackedMessagesCount() {
        return this.trackedMessages.size();
    }

    public boolean applyOffset(int var0) {
        int var1 = this.trackedMessages.size() - this.lastSeenCount;
        if (var0 >= 0 && var0 <= var1) {
            this.trackedMessages.removeElements(0, var0);
            return true;
        }
        return false;
    }

    public Optional<LastSeenMessages> applyUpdate(LastSeenMessages.b var0) {
        if (!this.applyOffset(var0.offset())) {
            return Optional.empty();
        }
        ObjectArrayList var1 = new ObjectArrayList(var0.acknowledged().cardinality());
        if (var0.acknowledged().length() > this.lastSeenCount) {
            return Optional.empty();
        }
        for (int var2 = 0; var2 < this.lastSeenCount; ++var2) {
            boolean var3 = var0.acknowledged().get(var2);
            LastSeenTrackedEntry var4 = (LastSeenTrackedEntry)this.trackedMessages.get(var2);
            if (var3) {
                if (var4 == null) {
                    return Optional.empty();
                }
                this.trackedMessages.set(var2, (Object)var4.acknowledge());
                var1.add((Object)var4.signature());
                continue;
            }
            if (var4 != null && !var4.pending()) {
                return Optional.empty();
            }
            this.trackedMessages.set(var2, null);
        }
        return Optional.of(new LastSeenMessages((List<MessageSignature>)var1));
    }
}

