/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol;

import io.netty.buffer.ByteBuf;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.network.ClientboundPacketListener;
import net.minecraft.network.EnumProtocol;
import net.minecraft.network.PacketListener;
import net.minecraft.network.ProtocolInfo;
import net.minecraft.network.ServerboundPacketListener;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.BundleDelimiterPacket;
import net.minecraft.network.protocol.BundlePacket;
import net.minecraft.network.protocol.BundlerInfo;
import net.minecraft.network.protocol.EnumProtocolDirection;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.ProtocolCodecBuilder;

public class ProtocolInfoBuilder<T extends PacketListener, B extends ByteBuf> {
    final EnumProtocol protocol;
    final EnumProtocolDirection flow;
    private final List<a<T, ?, B>> codecs = new ArrayList();
    @Nullable
    private BundlerInfo bundlerInfo;

    public ProtocolInfoBuilder(EnumProtocol var0, EnumProtocolDirection var1) {
        this.protocol = var0;
        this.flow = var1;
    }

    public <P extends Packet<? super T>> ProtocolInfoBuilder<T, B> addPacket(PacketType<P> var0, StreamCodec<? super B, P> var1) {
        this.codecs.add(new a(var0, var1));
        return this;
    }

    public <P extends BundlePacket<? super T>, D extends BundleDelimiterPacket<? super T>> ProtocolInfoBuilder<T, B> withBundlePacket(PacketType<P> var0, Function<Iterable<Packet<? super T>>, P> var1, D var2) {
        StreamCodec var3 = StreamCodec.unit(var2);
        PacketType<BundleDelimiterPacket<? super T>> var4 = var2.type();
        this.codecs.add(new a(var4, var3));
        this.bundlerInfo = BundlerInfo.createForPacket(var0, var1, var2);
        return this;
    }

    StreamCodec<ByteBuf, Packet<? super T>> buildPacketCodec(Function<ByteBuf, B> var0, List<a<T, ?, B>> var1) {
        ProtocolCodecBuilder var2 = new ProtocolCodecBuilder(this.flow);
        for (a a2 : var1) {
            a2.addToBuilder(var2, var0);
        }
        return var2.build();
    }

    public ProtocolInfo<T> build(Function<ByteBuf, B> var0) {
        return new b(this.protocol, this.flow, this.buildPacketCodec(var0, this.codecs), this.bundlerInfo);
    }

    public ProtocolInfo.a<T, B> buildUnbound() {
        final List<a<T, ?, B>> var0 = List.copyOf(this.codecs);
        final BundlerInfo var1 = this.bundlerInfo;
        return new ProtocolInfo.a<T, B>(){

            @Override
            public ProtocolInfo<T> bind(Function<ByteBuf, B> var02) {
                return new b(ProtocolInfoBuilder.this.protocol, ProtocolInfoBuilder.this.flow, ProtocolInfoBuilder.this.buildPacketCodec(var02, var0), var1);
            }

            @Override
            public EnumProtocol id() {
                return ProtocolInfoBuilder.this.protocol;
            }

            @Override
            public EnumProtocolDirection flow() {
                return ProtocolInfoBuilder.this.flow;
            }

            @Override
            public void listPackets(ProtocolInfo.a.a var02) {
                for (int var12 = 0; var12 < var0.size(); ++var12) {
                    a var2 = (a)var0.get(var12);
                    var02.accept(var2.type, var12);
                }
            }
        };
    }

    private static <L extends PacketListener, B extends ByteBuf> ProtocolInfo.a<L, B> protocol(EnumProtocol var0, EnumProtocolDirection var1, Consumer<ProtocolInfoBuilder<L, B>> var2) {
        ProtocolInfoBuilder var3 = new ProtocolInfoBuilder(var0, var1);
        var2.accept(var3);
        return var3.buildUnbound();
    }

    public static <T extends ServerboundPacketListener, B extends ByteBuf> ProtocolInfo.a<T, B> serverboundProtocol(EnumProtocol var0, Consumer<ProtocolInfoBuilder<T, B>> var1) {
        return ProtocolInfoBuilder.protocol(var0, EnumProtocolDirection.SERVERBOUND, var1);
    }

    public static <T extends ClientboundPacketListener, B extends ByteBuf> ProtocolInfo.a<T, B> clientboundProtocol(EnumProtocol var0, Consumer<ProtocolInfoBuilder<T, B>> var1) {
        return ProtocolInfoBuilder.protocol(var0, EnumProtocolDirection.CLIENTBOUND, var1);
    }

    static final class a<T extends PacketListener, P extends Packet<? super T>, B extends ByteBuf>
    extends Record {
        final PacketType<P> type;
        private final StreamCodec<? super B, P> serializer;

        a(PacketType<P> var0, StreamCodec<? super B, P> var1) {
            this.type = var0;
            this.serializer = var1;
        }

        public void addToBuilder(ProtocolCodecBuilder<ByteBuf, T> var0, Function<ByteBuf, B> var1) {
            StreamCodec<ByteBuf, P> var2 = this.serializer.mapStream(var1);
            var0.add(this.type, var2);
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{a.class, "type;serializer", "type", "serializer"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{a.class, "type;serializer", "type", "serializer"}, this);
        }

        @Override
        public final boolean equals(Object var0) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{a.class, "type;serializer", "type", "serializer"}, this, var0);
        }

        public PacketType<P> type() {
            return this.type;
        }

        public StreamCodec<? super B, P> serializer() {
            return this.serializer;
        }
    }

    record b<L extends PacketListener>(EnumProtocol id, EnumProtocolDirection flow, StreamCodec<ByteBuf, Packet<? super L>> codec, @Nullable BundlerInfo bundlerInfo) implements ProtocolInfo<L>
    {
    }
}

