/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.common.custom;

import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPosition;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.network.protocol.game.DebugEntityNameGenerator;
import net.minecraft.world.level.pathfinder.PathEntity;
import net.minecraft.world.phys.Vec3D;

public record BeeDebugPayload(a beeInfo) implements CustomPacketPayload
{
    public static final StreamCodec<PacketDataSerializer, BeeDebugPayload> STREAM_CODEC = CustomPacketPayload.codec(BeeDebugPayload::write, BeeDebugPayload::new);
    public static final CustomPacketPayload.b<BeeDebugPayload> TYPE = CustomPacketPayload.createType("debug/bee");

    private BeeDebugPayload(PacketDataSerializer var0) {
        this(new a(var0));
    }

    private void write(PacketDataSerializer var0) {
        this.beeInfo.write(var0);
    }

    public CustomPacketPayload.b<BeeDebugPayload> type() {
        return TYPE;
    }

    public record a(UUID uuid, int id, Vec3D pos, @Nullable PathEntity path, @Nullable BlockPosition hivePos, @Nullable BlockPosition flowerPos, int travelTicks, Set<String> goals, List<BlockPosition> blacklistedHives) {
        public a(PacketDataSerializer var0) {
            this(var0.readUUID(), var0.readInt(), var0.readVec3(), var0.readNullable(PathEntity::createFromStream), var0.readNullable(BlockPosition.STREAM_CODEC), var0.readNullable(BlockPosition.STREAM_CODEC), var0.readInt(), var0.readCollection(HashSet::new, PacketDataSerializer::readUtf), var0.readList(BlockPosition.STREAM_CODEC));
        }

        public void write(PacketDataSerializer var02) {
            var02.writeUUID(this.uuid);
            var02.writeInt(this.id);
            var02.writeVec3(this.pos);
            var02.writeNullable(this.path, (var0, var1) -> var1.writeToStream((PacketDataSerializer)((Object)var0)));
            var02.writeNullable(this.hivePos, BlockPosition.STREAM_CODEC);
            var02.writeNullable(this.flowerPos, BlockPosition.STREAM_CODEC);
            var02.writeInt(this.travelTicks);
            var02.writeCollection(this.goals, PacketDataSerializer::writeUtf);
            var02.writeCollection(this.blacklistedHives, BlockPosition.STREAM_CODEC);
        }

        public boolean hasHive(BlockPosition var0) {
            return Objects.equals(var0, this.hivePos);
        }

        public String generateName() {
            return DebugEntityNameGenerator.getEntityName(this.uuid);
        }

        @Override
        public String toString() {
            return this.generateName();
        }
    }
}

