/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import java.util.Optional;
import net.minecraft.core.Holder;
import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.World;
import net.minecraft.world.phys.Vec3D;

public record ClientboundDamageEventPacket(int entityId, Holder<DamageType> sourceType, int sourceCauseId, int sourceDirectId, Optional<Vec3D> sourcePosition) implements Packet<PacketListenerPlayOut>
{
    public static final StreamCodec<RegistryFriendlyByteBuf, ClientboundDamageEventPacket> STREAM_CODEC = Packet.codec(ClientboundDamageEventPacket::write, ClientboundDamageEventPacket::new);

    public ClientboundDamageEventPacket(Entity var0, DamageSource var1) {
        this(var0.getId(), var1.typeHolder(), var1.getEntity() != null ? var1.getEntity().getId() : -1, var1.getDirectEntity() != null ? var1.getDirectEntity().getId() : -1, Optional.ofNullable(var1.sourcePositionRaw()));
    }

    private ClientboundDamageEventPacket(RegistryFriendlyByteBuf var02) {
        this(var02.readVarInt(), (Holder)DamageType.STREAM_CODEC.decode(var02), ClientboundDamageEventPacket.readOptionalEntityId(var02), ClientboundDamageEventPacket.readOptionalEntityId(var02), var02.readOptional(var0 -> new Vec3D(var0.readDouble(), var0.readDouble(), var0.readDouble())));
    }

    private static void writeOptionalEntityId(PacketDataSerializer var0, int var1) {
        var0.writeVarInt(var1 + 1);
    }

    private static int readOptionalEntityId(PacketDataSerializer var0) {
        return var0.readVarInt() - 1;
    }

    private void write(RegistryFriendlyByteBuf var02) {
        var02.writeVarInt(this.entityId);
        DamageType.STREAM_CODEC.encode(var02, this.sourceType);
        ClientboundDamageEventPacket.writeOptionalEntityId(var02, this.sourceCauseId);
        ClientboundDamageEventPacket.writeOptionalEntityId(var02, this.sourceDirectId);
        var02.writeOptional(this.sourcePosition, (var0, var1) -> {
            var0.writeDouble(var1.x());
            var0.writeDouble(var1.y());
            var0.writeDouble(var1.z());
        });
    }

    @Override
    public PacketType<ClientboundDamageEventPacket> type() {
        return GamePacketTypes.CLIENTBOUND_DAMAGE_EVENT;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handleDamageEvent(this);
    }

    public DamageSource getSource(World var0) {
        if (this.sourcePosition.isPresent()) {
            return new DamageSource(this.sourceType, this.sourcePosition.get());
        }
        Entity var1 = var0.getEntity(this.sourceCauseId);
        Entity var2 = var0.getEntity(this.sourceDirectId);
        return new DamageSource(this.sourceType, var2, var1);
    }
}

