/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.world.entity.player.PlayerAbilities;

public class PacketPlayInAbilities
implements Packet<PacketListenerPlayIn> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayInAbilities> STREAM_CODEC = Packet.codec(PacketPlayInAbilities::write, PacketPlayInAbilities::new);
    private static final int FLAG_FLYING = 2;
    private final boolean isFlying;

    public PacketPlayInAbilities(PlayerAbilities var0) {
        this.isFlying = var0.flying;
    }

    private PacketPlayInAbilities(PacketDataSerializer var0) {
        byte var1 = var0.readByte();
        this.isFlying = (var1 & 2) != 0;
    }

    private void write(PacketDataSerializer var0) {
        int var1 = 0;
        if (this.isFlying) {
            var1 = (byte)(var1 | 2);
        }
        var0.writeByte(var1);
    }

    @Override
    public PacketType<PacketPlayInAbilities> type() {
        return GamePacketTypes.SERVERBOUND_PLAYER_ABILITIES;
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handlePlayerAbilities(this);
    }

    public boolean isFlying() {
        return this.isFlying;
    }
}

