/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.world.EnumHand;

public class PacketPlayInBlockPlace
implements Packet<PacketListenerPlayIn> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayInBlockPlace> STREAM_CODEC = Packet.codec(PacketPlayInBlockPlace::write, PacketPlayInBlockPlace::new);
    private final EnumHand hand;
    private final int sequence;
    private final float yRot;
    private final float xRot;
    public long timestamp;

    public PacketPlayInBlockPlace(EnumHand enumhand, int i2, float f2, float f1) {
        this.hand = enumhand;
        this.sequence = i2;
        this.yRot = f2;
        this.xRot = f1;
    }

    private PacketPlayInBlockPlace(PacketDataSerializer packetdataserializer) {
        this.timestamp = System.currentTimeMillis();
        this.hand = packetdataserializer.readEnum(EnumHand.class);
        this.sequence = packetdataserializer.readVarInt();
        this.yRot = packetdataserializer.readFloat();
        this.xRot = packetdataserializer.readFloat();
    }

    private void write(PacketDataSerializer packetdataserializer) {
        packetdataserializer.writeEnum(this.hand);
        packetdataserializer.writeVarInt(this.sequence);
        packetdataserializer.writeFloat(this.yRot);
        packetdataserializer.writeFloat(this.xRot);
    }

    @Override
    public PacketType<PacketPlayInBlockPlace> type() {
        return GamePacketTypes.SERVERBOUND_USE_ITEM;
    }

    @Override
    public void handle(PacketListenerPlayIn packetlistenerplayin) {
        packetlistenerplayin.handleUseItem(this);
    }

    public EnumHand getHand() {
        return this.hand;
    }

    public int getSequence() {
        return this.sequence;
    }

    public float getYRot() {
        return this.yRot;
    }

    public float getXRot() {
        return this.xRot;
    }
}

