/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayIn;
import net.minecraft.world.entity.Entity;

public class PacketPlayInEntityAction
implements Packet<PacketListenerPlayIn> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayInEntityAction> STREAM_CODEC = Packet.codec(PacketPlayInEntityAction::write, PacketPlayInEntityAction::new);
    private final int id;
    private final EnumPlayerAction action;
    private final int data;

    public PacketPlayInEntityAction(Entity var0, EnumPlayerAction var1) {
        this(var0, var1, 0);
    }

    public PacketPlayInEntityAction(Entity var0, EnumPlayerAction var1, int var2) {
        this.id = var0.getId();
        this.action = var1;
        this.data = var2;
    }

    private PacketPlayInEntityAction(PacketDataSerializer var0) {
        this.id = var0.readVarInt();
        this.action = var0.readEnum(EnumPlayerAction.class);
        this.data = var0.readVarInt();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeVarInt(this.id);
        var0.writeEnum(this.action);
        var0.writeVarInt(this.data);
    }

    @Override
    public PacketType<PacketPlayInEntityAction> type() {
        return GamePacketTypes.SERVERBOUND_PLAYER_COMMAND;
    }

    @Override
    public void handle(PacketListenerPlayIn var0) {
        var0.handlePlayerCommand(this);
    }

    public int getId() {
        return this.id;
    }

    public EnumPlayerAction getAction() {
        return this.action;
    }

    public int getData() {
        return this.data;
    }

    public static final class EnumPlayerAction
    extends Enum<EnumPlayerAction> {
        public static final /* enum */ EnumPlayerAction PRESS_SHIFT_KEY = new EnumPlayerAction();
        public static final /* enum */ EnumPlayerAction RELEASE_SHIFT_KEY = new EnumPlayerAction();
        public static final /* enum */ EnumPlayerAction STOP_SLEEPING = new EnumPlayerAction();
        public static final /* enum */ EnumPlayerAction START_SPRINTING = new EnumPlayerAction();
        public static final /* enum */ EnumPlayerAction STOP_SPRINTING = new EnumPlayerAction();
        public static final /* enum */ EnumPlayerAction START_RIDING_JUMP = new EnumPlayerAction();
        public static final /* enum */ EnumPlayerAction STOP_RIDING_JUMP = new EnumPlayerAction();
        public static final /* enum */ EnumPlayerAction OPEN_INVENTORY = new EnumPlayerAction();
        public static final /* enum */ EnumPlayerAction START_FALL_FLYING = new EnumPlayerAction();
        private static final /* synthetic */ EnumPlayerAction[] j;

        public static EnumPlayerAction[] values() {
            return (EnumPlayerAction[])j.clone();
        }

        public static EnumPlayerAction valueOf(String var0) {
            return Enum.valueOf(EnumPlayerAction.class, var0);
        }

        private static /* synthetic */ EnumPlayerAction[] a() {
            return new EnumPlayerAction[]{PRESS_SHIFT_KEY, RELEASE_SHIFT_KEY, STOP_SLEEPING, START_SPRINTING, STOP_SPRINTING, START_RIDING_JUMP, STOP_RIDING_JUMP, OPEN_INVENTORY, START_FALL_FLYING};
        }

        static {
            j = EnumPlayerAction.a();
        }
    }
}

