/*
 * Decompiled with CFR 0.152.
 */
package net.minecraft.network.protocol.game;

import net.minecraft.network.PacketDataSerializer;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketType;
import net.minecraft.network.protocol.game.GamePacketTypes;
import net.minecraft.network.protocol.game.PacketListenerPlayOut;
import net.minecraft.resources.MinecraftKey;
import net.minecraft.world.item.crafting.RecipeHolder;

public class PacketPlayOutAutoRecipe
implements Packet<PacketListenerPlayOut> {
    public static final StreamCodec<PacketDataSerializer, PacketPlayOutAutoRecipe> STREAM_CODEC = Packet.codec(PacketPlayOutAutoRecipe::write, PacketPlayOutAutoRecipe::new);
    private final int containerId;
    private final MinecraftKey recipe;

    public PacketPlayOutAutoRecipe(int var0, RecipeHolder<?> var1) {
        this.containerId = var0;
        this.recipe = var1.id();
    }

    private PacketPlayOutAutoRecipe(PacketDataSerializer var0) {
        this.containerId = var0.readByte();
        this.recipe = var0.readResourceLocation();
    }

    private void write(PacketDataSerializer var0) {
        var0.writeByte(this.containerId);
        var0.writeResourceLocation(this.recipe);
    }

    @Override
    public PacketType<PacketPlayOutAutoRecipe> type() {
        return GamePacketTypes.CLIENTBOUND_PLACE_GHOST_RECIPE;
    }

    @Override
    public void handle(PacketListenerPlayOut var0) {
        var0.handlePlaceRecipe(this);
    }

    public MinecraftKey getRecipe() {
        return this.recipe;
    }

    public int getContainerId() {
        return this.containerId;
    }
}

